/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.sun.jna.Platform;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

public class GeneralSettingsPanel
extends ScrollablePanel {
    private static final long serialVersionUID = 500841588272296493L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralSettingsPanel.class);
    private static final Integer[] DEFAULT_FONT_SIZES = new Integer[]{12, 14, 16, 18, 20, 22, 24, 26, 28};
    private static final Pattern MEMORY_PATTERN = Pattern.compile("-Xmx([0-9]*)(.)");
    private Settings settings = Settings.getInstance();
    private List<LocaleComboBox> locales = new ArrayList<LocaleComboBox>();
    private JTextField tfProxyHost;
    private JTextField tfProxyPort;
    private JTextField tfProxyUsername;
    private JPasswordField tfProxyPassword;
    private JComboBox cbImageCacheQuality;
    private JCheckBox chckbxImageCache;
    private JComboBox cbLanguage;
    private JTextField tfMediaPlayer;
    private JButton btnSearchMediaPlayer;
    private JTextPane tpMediaPlayer;
    private JTextPane tpFontHint;
    private JComboBox cbFontSize;
    private JComboBox cbFontFamily;
    private JCheckBox chckbxDeleteTrash;
    private JSlider sliderMemory;
    private JTextPane tpMemoryHint;
    private LinkLabel lblLinkTransifex;
    private JCheckBox chckbxAnalytics;
    private JLabel lblLanguageHint;
    private JLabel lblFontChangeHint;
    private JLabel lblMemory;

    public GeneralSettingsPanel() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"left:max(200px;min):grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(200px;default):grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JPanel panelUI = new JPanel();
        panelUI.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.ui"), 4, 2, null, null));
        this.add((Component)panelUI, "2, 2, 3, 1, fill, fill");
        panelUI.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100dlu"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.UNRELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.UNRELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        LocaleComboBox actualLocale = null;
        Locale settingsLang = Utils.getLocaleFromLanguage(Globals.settings.getLanguage());
        for (Locale l : Utils.getLanguages()) {
            LocaleComboBox localeComboBox = new LocaleComboBox(l);
            this.locales.add(localeComboBox);
            if (!l.equals(settingsLang)) continue;
            actualLocale = localeComboBox;
        }
        JLabel lblUiLanguage = new JLabel(BUNDLE.getString("Settings.language"));
        panelUI.add((Component)lblUiLanguage, "2, 2");
        this.cbLanguage = new JComboBox<Object>(this.locales.toArray());
        panelUI.add((Component)this.cbLanguage, "4, 2");
        if (actualLocale != null) {
            this.cbLanguage.setSelectedItem(actualLocale);
        }
        JSeparator separator = new JSeparator();
        separator.setOrientation(1);
        panelUI.add((Component)separator, "8, 2, 1, 7");
        JLabel lblFontFamily = new JLabel(BUNDLE.getString("Settings.fontfamily"));
        panelUI.add((Component)lblFontFamily, "10, 2, right, default");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.cbFontFamily = new JComboBox<String>(env.getAvailableFontFamilyNames());
        this.cbFontFamily.setSelectedItem(Globals.settings.getFontFamily());
        int index = this.cbFontFamily.getSelectedIndex();
        if (index < 0) {
            this.cbFontFamily.setSelectedItem("Dialog");
            index = this.cbFontFamily.getSelectedIndex();
        }
        if (index < 0) {
            this.cbFontFamily.setSelectedIndex(0);
        }
        panelUI.add((Component)this.cbFontFamily, "12, 2, fill, default");
        JLabel lblFontSize = new JLabel(BUNDLE.getString("Settings.fontsize"));
        panelUI.add((Component)lblFontSize, "10, 4, right, default");
        this.cbFontSize = new JComboBox<Integer>(DEFAULT_FONT_SIZES);
        this.cbFontSize.setSelectedItem(Globals.settings.getFontSize());
        index = this.cbFontSize.getSelectedIndex();
        if (index < 0) {
            this.cbFontSize.setSelectedIndex(0);
        }
        panelUI.add((Component)this.cbFontSize, "12, 4, fill, default");
        JPanel panel = new JPanel();
        panelUI.add((Component)panel, "2, 6, 5, 1, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100dlu"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JLabel lblMissingTranslation = new JLabel(BUNDLE.getString("tmm.helptranslate"));
        panel.add((Component)lblMissingTranslation, "1, 1, 5, 1");
        this.lblLinkTransifex = new LinkLabel("https://www.transifex.com/projects/p/tinymediamanager/");
        panel.add((Component)this.lblLinkTransifex, "1, 3, 5, 1");
        this.lblLinkTransifex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    TmmUIHelper.browseUrl(GeneralSettingsPanel.this.lblLinkTransifex.getNormalText());
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)GeneralSettingsPanel.this.lblLinkTransifex.getNormalText(), "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        });
        this.tpFontHint = new JTextPane();
        this.tpFontHint.setOpaque(false);
        TmmFontHelper.changeFont((JComponent)this.tpFontHint, 0.833);
        this.tpFontHint.setText(BUNDLE.getString("Settings.fonts.hint"));
        panelUI.add((Component)this.tpFontHint, "10, 6, 5, 1");
        this.lblLanguageHint = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblLanguageHint, 1);
        panelUI.add((Component)this.lblLanguageHint, "2, 8, 5, 1");
        this.lblFontChangeHint = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblFontChangeHint, 1);
        panelUI.add((Component)this.lblFontChangeHint, "10, 8, 5, 1");
        JPanel panelMemory = new JPanel();
        panelMemory.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.memoryborder"), 4, 2, null, null));
        this.add((Component)panelMemory, "2, 4, fill, fill");
        panelMemory.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"250px:grow(4)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(20dlu;default)"), ColumnSpec.decode((String)"left:default:grow(5)")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblMemoryT = new JLabel(BUNDLE.getString("Settings.memory"));
        panelMemory.add((Component)lblMemoryT, "2, 1");
        this.sliderMemory = new JSlider();
        this.sliderMemory.setPaintLabels(true);
        this.sliderMemory.setPaintTicks(true);
        this.sliderMemory.setSnapToTicks(true);
        this.sliderMemory.setMajorTickSpacing(512);
        this.sliderMemory.setMinorTickSpacing(128);
        this.sliderMemory.setMinimum(256);
        if (Platform.is64Bit()) {
            this.sliderMemory.setMaximum(2560);
        } else {
            this.sliderMemory.setMaximum(1536);
        }
        this.sliderMemory.setValue(512);
        panelMemory.add((Component)this.sliderMemory, "4, 1, fill, default");
        this.lblMemory = new JLabel("512");
        panelMemory.add((Component)this.lblMemory, "6, 1, right, default");
        JLabel lblMb = new JLabel("MB");
        panelMemory.add((Component)lblMb, "7, 1, left, default");
        this.tpMemoryHint = new JTextPane();
        this.tpMemoryHint.setOpaque(false);
        this.tpMemoryHint.setText(BUNDLE.getString("Settings.memory.hint"));
        TmmFontHelper.changeFont((JComponent)this.tpMemoryHint, 0.833);
        panelMemory.add((Component)this.tpMemoryHint, "2, 3, 6, 1, fill, fill");
        JPanel panelProxySettings = new JPanel();
        panelProxySettings.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.proxy"), 4, 2, null, null));
        this.add((Component)panelProxySettings, "4, 4, fill, fill");
        panelProxySettings.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblProxyHost = new JLabel(BUNDLE.getString("Settings.proxyhost"));
        panelProxySettings.add((Component)lblProxyHost, "2, 2, right, default");
        this.tfProxyHost = new JTextField();
        lblProxyHost.setLabelFor(this.tfProxyHost);
        panelProxySettings.add((Component)this.tfProxyHost, "4, 2, fill, default");
        this.tfProxyHost.setColumns(10);
        JLabel lblProxyPort = new JLabel(BUNDLE.getString("Settings.proxyport"));
        panelProxySettings.add((Component)lblProxyPort, "2, 4, right, default");
        this.tfProxyPort = new JTextField();
        lblProxyPort.setLabelFor(this.tfProxyPort);
        panelProxySettings.add((Component)this.tfProxyPort, "4, 4, fill, default");
        this.tfProxyPort.setColumns(10);
        JLabel lblProxyUser = new JLabel(BUNDLE.getString("Settings.proxyuser"));
        panelProxySettings.add((Component)lblProxyUser, "2, 6, right, default");
        this.tfProxyUsername = new JTextField();
        lblProxyUser.setLabelFor(this.tfProxyUsername);
        panelProxySettings.add((Component)this.tfProxyUsername, "4, 6, fill, default");
        this.tfProxyUsername.setColumns(10);
        JLabel lblProxyPassword = new JLabel(BUNDLE.getString("Settings.proxypass"));
        panelProxySettings.add((Component)lblProxyPassword, "2, 8, right, default");
        this.tfProxyPassword = new JPasswordField();
        lblProxyPassword.setLabelFor(this.tfProxyPassword);
        panelProxySettings.add((Component)this.tfProxyPassword, "4, 8, fill, default");
        JPanel panelMediaPlayer = new JPanel();
        panelMediaPlayer.setBorder(new TitledBorder(null, "MediaPlayer", 4, 2, null, null));
        this.add((Component)panelMediaPlayer, "2, 6, fill, fill");
        panelMediaPlayer.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        this.tpMediaPlayer = new JTextPane();
        this.tpMediaPlayer.setOpaque(false);
        TmmFontHelper.changeFont((JComponent)this.tpMediaPlayer, 0.833);
        this.tpMediaPlayer.setText(BUNDLE.getString("Settings.mediaplayer.hint"));
        panelMediaPlayer.add((Component)this.tpMediaPlayer, "2, 2, 3, 1, fill, fill");
        this.tfMediaPlayer = new JTextField();
        panelMediaPlayer.add((Component)this.tfMediaPlayer, "2, 4, fill, default");
        this.tfMediaPlayer.setColumns(10);
        this.btnSearchMediaPlayer = new JButton(BUNDLE.getString("Button.chooseplayer"));
        this.btnSearchMediaPlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String path = TmmProperties.getInstance().getProperty("chooseplayer.path");
                Path file = TmmUIHelper.selectFile(BUNDLE.getString("Button.chooseplayer"), path);
                if (file != null && Utils.isRegularFile(file) || Platform.isMac()) {
                    GeneralSettingsPanel.this.tfMediaPlayer.setText(file.toAbsolutePath().toString());
                    TmmProperties.getInstance().putProperty("chooseplayer.path", file.toAbsolutePath().toString());
                }
            }
        });
        panelMediaPlayer.add((Component)this.btnSearchMediaPlayer, "4, 4");
        JPanel panelCache = new JPanel();
        panelCache.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.cache"), 4, 2, null, null));
        this.add((Component)panelCache, "4, 6, fill, fill");
        panelCache.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        this.chckbxImageCache = new JCheckBox(BUNDLE.getString("Settings.imagecache"));
        panelCache.add((Component)this.chckbxImageCache, "2, 2, 3, 1");
        JLabel lblImageCacheQuality = new JLabel(BUNDLE.getString("Settings.imagecachetype"));
        panelCache.add((Component)lblImageCacheQuality, "2, 4, right, default");
        this.cbImageCacheQuality = new JComboBox<ImageCache.CacheType>(ImageCache.CacheType.values());
        panelCache.add((Component)this.cbImageCacheQuality, "4, 4, fill, default");
        JPanel panelAnalytics = new JPanel();
        panelAnalytics.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.analytics.border"), 4, 2, null, null));
        this.add((Component)panelAnalytics, "2, 8, fill, fill");
        panelAnalytics.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC}));
        this.chckbxAnalytics = new JCheckBox(BUNDLE.getString("Settings.analytics"));
        panelAnalytics.add((Component)this.chckbxAnalytics, "2, 2");
        JTextPane tpAnalyticsDescription = new JTextPane();
        tpAnalyticsDescription.setText(BUNDLE.getString("Settings.analytics.desc"));
        tpAnalyticsDescription.setOpaque(false);
        panelAnalytics.add((Component)tpAnalyticsDescription, "2, 4, fill, fill");
        JPanel panelMisc = new JPanel();
        panelMisc.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.misc"), 4, 2, null, null));
        this.add((Component)panelMisc, "4, 8, fill, fill");
        panelMisc.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        this.chckbxDeleteTrash = new JCheckBox(BUNDLE.getString("Settings.deletetrash"));
        panelMisc.add((Component)this.chckbxDeleteTrash, "2, 2, 3, 1");
        this.initDataBindings();
        this.initMemorySlider();
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GeneralSettingsPanel.this.checkChanges();
            }
        };
        this.cbLanguage.addItemListener(listener);
        this.cbFontSize.addItemListener(listener);
        this.cbFontFamily.addItemListener(listener);
    }

    private void checkChanges() {
        String fontFamily;
        Integer fontSize;
        Locale actualLocale;
        LocaleComboBox loc = (LocaleComboBox)this.cbLanguage.getSelectedItem();
        Locale locale = loc.loc;
        if (!locale.equals(actualLocale = Utils.getLocaleFromLanguage(Globals.settings.getLanguage()))) {
            Globals.settings.setLanguage(locale.toString());
            this.lblLanguageHint.setText(BUNDLE.getString("Settings.languagehint"));
        }
        if ((fontSize = (Integer)this.cbFontSize.getSelectedItem()).intValue() != Globals.settings.getFontSize()) {
            Globals.settings.setFontSize(fontSize);
            this.lblFontChangeHint.setText(BUNDLE.getString("Settings.fontchangehint"));
        }
        if (!(fontFamily = (String)this.cbFontFamily.getSelectedItem()).equals(Globals.settings.getFontFamily())) {
            Globals.settings.setFontFamily(fontFamily);
            this.lblFontChangeHint.setText(BUNDLE.getString("Settings.fontchangehint"));
        }
    }

    private void initMemorySlider() {
        Path file = Paths.get("extra.txt", new String[0]);
        int maxMemory = 512;
        if (Files.exists(file, new LinkOption[0])) {
            try {
                String extraTxt = Utils.readFileToString(file);
                Matcher matcher = MEMORY_PATTERN.matcher(extraTxt);
                if (matcher.find()) {
                    maxMemory = Integer.parseInt(matcher.group(1));
                    String dimension = matcher.group(2);
                    if ("k".equalsIgnoreCase(dimension)) {
                        maxMemory /= 1024;
                    }
                    if ("g".equalsIgnoreCase(dimension)) {
                        maxMemory *= 1024;
                    }
                }
            }
            catch (Exception e) {
                maxMemory = 512;
            }
        }
        this.sliderMemory.setValue(maxMemory);
        this.addHierarchyListener(new HierarchyListener(){
            private boolean oldState = false;

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (this.oldState != GeneralSettingsPanel.this.isShowing()) {
                    this.oldState = GeneralSettingsPanel.this.isShowing();
                    if (!GeneralSettingsPanel.this.isShowing()) {
                        GeneralSettingsPanel.this.writeMemorySettings();
                    }
                }
            }
        });
    }

    private void writeMemorySettings() {
        int memoryAmount = this.sliderMemory.getValue();
        String jvmArg = "-Xmx" + memoryAmount + "m";
        if (memoryAmount == 512) {
            jvmArg = "";
        }
        Path file = Paths.get("extra.txt", new String[0]);
        if (memoryAmount != 512 && !Files.exists(file, new LinkOption[0])) {
            try {
                Utils.writeStringToFile(file, jvmArg);
            }
            catch (IOException e) {}
        } else if (Files.exists(file, new LinkOption[0])) {
            try {
                String extraTxt = Utils.readFileToString(file);
                Matcher matcher = MEMORY_PATTERN.matcher(extraTxt);
                extraTxt = matcher.find() ? extraTxt.replace(matcher.group(0), jvmArg) : extraTxt + "\r\n" + jvmArg;
                if (StringUtils.isBlank((CharSequence)extraTxt)) {
                    Utils.deleteFileSafely(file);
                } else {
                    Utils.writeStringToFile(file, extraTxt);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"proxyHost");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.tfProxyHost, (Property)jTextFieldBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"proxyPort");
        BeanProperty jTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.tfProxyPort, (Property)jTextFieldBeanProperty_1);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"proxyUsername");
        BeanProperty jTextFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.tfProxyUsername, (Property)jTextFieldBeanProperty_2);
        autoBinding_2.bind();
        BeanProperty settingsBeanProperty_3 = BeanProperty.create((String)"proxyPassword");
        BeanProperty jPasswordFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_3, (Object)this.tfProxyPassword, (Property)jPasswordFieldBeanProperty);
        autoBinding_3.bind();
        BeanProperty settingsBeanProperty_7 = BeanProperty.create((String)"imageCacheType");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_7, (Object)this.cbImageCacheQuality, (Property)jComboBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"imageCache");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, (Object)this.chckbxImageCache, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"mediaPlayer");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (Object)this.tfMediaPlayer, (Property)jTextFieldBeanProperty_3);
        autoBinding_9.bind();
        BeanProperty settingsBeanProperty_10 = BeanProperty.create((String)"deleteTrashOnExit");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_10, (Object)this.chckbxDeleteTrash, (Property)jCheckBoxBeanProperty);
        autoBinding_10.bind();
        BeanProperty jSliderBeanProperty = BeanProperty.create((String)"value");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.sliderMemory, (Property)jSliderBeanProperty, (Object)this.lblMemory, (Property)jLabelBeanProperty);
        autoBinding_11.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"enableAnalytics");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, (Object)this.chckbxAnalytics, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
    }

    public static class LocaleComboBox {
        private Locale loc;
        private List<Locale> countries;

        public LocaleComboBox(Locale loc) {
            this.loc = loc;
            this.countries = LocaleUtils.countriesByLanguage((String)loc.getLanguage().toLowerCase(Locale.ROOT));
        }

        public Locale getLocale() {
            return this.loc;
        }

        public String toString() {
            if (this.loc.getLanguage().equalsIgnoreCase(this.loc.getCountry())) {
                return this.loc.getDisplayLanguage(this.loc);
            }
            if (this.loc.toString().equals("en_US")) {
                return this.loc.getDisplayLanguage(this.loc);
            }
            if (this.countries.size() == 1) {
                return this.loc.getDisplayLanguage(this.loc);
            }
            if (StringUtils.isNotBlank((CharSequence)this.loc.getDisplayCountry(this.loc))) {
                return this.loc.getDisplayLanguage(this.loc) + " (" + this.loc.getDisplayCountry(this.loc) + ")";
            }
            return this.loc.getDisplayLanguage(this.loc);
        }
    }
}

