/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class LinkLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private String text;

    public LinkLabel(String text) {
        super(text);
        if (Desktop.isDesktopSupported()) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.enableEvents(16L);
        }
    }

    @Override
    public void setText(String text) {
        if (Desktop.isDesktopSupported()) {
            super.setText("<html><font color=\"#0000CF\"><u>" + text + "</u></font></html>");
        } else {
            super.setText(text);
        }
        this.text = text;
    }

    public String getNormalText() {
        return this.text;
    }

    @Override
    protected void processMouseEvent(MouseEvent evt) {
        super.processMouseEvent(evt);
        if (evt.getID() == 500) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getNormalText()));
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    protected void fireActionPerformed(ActionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ActionListener.class) continue;
            ActionListener listener = (ActionListener)listeners[i + 1];
            listener.actionPerformed(evt);
        }
    }
}

