/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.tinymediamanager.core.AbstractModelObject;

public class MediaFileAudioStream
extends AbstractModelObject {
    @JsonProperty
    private String codec = "";
    @JsonProperty
    private String channels = "";
    @JsonProperty
    private int bitrate = 0;
    @JsonProperty
    private String language = "";

    public String getCodec() {
        return this.codec;
    }

    public String getChannels() {
        return this.channels;
    }

    public int getChannelsAsInt() {
        int highest = 0;
        if (!this.channels.isEmpty()) {
            try {
                String[] parts;
                String part = this.channels.replaceAll("[a-zA-Z]", "");
                for (String p : parts = part.split("/")) {
                    String[] c;
                    int ch = 0;
                    for (String s : c = p.split("[^0-9]")) {
                        if (!s.matches("[0-9]+")) continue;
                        ch += Integer.parseInt(s);
                    }
                    if (ch <= highest) continue;
                    highest = ch;
                }
            }
            catch (NumberFormatException e) {
                highest = 0;
            }
        }
        return highest;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public String getBitrateInKbps() {
        return this.bitrate + " kbps";
    }

    public String getLanguage() {
        return this.language;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public void setChannels(String channels) {
        this.channels = channels;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

