/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.util.Locale;
import javax.swing.text.BadLocationException;
import org.japura.gui.model.NumberDocument;

public class IntegerDocument
extends NumberDocument<Integer> {
    private static final long serialVersionUID = -6161711707235392895L;

    public IntegerDocument() {
        this((Locale)null);
    }

    public IntegerDocument(Locale locale) {
        super(locale, false);
        this.maxValue = Integer.MAX_VALUE;
        this.minValue = Integer.MIN_VALUE;
    }

    public Integer getValue() {
        try {
            Integer value;
            Number number;
            String text = this.getText();
            if (text.matches(this.getValidateRegex()) && (number = this.parse(text)) != null && (value = Integer.valueOf(number.intValue())) >= (Integer)this.minValue && value <= (Integer)this.maxValue) {
                return value;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setValue(int value) {
        String text = this.format(value);
        try {
            this.remove(0, this.getLength());
            this.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public int getMaxValue() {
        return (Integer)this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getMinValue() {
        return (Integer)this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    @Override
    protected boolean isAcceptableValue(Number number) {
        int value = number.intValue();
        return value >= this.getMinValue() && value <= this.getMaxValue();
    }
}

