/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.japura.gui.dialogs.ButtonsPanel;
import org.japura.gui.dialogs.ContentPanel;
import org.japura.gui.dialogs.CustomDialog;
import org.japura.gui.dialogs.DialogBuilder;

public class DefaultDialogBuilder
extends DialogBuilder {
    @Override
    public JDialog buildDialog(final CustomDialog customDialog) {
        final JDialog dialog = new JDialog();
        ActionListener escListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        };
        dialog.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
        dialog.setTitle(customDialog.getTitle());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 0));
        panel.setOpaque(false);
        if (customDialog.getDialogIcon() != null) {
            BufferedImage image = new BufferedImage(customDialog.getDialogIcon().getIconWidth(), customDialog.getDialogIcon().getIconHeight(), 2);
            customDialog.getDialogIcon().paintIcon(null, image.getGraphics(), 0, 0);
            dialog.setIconImage(image);
        }
        if (customDialog.getMessageIcon() != null) {
            JPanel iconPanel = new JPanel();
            iconPanel.setOpaque(false);
            iconPanel.setLayout((LayoutManager)new MigLayout("ins 5 5 5 0"));
            iconPanel.add(new JLabel(customDialog.getMessageIcon()));
            panel.add((Component)iconPanel, "West");
        }
        LinkedHashMap<Component, Integer> contents = customDialog.getContents();
        JScrollPane sp = new JScrollPane(new ContentPanel(contents));
        sp.getViewport().setOpaque(false);
        sp.setOpaque(false);
        sp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(sp);
        ButtonsPanel buttonsPanel = new ButtonsPanel();
        for (int i = 0; i < customDialog.getButtonsCount(); ++i) {
            JButton button = customDialog.getButton(i);
            buttonsPanel.add(button);
        }
        panel.add((Component)buttonsPanel, "South");
        dialog.add(panel);
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                JButton button;
                if (customDialog.getFocusedButton() != null && (button = customDialog.getButton(customDialog.getFocusedButton())) != null) {
                    button.requestFocus();
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                Integer index = customDialog.getDefaultButtonForDialogClose();
                if (index != null && customDialog.getButton(index) != null) {
                    customDialog.setResult(index);
                } else {
                    customDialog.setResult(null);
                }
                dialog.dispose();
            }
        });
        return dialog;
    }
}

