/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaEntityImageFetcherTask;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieFanartNaming;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MoviePosterNaming;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieExtraImageFetcher;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public class MovieArtworkHelper {
    public static void downloadArtwork(Movie movie, MediaFileType type) {
        switch (type) {
            case FANART: {
                MovieArtworkHelper.downloadFanart(movie);
                break;
            }
            case POSTER: {
                MovieArtworkHelper.downloadPoster(movie);
                break;
            }
            case EXTRAFANART: 
            case EXTRATHUMB: 
            case LOGO: 
            case CLEARLOGO: 
            case BANNER: 
            case CLEARART: 
            case THUMB: 
            case DISCART: {
                MovieArtworkHelper.downloadExtraArtwork(movie, type);
                break;
            }
        }
    }

    public static void downloadMissingArtwork(Movie movie) {
        MovieArtworkHelper.downloadMissingArtwork(movie, false);
    }

    public static void downloadMissingArtwork(Movie movie, boolean force) {
        MediaFileType[] mfts;
        block11: for (MediaFileType mft : mfts = MediaFileType.getGraphicMediaFileTypes()) {
            List<MediaFile> mfs = movie.getMediaFiles(mft);
            if (!mfs.isEmpty()) continue;
            switch (mft) {
                case FANART: {
                    if (MovieModuleManager.MOVIE_SETTINGS.getMovieFanartFilenames().isEmpty() && !force) continue block11;
                    MovieArtworkHelper.downloadFanart(movie);
                    continue block11;
                }
                case POSTER: {
                    if (MovieModuleManager.MOVIE_SETTINGS.getMoviePosterFilenames().isEmpty() && !force) continue block11;
                    MovieArtworkHelper.downloadPoster(movie);
                    continue block11;
                }
                case BANNER: {
                    if (!MovieModuleManager.MOVIE_SETTINGS.isImageBanner() && !force) continue block11;
                    MovieArtworkHelper.downloadExtraArtwork(movie, mft);
                    continue block11;
                }
                case CLEARART: {
                    if (!MovieModuleManager.MOVIE_SETTINGS.isImageClearart() && !force) continue block11;
                    MovieArtworkHelper.downloadExtraArtwork(movie, mft);
                    continue block11;
                }
                case DISCART: {
                    if (!MovieModuleManager.MOVIE_SETTINGS.isImageDiscart() && !force) continue block11;
                    MovieArtworkHelper.downloadExtraArtwork(movie, mft);
                    continue block11;
                }
                case LOGO: 
                case CLEARLOGO: {
                    if (!MovieModuleManager.MOVIE_SETTINGS.isImageLogo() && !force) continue block11;
                    MovieArtworkHelper.downloadExtraArtwork(movie, mft);
                    continue block11;
                }
                case THUMB: {
                    if (!MovieModuleManager.MOVIE_SETTINGS.isImageThumb() && !force) continue block11;
                    MovieArtworkHelper.downloadExtraArtwork(movie, mft);
                    continue block11;
                }
                case EXTRAFANART: {
                    if (!MovieModuleManager.MOVIE_SETTINGS.isImageExtraFanart() && !force) continue block11;
                    MovieArtworkHelper.downloadExtraArtwork(movie, mft);
                    continue block11;
                }
                case EXTRATHUMB: {
                    if (!MovieModuleManager.MOVIE_SETTINGS.isImageExtraThumbs() && !force) continue block11;
                    MovieArtworkHelper.downloadExtraArtwork(movie, mft);
                    continue block11;
                }
            }
        }
    }

    public static void downloadMissingArtwork(Movie movie, List<MediaArtwork> artwork) {
        Collections.sort(artwork, new MediaArtwork.MediaArtworkComparator(MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().getLanguage()));
        if (movie.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            MovieArtworkHelper.setBestPoster(movie, artwork);
        }
        if (movie.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            MovieArtworkHelper.setBestFanart(movie, artwork);
        }
        if (movie.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.LOGO, MovieModuleManager.MOVIE_SETTINGS.isImageLogo());
        }
        if (movie.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO, MovieModuleManager.MOVIE_SETTINGS.isImageLogo());
        }
        if (movie.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARART, MovieModuleManager.MOVIE_SETTINGS.isImageClearart());
        }
        if (movie.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.BANNER, MovieModuleManager.MOVIE_SETTINGS.isImageBanner());
        }
        if (movie.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.THUMB, MovieModuleManager.MOVIE_SETTINGS.isImageThumb());
        }
        if (movie.getMediaFiles(MediaFileType.DISCART).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.DISC, MovieModuleManager.MOVIE_SETTINGS.isImageDiscart());
        }
        ArrayList<String> extrathumbs = new ArrayList<String>();
        if (movie.getMediaFiles(MediaFileType.EXTRATHUMB).isEmpty() && MovieModuleManager.MOVIE_SETTINGS.isImageExtraThumbs() && MovieModuleManager.MOVIE_SETTINGS.getImageExtraThumbsCount() > 0) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || art.getSizeOrder() != MovieModuleManager.MOVIE_SETTINGS.getImageFanartSize().getOrder()) continue;
                extrathumbs.add(art.getDefaultUrl());
                if (extrathumbs.size() < MovieModuleManager.MOVIE_SETTINGS.getImageExtraThumbsCount()) continue;
                break;
            }
            movie.setExtraThumbs(extrathumbs);
            if (extrathumbs.size() > 0 && !movie.isMultiMovieDir()) {
                MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRATHUMB);
            }
        }
        ArrayList<String> extrafanarts = new ArrayList<String>();
        if (MovieModuleManager.MOVIE_SETTINGS.isImageExtraFanart() && MovieModuleManager.MOVIE_SETTINGS.getImageExtraFanartCount() > 0) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || art.getSizeOrder() != MovieModuleManager.MOVIE_SETTINGS.getImageFanartSize().getOrder()) continue;
                extrafanarts.add(art.getDefaultUrl());
                if (extrafanarts.size() < MovieModuleManager.MOVIE_SETTINGS.getImageExtraFanartCount()) continue;
                break;
            }
            movie.setExtraFanarts(extrafanarts);
            if (extrafanarts.size() > 0 && !movie.isMultiMovieDir()) {
                MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRAFANART);
            }
        }
        movie.saveToDb();
    }

    public static boolean hasMissingArtwork(Movie movie) {
        if (!MovieModuleManager.MOVIE_SETTINGS.getMoviePosterFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.MOVIE_SETTINGS.getMovieFanartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            return true;
        }
        if (MovieModuleManager.MOVIE_SETTINGS.isImageBanner() && movie.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            return true;
        }
        if (MovieModuleManager.MOVIE_SETTINGS.isImageDiscart() && movie.getMediaFiles(MediaFileType.DISCART).isEmpty()) {
            return true;
        }
        if (MovieModuleManager.MOVIE_SETTINGS.isImageLogo() && movie.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            return true;
        }
        if (MovieModuleManager.MOVIE_SETTINGS.isImageLogo() && movie.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            return true;
        }
        if (MovieModuleManager.MOVIE_SETTINGS.isImageClearart() && movie.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            return true;
        }
        return MovieModuleManager.MOVIE_SETTINGS.isImageThumb() && movie.getMediaFiles(MediaFileType.THUMB).isEmpty();
    }

    public static List<MovieFanartNaming> getFanartNamesForMovie(Movie movie) {
        List<MovieFanartNaming> fanartnames = new ArrayList<MovieFanartNaming>();
        if (MovieModuleManager.MOVIE_SETTINGS.getMovieFanartFilenames().isEmpty()) {
            return fanartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.MOVIE_SETTINGS.getMovieFanartFilenames().contains((Object)MovieFanartNaming.FILENAME_FANART_JPG)) {
                fanartnames.add(MovieFanartNaming.FILENAME_FANART_JPG);
                fanartnames.add(MovieFanartNaming.FILENAME_FANART_PNG);
            }
            if (MovieModuleManager.MOVIE_SETTINGS.getMovieFanartFilenames().contains((Object)MovieFanartNaming.FILENAME_FANART2_JPG)) {
                fanartnames.add(MovieFanartNaming.FILENAME_FANART2_JPG);
                fanartnames.add(MovieFanartNaming.FILENAME_FANART2_PNG);
            }
            if (fanartnames.isEmpty()) {
                fanartnames.add(MovieFanartNaming.FILENAME_FANART_JPG);
                fanartnames.add(MovieFanartNaming.FILENAME_FANART_PNG);
            }
        } else if (movie.isDisc()) {
            fanartnames.add(MovieFanartNaming.FANART_JPG);
            fanartnames.add(MovieFanartNaming.FANART_PNG);
        } else {
            fanartnames = MovieModuleManager.MOVIE_SETTINGS.getMovieFanartFilenames();
        }
        return fanartnames;
    }

    private static void downloadFanart(Movie movie) {
        String fanartUrl = movie.getArtworkUrl(MediaFileType.FANART);
        if (StringUtils.isBlank((CharSequence)fanartUrl)) {
            return;
        }
        int i = 0;
        for (MovieFanartNaming name : MovieArtworkHelper.getFanartNamesForMovie(movie)) {
            boolean firstImage = false;
            String filename = MovieArtworkHelper.getFanartFilename(name, movie);
            String generatedFiletype = FilenameUtils.getExtension((String)filename);
            String providedFiletype = FilenameUtils.getExtension((String)fanartUrl);
            if ("tbn".equals(providedFiletype)) {
                providedFiletype = "jpg";
            }
            if (!generatedFiletype.equals(providedFiletype) || StringUtils.isBlank((CharSequence)fanartUrl) || StringUtils.isBlank((CharSequence)filename)) continue;
            if (++i == 1) {
                firstImage = true;
            }
            MediaEntityImageFetcherTask task = new MediaEntityImageFetcherTask(movie, fanartUrl, MediaArtwork.MediaArtworkType.BACKGROUND, filename, firstImage);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
    }

    public static List<MoviePosterNaming> getPosterNamesForMovie(Movie movie) {
        List<MoviePosterNaming> posternames = new ArrayList<MoviePosterNaming>();
        if (MovieModuleManager.MOVIE_SETTINGS.getMoviePosterFilenames().isEmpty()) {
            return posternames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.MOVIE_SETTINGS.getMoviePosterFilenames().contains((Object)MoviePosterNaming.FILENAME_POSTER_JPG)) {
                posternames.add(MoviePosterNaming.FILENAME_POSTER_JPG);
                posternames.add(MoviePosterNaming.FILENAME_POSTER_PNG);
            }
            if (MovieModuleManager.MOVIE_SETTINGS.getMoviePosterFilenames().contains((Object)MoviePosterNaming.FILENAME_JPG)) {
                posternames.add(MoviePosterNaming.FILENAME_JPG);
                posternames.add(MoviePosterNaming.FILENAME_PNG);
            }
            if (posternames.isEmpty()) {
                posternames.add(MoviePosterNaming.FILENAME_POSTER_JPG);
                posternames.add(MoviePosterNaming.FILENAME_POSTER_PNG);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.MOVIE_SETTINGS.getMoviePosterFilenames().contains((Object)MoviePosterNaming.FOLDER_JPG)) {
                posternames.add(MoviePosterNaming.FOLDER_JPG);
                posternames.add(MoviePosterNaming.FOLDER_PNG);
            }
            if (MovieModuleManager.MOVIE_SETTINGS.getMoviePosterFilenames().contains((Object)MoviePosterNaming.POSTER_JPG) || posternames.isEmpty()) {
                posternames.add(MoviePosterNaming.POSTER_JPG);
                posternames.add(MoviePosterNaming.POSTER_PNG);
            }
            if (posternames.isEmpty()) {
                posternames.add(MoviePosterNaming.FOLDER_JPG);
                posternames.add(MoviePosterNaming.FOLDER_PNG);
            }
        } else {
            posternames = MovieModuleManager.MOVIE_SETTINGS.getMoviePosterFilenames();
        }
        return posternames;
    }

    private static void downloadPoster(Movie movie) {
        String posterUrl = movie.getArtworkUrl(MediaFileType.POSTER);
        if (StringUtils.isBlank((CharSequence)posterUrl)) {
            return;
        }
        int i = 0;
        for (MoviePosterNaming name : MovieArtworkHelper.getPosterNamesForMovie(movie)) {
            String providedFiletype;
            boolean firstImage = false;
            String filename = MovieArtworkHelper.getPosterFilename(name, movie);
            String generatedFiletype = FilenameUtils.getExtension((String)filename);
            if (!generatedFiletype.equals(providedFiletype = FilenameUtils.getExtension((String)posterUrl)) || StringUtils.isBlank((CharSequence)posterUrl) || StringUtils.isBlank((CharSequence)filename)) continue;
            if (++i == 1) {
                firstImage = true;
            }
            MediaEntityImageFetcherTask task = new MediaEntityImageFetcherTask(movie, posterUrl, MediaArtwork.MediaArtworkType.POSTER, filename, firstImage);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
    }

    private static void downloadExtraArtwork(Movie movie, MediaFileType type) {
        MovieExtraImageFetcher task = new MovieExtraImageFetcher(movie, type);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public static String getFanartFilename(MovieFanartNaming fanart, Movie movie) {
        List<MediaFile> mfs = movie.getMediaFiles(MediaFileType.VIDEO);
        if (mfs != null && mfs.size() > 0) {
            return MovieArtworkHelper.getFanartFilename(fanart, movie, movie.getVideoBasenameWithoutStacking());
        }
        return MovieArtworkHelper.getFanartFilename(fanart, movie, "");
    }

    public static String getFanartFilename(MovieFanartNaming fanart, Movie movie, String newMovieFilename) {
        String filename = "";
        String mediafile = newMovieFilename;
        switch (fanart) {
            case FANART_PNG: {
                filename = filename + "fanart.png";
                break;
            }
            case FANART_JPG: {
                filename = filename + "fanart.jpg";
                break;
            }
            case FANART_TBN: {
                filename = filename + "fanart.tbn";
                break;
            }
            case FILENAME_FANART_PNG: {
                filename = filename + (mediafile.isEmpty() ? "" : mediafile + "-fanart.png");
                break;
            }
            case FILENAME_FANART_JPG: {
                filename = filename + (mediafile.isEmpty() ? "" : mediafile + "-fanart.jpg");
                break;
            }
            case FILENAME_FANART2_PNG: {
                filename = filename + (mediafile.isEmpty() ? "" : mediafile + ".fanart.png");
                break;
            }
            case FILENAME_FANART2_JPG: {
                filename = filename + (mediafile.isEmpty() ? "" : mediafile + ".fanart.jpg");
                break;
            }
            case FILENAME_FANART_TBN: {
                filename = filename + (mediafile.isEmpty() ? "" : mediafile + "-fanart.tbn");
                break;
            }
            case MOVIENAME_FANART_PNG: {
                filename = filename + movie.getTitle() + "-fanart.png";
                break;
            }
            case MOVIENAME_FANART_JPG: {
                filename = filename + movie.getTitle() + "-fanart.jpg";
                break;
            }
            case MOVIENAME_FANART_TBN: {
                filename = filename + movie.getTitle() + "-fanart.tbn";
                break;
            }
            default: {
                filename = "";
            }
        }
        return filename;
    }

    public static String getPosterFilename(MoviePosterNaming poster, Movie movie) {
        List<MediaFile> mfs = movie.getMediaFiles(MediaFileType.VIDEO);
        if (mfs != null && mfs.size() > 0) {
            return MovieArtworkHelper.getPosterFilename(poster, movie, movie.getVideoBasenameWithoutStacking());
        }
        return MovieArtworkHelper.getPosterFilename(poster, movie, "");
    }

    public static String getPosterFilename(MoviePosterNaming poster, Movie movie, String newMovieFilename) {
        String filename = "";
        String mediafile = newMovieFilename;
        switch (poster) {
            case MOVIENAME_POSTER_PNG: {
                filename = filename + movie.getTitle() + ".png";
                break;
            }
            case MOVIENAME_POSTER_JPG: {
                filename = filename + movie.getTitle() + ".jpg";
                break;
            }
            case MOVIENAME_POSTER_TBN: {
                filename = filename + movie.getTitle() + ".tbn";
                break;
            }
            case FILENAME_POSTER_PNG: {
                filename = filename + (mediafile.isEmpty() ? "" : mediafile + "-poster.png");
                break;
            }
            case FILENAME_POSTER_JPG: {
                filename = filename + (mediafile.isEmpty() ? "" : mediafile + "-poster.jpg");
                break;
            }
            case FILENAME_POSTER_TBN: {
                filename = filename + (mediafile.isEmpty() ? "" : mediafile + "-poster.tbn");
                break;
            }
            case FILENAME_PNG: {
                filename = filename + (mediafile.isEmpty() ? "" : mediafile + ".png");
                break;
            }
            case FILENAME_JPG: {
                filename = filename + (mediafile.isEmpty() ? "" : mediafile + ".jpg");
                break;
            }
            case FILENAME_TBN: {
                filename = filename + (mediafile.isEmpty() ? "" : mediafile + ".tbn");
                break;
            }
            case MOVIE_PNG: {
                filename = filename + "movie.png";
                break;
            }
            case MOVIE_JPG: {
                filename = filename + "movie.jpg";
                break;
            }
            case MOVIE_TBN: {
                filename = filename + "movie.tbn";
                break;
            }
            case POSTER_PNG: {
                filename = filename + "poster.png";
                break;
            }
            case POSTER_JPG: {
                filename = filename + "poster.jpg";
                break;
            }
            case POSTER_TBN: {
                filename = filename + "poster.tbn";
                break;
            }
            case FOLDER_PNG: {
                filename = filename + "folder.png";
                break;
            }
            case FOLDER_JPG: {
                filename = filename + "folder.jpg";
                break;
            }
            case FOLDER_TBN: {
                filename = filename + "folder.tbn";
                break;
            }
            default: {
                filename = "";
            }
        }
        return filename;
    }

    public static void setArtwork(Movie movie, List<MediaArtwork> artwork) {
        Collections.sort(artwork, new MediaArtwork.MediaArtworkComparator(MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().getLanguage()));
        MovieArtworkHelper.setBestPoster(movie, artwork);
        MovieArtworkHelper.setBestFanart(movie, artwork);
        MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.LOGO, MovieModuleManager.MOVIE_SETTINGS.isImageLogo());
        MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO, MovieModuleManager.MOVIE_SETTINGS.isImageLogo());
        MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARART, MovieModuleManager.MOVIE_SETTINGS.isImageClearart());
        MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.BANNER, MovieModuleManager.MOVIE_SETTINGS.isImageBanner());
        MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.THUMB, MovieModuleManager.MOVIE_SETTINGS.isImageThumb());
        MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.DISC, MovieModuleManager.MOVIE_SETTINGS.isImageDiscart());
        ArrayList<String> extrathumbs = new ArrayList<String>();
        if (MovieModuleManager.MOVIE_SETTINGS.isImageExtraThumbs() && MovieModuleManager.MOVIE_SETTINGS.getImageExtraThumbsCount() > 0) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || art.getSizeOrder() != MovieModuleManager.MOVIE_SETTINGS.getImageFanartSize().getOrder()) continue;
                extrathumbs.add(art.getDefaultUrl());
                if (extrathumbs.size() < MovieModuleManager.MOVIE_SETTINGS.getImageExtraThumbsCount()) continue;
                break;
            }
            movie.setExtraThumbs(extrathumbs);
            if (extrathumbs.size() > 0 && !movie.isMultiMovieDir()) {
                MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRATHUMB);
            }
        }
        ArrayList<String> extrafanarts = new ArrayList<String>();
        if (MovieModuleManager.MOVIE_SETTINGS.isImageExtraFanart() && MovieModuleManager.MOVIE_SETTINGS.getImageExtraFanartCount() > 0) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || art.getSizeOrder() != MovieModuleManager.MOVIE_SETTINGS.getImageFanartSize().getOrder()) continue;
                extrafanarts.add(art.getDefaultUrl());
                if (extrafanarts.size() < MovieModuleManager.MOVIE_SETTINGS.getImageExtraFanartCount()) continue;
                break;
            }
            movie.setExtraFanarts(extrafanarts);
            if (extrafanarts.size() > 0 && !movie.isMultiMovieDir()) {
                MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRAFANART);
            }
        }
        movie.saveToDb();
    }

    private static void setBestPoster(Movie movie, List<MediaArtwork> artwork) {
        int preferredSizeOrder = MovieModuleManager.MOVIE_SETTINGS.getImagePosterSize().getOrder();
        String preferredLanguage = MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().getLanguage();
        MediaArtwork foundPoster = null;
        if (MovieModuleManager.MOVIE_SETTINGS.isImageLanguagePriority()) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.POSTER || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != preferredSizeOrder) continue;
                foundPoster = art;
                break;
            }
            if (foundPoster == null) {
                int minOrder = preferredSizeOrder - 1;
                int maxOrder = preferredSizeOrder + 1;
                for (MediaArtwork art : artwork) {
                    if (art.getType() != MediaArtwork.MediaArtworkType.POSTER || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != minOrder && art.getSizeOrder() != maxOrder) continue;
                    foundPoster = art;
                    break;
                }
            }
        } else {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.POSTER || art.getSizeOrder() != preferredSizeOrder) continue;
                foundPoster = art;
                break;
            }
        }
        if (foundPoster == null) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.POSTER) continue;
                foundPoster = art;
                break;
            }
        }
        if (foundPoster != null) {
            movie.setArtworkUrl(foundPoster.getDefaultUrl(), MediaFileType.POSTER);
            if (movie.getTmdbId() == 0 && foundPoster.getTmdbId() > 0) {
                movie.setTmdbId(foundPoster.getTmdbId());
            }
            MovieArtworkHelper.downloadArtwork(movie, MediaFileType.POSTER);
        }
    }

    private static void setBestFanart(Movie movie, List<MediaArtwork> artwork) {
        int preferredSizeOrder = MovieModuleManager.MOVIE_SETTINGS.getImageFanartSize().getOrder();
        String preferredLanguage = MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().getLanguage();
        MediaArtwork foundfanart = null;
        if (MovieModuleManager.MOVIE_SETTINGS.isImageLanguagePriority()) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != preferredSizeOrder) continue;
                foundfanart = art;
                break;
            }
            if (foundfanart == null) {
                int minOrder = preferredSizeOrder - 1;
                int maxOrder = preferredSizeOrder + 1;
                for (MediaArtwork art : artwork) {
                    if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != minOrder && art.getSizeOrder() != maxOrder) continue;
                    foundfanart = art;
                    break;
                }
            }
        } else {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || art.getSizeOrder() != preferredSizeOrder) continue;
                foundfanart = art;
                break;
            }
        }
        if (foundfanart == null) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND) continue;
                foundfanart = art;
                break;
            }
        }
        if (foundfanart != null) {
            movie.setArtworkUrl(foundfanart.getDefaultUrl(), MediaFileType.FANART);
            if (movie.getTmdbId() == 0 && foundfanart.getTmdbId() > 0) {
                movie.setTmdbId(foundfanart.getTmdbId());
            }
            MovieArtworkHelper.downloadArtwork(movie, MediaFileType.FANART);
        }
    }

    private static void setBestArtwork(Movie movie, List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type, boolean download) {
        for (MediaArtwork art : artwork) {
            if (art.getType() != type || !StringUtils.isNotBlank((CharSequence)art.getDefaultUrl())) continue;
            movie.setArtworkUrl(art.getDefaultUrl(), MediaFileType.getMediaFileType(type));
            if (!download) break;
            MovieArtworkHelper.downloadArtwork(movie, MediaFileType.getMediaFileType(type));
            break;
        }
    }
}

