/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.japura.gui.LinkLabel;
import org.japura.gui.event.ListCheckListener;
import org.japura.gui.event.ListEvent;
import org.japura.gui.i18n.GUIStringKeys;
import org.japura.gui.model.ListCheckModel;
import org.japura.util.i18n.I18nAdapter;

public abstract class BatchSelection
extends JPanel {
    private static final long serialVersionUID = -5590564660493587009L;
    private ListCheckModel model;

    public BatchSelection() {
        this.setBackground(Color.WHITE);
    }

    protected void setModel(ListCheckModel model) {
        this.model = model;
    }

    protected ListCheckModel getModel() {
        return this.model;
    }

    protected abstract void unregisterModel();

    protected abstract void registerModel(ListCheckModel var1);

    public static class CheckBox
    extends BatchSelection {
        private static final long serialVersionUID = 8362937292351414821L;
        private JCheckBox checkBox;
        private ActionListener checkBoxListener;
        private ListCheckListener modelListener;

        public CheckBox() {
            this.initialization();
        }

        protected void initialization() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            this.add((Component)this.getCheckBox(), gbc);
        }

        protected JCheckBox getCheckBox() {
            if (this.checkBox == null) {
                this.checkBox = new JCheckBox(I18nAdapter.getAdapter().getString(GUIStringKeys.SELECT_DESELECT_ALL.getKey()));
                this.checkBox.setOpaque(false);
            }
            return this.checkBox;
        }

        @Override
        protected void unregisterModel() {
            if (this.checkBoxListener != null) {
                this.getCheckBox().removeActionListener(this.checkBoxListener);
            }
            if (this.modelListener != null) {
                this.getModel().removeListCheckListener(this.modelListener);
            }
            this.checkBoxListener = null;
            this.modelListener = null;
        }

        @Override
        protected void registerModel(final ListCheckModel model) {
            this.setModel(model);
            this.checkBoxListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CheckBox.this.getCheckBox().isSelected()) {
                        model.checkAll();
                    } else {
                        model.removeChecks();
                    }
                }
            };
            this.modelListener = new ListCheckListener(){

                @Override
                public void removeCheck(ListEvent event) {
                    CheckBox.this.update(event.getSource());
                }

                @Override
                public void addCheck(ListEvent event) {
                    CheckBox.this.update(event.getSource());
                }
            };
            this.getCheckBox().addActionListener(this.checkBoxListener);
            model.addListCheckListener(this.modelListener);
        }

        protected void update(ListCheckModel model) {
            if (model.getSize() == model.getChecksCount()) {
                this.getCheckBox().setSelected(true);
            } else {
                this.getCheckBox().setSelected(false);
            }
        }
    }

    public static class Link
    extends BatchSelection {
        private static final long serialVersionUID = -7012666490345732840L;
        private LinkLabel selectAllButton;
        private LinkLabel deselectAllButton;
        private ActionListener selectListener;
        private ActionListener deselectListener;

        public Link() {
            this.initialization();
        }

        protected void initialization() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)this.getSelectAllButton(), gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 20, 0, 0);
            this.add((Component)this.getDeselectAllButton(), gbc);
        }

        protected LinkLabel getSelectAllButton() {
            if (this.selectAllButton == null) {
                this.selectAllButton = new LinkLabel();
                this.selectAllButton.setText(I18nAdapter.getAdapter().getString(GUIStringKeys.SELECT_ALL.getKey()));
            }
            return this.selectAllButton;
        }

        protected LinkLabel getDeselectAllButton() {
            if (this.deselectAllButton == null) {
                this.deselectAllButton = new LinkLabel();
                this.deselectAllButton.setText(I18nAdapter.getAdapter().getString(GUIStringKeys.DESELECT_ALL.getKey()));
            }
            return this.deselectAllButton;
        }

        @Override
        protected void unregisterModel() {
            if (this.selectListener != null) {
                this.getSelectAllButton().removeActionListener(this.selectListener);
            }
            if (this.deselectListener != null) {
                this.getDeselectAllButton().removeActionListener(this.deselectListener);
            }
            this.selectListener = null;
            this.deselectListener = null;
        }

        @Override
        protected void registerModel(final ListCheckModel model) {
            this.setModel(model);
            this.selectListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    model.checkAll();
                }
            };
            this.deselectListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    model.removeChecks();
                }
            };
            this.getSelectAllButton().addActionListener(this.selectListener);
            this.getDeselectAllButton().addActionListener(this.deselectListener);
        }
    }
}

