/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.movie.MovieFanartNaming;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MoviePosterNaming;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.mediaprovider.IMediaProvider;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

public class MovieImageSettingsPanel
extends ScrollablePanel {
    private static final long serialVersionUID = 7312645402037806284L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSettings settings = MovieModuleManager.MOVIE_SETTINGS;
    private List<ArtworkScraper> scrapers = ObservableCollections.observableList(new ArrayList());
    private JComboBox cbImagePosterSize;
    private JComboBox cbImageFanartSize;
    private JCheckBox cbMoviePosterFilename2;
    private JCheckBox cbMoviePosterFilename4;
    private JCheckBox cbMoviePosterFilename6;
    private JCheckBox cbMoviePosterFilename7;
    private JCheckBox cbMovieFanartFilename1;
    private JCheckBox cbMovieFanartFilename2;
    private JCheckBox cbMoviePosterFilename8;
    private JCheckBox cbActorImages;
    private JTextPane tpFileNamingHint;
    private JCheckBox chckbxEnableExtrathumbs;
    private JCheckBox chckbxEnableExtrafanart;
    private JCheckBox chckbxResizeExtrathumbsTo;
    private JSpinner spExtrathumbWidth;
    private JLabel lblDownload;
    private JSpinner spDownloadCountExtrathumbs;
    private JLabel lblDownloadCount;
    private JSpinner spDownloadCountExtrafanart;
    private JCheckBox chckbxStoreMoviesetArtwork;
    private JTextField tfMovieSetArtworkFolder;
    private JLabel lblFoldername;
    private JButton btnSelectFolder;
    private JCheckBox cbMovieFanartFilename3;
    private JCheckBox chckbxBanner;
    private JCheckBox chckbxLogo;
    private JCheckBox chckbxThumb;
    private JCheckBox chckbxDiscArt;
    private JCheckBox chckbxClearArt;
    private JPanel panelExtraArtwork;
    private JCheckBox chckbxMovieSetArtwork;
    private JScrollPane scrollPaneScraper;
    private JPanel panelScraperDetails;
    private JTable tableScraper;
    private JTextPane tpScraperDescription;
    private JPanel panelScraperOptions;
    private JPanel panelFileNaming;
    private JScrollPane scrollPaneScraperDetails;

    public MovieImageSettingsPanel() {
        List<MovieFanartNaming> movieFanartFilenames;
        List<String> enabledArtworkProviders = this.settings.getMovieArtworkScrapers();
        int selectedIndex = -1;
        int counter = 0;
        for (MediaScraper scraper : MovieList.getInstance().getAvailableArtworkScrapers()) {
            ArtworkScraper artworkScraper = new ArtworkScraper(scraper);
            if (enabledArtworkProviders.contains(artworkScraper.getScraperId())) {
                artworkScraper.active = true;
                if (selectedIndex < 0) {
                    selectedIndex = counter;
                }
            }
            this.scrapers.add(artworkScraper);
            ++counter;
        }
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JPanel panelMovieImages = new JPanel();
        panelMovieImages.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.poster"), 4, 2, null, null));
        this.add((Component)panelMovieImages, "2, 2, default, fill");
        panelMovieImages.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"100dlu:grow"), FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.scrollPaneScraperDetails = new JScrollPane();
        this.scrollPaneScraperDetails.setBorder(null);
        this.scrollPaneScraperDetails.setHorizontalScrollBarPolicy(31);
        panelMovieImages.add((Component)this.scrollPaneScraperDetails, "6, 1, 1, 7, fill, fill");
        this.panelScraperDetails = new ScrollablePanel();
        this.scrollPaneScraperDetails.setViewportView(this.panelScraperDetails);
        this.panelScraperDetails.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        this.tpScraperDescription = new JTextPane();
        this.tpScraperDescription.setOpaque(false);
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        this.panelScraperDetails.add((Component)this.tpScraperDescription, "1, 1, fill, top");
        this.panelScraperOptions = new JPanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        this.panelScraperDetails.add((Component)this.panelScraperOptions, "1, 3, fill, top");
        this.scrollPaneScraper = new JScrollPane();
        panelMovieImages.add((Component)this.scrollPaneScraper, "2, 2, 3, 1, fill, fill");
        this.tableScraper = new JTable();
        this.tableScraper.setRowHeight(29);
        this.scrollPaneScraper.setViewportView(this.tableScraper);
        JSeparator separator = new JSeparator();
        panelMovieImages.add((Component)separator, "2, 3, 3, 1");
        JLabel lblImageTmdbPosterSize = new JLabel(BUNDLE.getString("image.poster.size"));
        panelMovieImages.add((Component)lblImageTmdbPosterSize, "2, 5");
        this.cbImagePosterSize = new JComboBox<MediaArtwork.PosterSizes>(MediaArtwork.PosterSizes.values());
        panelMovieImages.add((Component)this.cbImagePosterSize, "4, 5");
        JLabel lblImageTmdbFanartSize = new JLabel(BUNDLE.getString("image.fanart.size"));
        panelMovieImages.add((Component)lblImageTmdbFanartSize, "2, 7");
        this.cbImageFanartSize = new JComboBox<MediaArtwork.FanartSizes>(MediaArtwork.FanartSizes.values());
        panelMovieImages.add((Component)this.cbImageFanartSize, "4, 7");
        separator = new JSeparator();
        panelMovieImages.add((Component)separator, "2, 9, 5, 1");
        this.panelFileNaming = new JPanel();
        panelMovieImages.add((Component)this.panelFileNaming, "2, 11, 5, 1, fill, fill");
        this.panelFileNaming.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JLabel lblPosterFilename = new JLabel(BUNDLE.getString("image.poster.naming"));
        this.panelFileNaming.add((Component)lblPosterFilename, "1, 1");
        this.cbMoviePosterFilename7 = new JCheckBox("<dynamic>.ext");
        this.panelFileNaming.add((Component)this.cbMoviePosterFilename7, "3, 1");
        this.cbMoviePosterFilename4 = new JCheckBox("poster.ext");
        this.panelFileNaming.add((Component)this.cbMoviePosterFilename4, "5, 1");
        this.cbMoviePosterFilename2 = new JCheckBox("movie.ext");
        this.panelFileNaming.add((Component)this.cbMoviePosterFilename2, "7, 1");
        this.cbMoviePosterFilename8 = new JCheckBox("<dynamic>-poster.ext");
        this.panelFileNaming.add((Component)this.cbMoviePosterFilename8, "9, 1");
        this.cbMoviePosterFilename6 = new JCheckBox("folder.ext");
        this.panelFileNaming.add((Component)this.cbMoviePosterFilename6, "11, 1");
        JLabel lblFanartFileNaming = new JLabel(BUNDLE.getString("image.fanart.naming"));
        this.panelFileNaming.add((Component)lblFanartFileNaming, "1, 3");
        this.cbMovieFanartFilename1 = new JCheckBox("<dynamic>-fanart.ext");
        this.panelFileNaming.add((Component)this.cbMovieFanartFilename1, "3, 3");
        this.cbMovieFanartFilename3 = new JCheckBox("<dynamic>.fanart.ext");
        this.panelFileNaming.add((Component)this.cbMovieFanartFilename3, "5, 3");
        this.cbMovieFanartFilename2 = new JCheckBox("fanart.ext");
        this.panelFileNaming.add((Component)this.cbMovieFanartFilename2, "7, 3");
        this.tpFileNamingHint = new JTextPane();
        this.panelFileNaming.add((Component)this.tpFileNamingHint, "1, 5, 11, 1, fill, fill");
        this.tpFileNamingHint.setText(BUNDLE.getString("Settings.naming.info"));
        this.tpFileNamingHint.setBackground(UIManager.getColor("Panel.background"));
        TmmFontHelper.changeFont((JComponent)this.tpFileNamingHint, 0.833);
        this.panelExtraArtwork = new JPanel();
        this.panelExtraArtwork.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.extraartwork"), 4, 2, null, null));
        this.add((Component)this.panelExtraArtwork, "2, 4, default, fill");
        this.panelExtraArtwork.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        this.chckbxBanner = new JCheckBox(BUNDLE.getString("mediafiletype.banner"));
        this.panelExtraArtwork.add((Component)this.chckbxBanner, "2, 2");
        this.chckbxClearArt = new JCheckBox(BUNDLE.getString("mediafiletype.clearart"));
        this.panelExtraArtwork.add((Component)this.chckbxClearArt, "4, 2");
        this.chckbxThumb = new JCheckBox(BUNDLE.getString("mediafiletype.thumb"));
        this.panelExtraArtwork.add((Component)this.chckbxThumb, "6, 2");
        this.chckbxLogo = new JCheckBox(BUNDLE.getString("mediafiletype.logo"));
        this.panelExtraArtwork.add((Component)this.chckbxLogo, "8, 2");
        this.chckbxDiscArt = new JCheckBox(BUNDLE.getString("mediafiletype.discart"));
        this.panelExtraArtwork.add((Component)this.chckbxDiscArt, "10, 2");
        separator = new JSeparator();
        this.panelExtraArtwork.add((Component)separator, "2, 4, 9, 1");
        this.chckbxEnableExtrathumbs = new JCheckBox(BUNDLE.getString("Settings.enable.extrathumbs"));
        this.panelExtraArtwork.add((Component)this.chckbxEnableExtrathumbs, "2, 6, 3, 1");
        this.chckbxResizeExtrathumbsTo = new JCheckBox(BUNDLE.getString("Settings.resize.extrathumbs"));
        this.panelExtraArtwork.add((Component)this.chckbxResizeExtrathumbsTo, "6, 6, 3, 1");
        this.spExtrathumbWidth = new JSpinner();
        this.panelExtraArtwork.add((Component)this.spExtrathumbWidth, "10, 6");
        this.spExtrathumbWidth.setPreferredSize(new Dimension(49, 20));
        this.lblDownload = new JLabel(BUNDLE.getString("Settings.amount.autodownload"));
        this.panelExtraArtwork.add((Component)this.lblDownload, "2, 8, 7, 1, right, default");
        this.spDownloadCountExtrathumbs = new JSpinner();
        this.panelExtraArtwork.add((Component)this.spDownloadCountExtrathumbs, "10, 8");
        this.spDownloadCountExtrathumbs.setPreferredSize(new Dimension(49, 20));
        this.chckbxEnableExtrafanart = new JCheckBox(BUNDLE.getString("Settings.enable.extrafanart"));
        this.panelExtraArtwork.add((Component)this.chckbxEnableExtrafanart, "2, 10, 9, 1");
        this.lblDownloadCount = new JLabel(BUNDLE.getString("Settings.amount.autodownload"));
        this.panelExtraArtwork.add((Component)this.lblDownloadCount, "2, 12, 7, 1, right, default");
        this.spDownloadCountExtrafanart = new JSpinner();
        this.panelExtraArtwork.add((Component)this.spDownloadCountExtrafanart, "10, 12");
        this.spDownloadCountExtrafanart.setPreferredSize(new Dimension(49, 20));
        separator = new JSeparator();
        this.panelExtraArtwork.add((Component)separator, "2, 14, 9, 1");
        this.cbActorImages = new JCheckBox(BUNDLE.getString("Settings.actor.download"));
        this.panelExtraArtwork.add((Component)this.cbActorImages, "2, 16, 9, 1");
        separator = new JSeparator();
        this.panelExtraArtwork.add((Component)separator, "2, 18, 9, 1");
        this.chckbxMovieSetArtwork = new JCheckBox(BUNDLE.getString("Settings.movieset.store.movie"));
        this.panelExtraArtwork.add((Component)this.chckbxMovieSetArtwork, "2, 20, 9, 1");
        this.chckbxStoreMoviesetArtwork = new JCheckBox(BUNDLE.getString("Settings.movieset.store"));
        this.panelExtraArtwork.add((Component)this.chckbxStoreMoviesetArtwork, "2, 22, 9, 1");
        this.lblFoldername = new JLabel(BUNDLE.getString("Settings.movieset.foldername"));
        this.panelExtraArtwork.add((Component)this.lblFoldername, "2, 24, 3, 1, right, default");
        this.tfMovieSetArtworkFolder = new JTextField();
        this.panelExtraArtwork.add((Component)this.tfMovieSetArtworkFolder, "6, 24, 3, 1");
        this.tfMovieSetArtworkFolder.setColumns(10);
        this.btnSelectFolder = new JButton(BUNDLE.getString("Settings.movieset.buttonselect"));
        this.panelExtraArtwork.add((Component)this.btnSelectFolder, "10, 24");
        this.btnSelectFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String path = TmmProperties.getInstance().getProperty("movieset.folderchooser.path");
                Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.movieset.folderchooser"), path);
                if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                    MovieImageSettingsPanel.this.tfMovieSetArtworkFolder.setText(file.toAbsolutePath().toString());
                    TmmProperties.getInstance().putProperty("movieset.folderchooser.path", file.toAbsolutePath().toString());
                }
            }
        });
        this.initDataBindings();
        List<MoviePosterNaming> moviePosterFilenames = this.settings.getMoviePosterFilenames();
        if (moviePosterFilenames.contains((Object)MoviePosterNaming.MOVIE_JPG)) {
            this.cbMoviePosterFilename2.setSelected(true);
        }
        if (moviePosterFilenames.contains((Object)MoviePosterNaming.POSTER_JPG)) {
            this.cbMoviePosterFilename4.setSelected(true);
        }
        if (moviePosterFilenames.contains((Object)MoviePosterNaming.FOLDER_JPG)) {
            this.cbMoviePosterFilename6.setSelected(true);
        }
        if (moviePosterFilenames.contains((Object)MoviePosterNaming.FILENAME_JPG)) {
            this.cbMoviePosterFilename7.setSelected(true);
        }
        if (moviePosterFilenames.contains((Object)MoviePosterNaming.FILENAME_POSTER_JPG)) {
            this.cbMoviePosterFilename8.setSelected(true);
        }
        if ((movieFanartFilenames = this.settings.getMovieFanartFilenames()).contains((Object)MovieFanartNaming.FILENAME_FANART_JPG)) {
            this.cbMovieFanartFilename1.setSelected(true);
        }
        if (movieFanartFilenames.contains((Object)MovieFanartNaming.FANART_JPG)) {
            this.cbMovieFanartFilename2.setSelected(true);
        }
        if (movieFanartFilenames.contains((Object)MovieFanartNaming.FILENAME_FANART2_JPG)) {
            this.cbMovieFanartFilename3.setSelected(true);
        }
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MovieImageSettingsPanel.this.checkChanges();
            }
        };
        this.cbMovieFanartFilename2.addItemListener(listener);
        this.cbMovieFanartFilename3.addItemListener(listener);
        this.cbMovieFanartFilename1.addItemListener(listener);
        this.cbMoviePosterFilename2.addItemListener(listener);
        this.cbMoviePosterFilename4.addItemListener(listener);
        this.cbMoviePosterFilename7.addItemListener(listener);
        this.cbMoviePosterFilename8.addItemListener(listener);
        this.cbMoviePosterFilename6.addItemListener(listener);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 2);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        this.tableScraper.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (arg0.getColumn() == 0) {
                    int row = arg0.getFirstRow();
                    ArtworkScraper changedScraper = (ArtworkScraper)MovieImageSettingsPanel.this.scrapers.get(row);
                    if (changedScraper.active) {
                        MovieImageSettingsPanel.this.settings.addMovieArtworkScraper(changedScraper.getScraperId());
                    } else {
                        MovieImageSettingsPanel.this.settings.removeMovieArtworkScraper(changedScraper.getScraperId());
                    }
                }
            }
        });
        this.tableScraper.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = MovieImageSettingsPanel.this.tableScraper.convertRowIndexToModel(MovieImageSettingsPanel.this.tableScraper.getSelectedRow());
                if (index > -1) {
                    MovieImageSettingsPanel.this.panelScraperOptions.removeAll();
                    if (((ArtworkScraper)MovieImageSettingsPanel.this.scrapers.get(index)).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                        MovieImageSettingsPanel.this.panelScraperOptions.add(new MediaScraperConfigurationPanel(((ArtworkScraper)MovieImageSettingsPanel.this.scrapers.get(index)).getMediaProvider()));
                    }
                    MovieImageSettingsPanel.this.panelScraperOptions.revalidate();
                }
            }
        });
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if (counter > 0) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    public void checkChanges() {
        this.settings.clearMoviePosterFilenames();
        if (this.cbMoviePosterFilename2.isSelected()) {
            this.settings.addMoviePosterFilename(MoviePosterNaming.MOVIE_JPG);
            this.settings.addMoviePosterFilename(MoviePosterNaming.MOVIE_PNG);
        }
        if (this.cbMoviePosterFilename4.isSelected()) {
            this.settings.addMoviePosterFilename(MoviePosterNaming.POSTER_JPG);
            this.settings.addMoviePosterFilename(MoviePosterNaming.POSTER_PNG);
        }
        if (this.cbMoviePosterFilename6.isSelected()) {
            this.settings.addMoviePosterFilename(MoviePosterNaming.FOLDER_JPG);
            this.settings.addMoviePosterFilename(MoviePosterNaming.FOLDER_PNG);
        }
        if (this.cbMoviePosterFilename7.isSelected()) {
            this.settings.addMoviePosterFilename(MoviePosterNaming.FILENAME_JPG);
            this.settings.addMoviePosterFilename(MoviePosterNaming.FILENAME_PNG);
        }
        if (this.cbMoviePosterFilename8.isSelected()) {
            this.settings.addMoviePosterFilename(MoviePosterNaming.FILENAME_POSTER_JPG);
            this.settings.addMoviePosterFilename(MoviePosterNaming.FILENAME_POSTER_PNG);
        }
        this.settings.clearMovieFanartFilenames();
        if (this.cbMovieFanartFilename1.isSelected()) {
            this.settings.addMovieFanartFilename(MovieFanartNaming.FILENAME_FANART_JPG);
            this.settings.addMovieFanartFilename(MovieFanartNaming.FILENAME_FANART_PNG);
        }
        if (this.cbMovieFanartFilename2.isSelected()) {
            this.settings.addMovieFanartFilename(MovieFanartNaming.FANART_JPG);
            this.settings.addMovieFanartFilename(MovieFanartNaming.FANART_PNG);
        }
        if (this.cbMovieFanartFilename3.isSelected()) {
            this.settings.addMovieFanartFilename(MovieFanartNaming.FILENAME_FANART2_JPG);
            this.settings.addMovieFanartFilename(MovieFanartNaming.FILENAME_FANART2_PNG);
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"imagePosterSize");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, (Object)this.cbImagePosterSize, (Property)jComboBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"imageFanartSize");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (Object)this.cbImageFanartSize, (Property)jComboBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"writeActorImages");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.cbActorImages, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty settingsBeanProperty_3 = BeanProperty.create((String)"imageExtraFanart");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_3, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"imageExtraThumbs");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, (Object)this.chckbxEnableExtrathumbs, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"imageExtraThumbsSize");
        BeanProperty jSpinnerBeanProperty_1 = BeanProperty.create((String)"value");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, (Object)this.spExtrathumbWidth, (Property)jSpinnerBeanProperty_1);
        autoBinding_10.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"imageExtraThumbsResize");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, (Object)this.chckbxResizeExtrathumbsTo, (Property)jCheckBoxBeanProperty);
        autoBinding_11.bind();
        BeanProperty settingsBeanProperty_10 = BeanProperty.create((String)"imageExtraThumbsCount");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_10, (Object)this.spDownloadCountExtrathumbs, (Property)jSpinnerBeanProperty_1);
        autoBinding_12.bind();
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"imageExtraFanartCount");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, (Object)this.spDownloadCountExtrafanart, (Property)jSpinnerBeanProperty_1);
        autoBinding_13.bind();
        BeanProperty jSpinnerBeanProperty = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty, (Object)this.spDownloadCountExtrafanart, (Property)jSpinnerBeanProperty);
        autoBinding_14.bind();
        AutoBinding autoBinding_15 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrathumbs, (Property)jCheckBoxBeanProperty, (Object)this.spDownloadCountExtrathumbs, (Property)jSpinnerBeanProperty);
        autoBinding_15.bind();
        BeanProperty settingsBeanProperty_12 = BeanProperty.create((String)"movieSetArtworkFolder");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_16 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_12, (Object)this.tfMovieSetArtworkFolder, (Property)jTextFieldBeanProperty);
        autoBinding_16.bind();
        BeanProperty settingsBeanProperty_13 = BeanProperty.create((String)"enableMovieSetArtworkFolder");
        AutoBinding autoBinding_17 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_13, (Object)this.chckbxStoreMoviesetArtwork, (Property)jCheckBoxBeanProperty);
        autoBinding_17.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrathumbs, (Property)jCheckBoxBeanProperty, (Object)this.chckbxResizeExtrathumbsTo, (Property)jCheckBoxBeanProperty_1);
        autoBinding_8.bind();
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrathumbs, (Property)jCheckBoxBeanProperty, (Object)this.spExtrathumbWidth, (Property)jSpinnerBeanProperty);
        autoBinding_9.bind();
        BeanProperty settingsBeanProperty_7 = BeanProperty.create((String)"imageBanner");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_7, (Object)this.chckbxBanner, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty settingsBeanProperty_14 = BeanProperty.create((String)"imageClearart");
        AutoBinding autoBinding_18 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_14, (Object)this.chckbxClearArt, (Property)jCheckBoxBeanProperty);
        autoBinding_18.bind();
        BeanProperty settingsBeanProperty_15 = BeanProperty.create((String)"imageThumb");
        AutoBinding autoBinding_19 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_15, (Object)this.chckbxThumb, (Property)jCheckBoxBeanProperty);
        autoBinding_19.bind();
        BeanProperty settingsBeanProperty_16 = BeanProperty.create((String)"imageLogo");
        AutoBinding autoBinding_20 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_16, (Object)this.chckbxLogo, (Property)jCheckBoxBeanProperty);
        autoBinding_20.bind();
        BeanProperty settingsBeanProperty_17 = BeanProperty.create((String)"imageDiscart");
        AutoBinding autoBinding_21 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_17, (Object)this.chckbxDiscArt, (Property)jCheckBoxBeanProperty);
        autoBinding_21.bind();
        BeanProperty settingsBeanProperty_18 = BeanProperty.create((String)"enableMovieSetArtworkMovieFolder");
        AutoBinding autoBinding_22 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_18, (Object)this.chckbxMovieSetArtwork, (Property)jCheckBoxBeanProperty);
        autoBinding_22.bind();
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableScraper);
        BeanProperty artworkScraperBeanProperty = BeanProperty.create((String)"active");
        jTableBinding.addColumnBinding((Property)artworkScraperBeanProperty).setColumnName("Active").setColumnClass(Boolean.class);
        BeanProperty artworkScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)artworkScraperBeanProperty_1).setColumnName("Logo").setEditable(false).setColumnClass(ImageIcon.class);
        BeanProperty artworkScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)artworkScraperBeanProperty_2).setColumnName("Name").setEditable(false).setColumnClass(String.class);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_23 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding_23.bind();
    }

    public class ArtworkScraper
    extends AbstractModelObject {
        private MediaScraper scraper;
        private Icon scraperLogo;
        private boolean active;

        public ArtworkScraper(MediaScraper scraper) {
            this.scraper = scraper;
            this.scraperLogo = scraper.getMediaProvider().getProviderInfo().getProviderLogo() == null ? new ImageIcon() : this.getScaledIcon(new ImageIcon(scraper.getMediaProvider().getProviderInfo().getProviderLogo()));
        }

        private ImageIcon getScaledIcon(ImageIcon original) {
            Canvas c = new Canvas();
            FontMetrics fm = c.getFontMetrics(MovieImageSettingsPanel.this.getFont());
            int height = (int)((float)fm.getHeight() * 2.0f);
            int width = original.getIconWidth() / original.getIconHeight() * height;
            BufferedImage scaledImage = Scalr.resize((BufferedImage)ImageCache.createImage(original.getImage()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            return new ImageIcon(scaledImage);
        }

        public String getScraperId() {
            return this.scraper.getId();
        }

        public String getScraperName() {
            return this.scraper.getName() + " - " + this.scraper.getVersion();
        }

        public String getScraperDescription() {
            String description = null;
            try {
                description = BUNDLE.getString("scraper." + this.scraper.getId() + ".hint");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isBlank(description)) {
                description = this.scraper.getDescription();
            }
            return description;
        }

        public Icon getScraperLogo() {
            return this.scraperLogo;
        }

        public Boolean getActive() {
            return this.active;
        }

        public void setActive(Boolean newValue) {
            Boolean oldValue = this.active;
            this.active = newValue;
            this.firePropertyChange("active", oldValue, newValue);
        }

        public IMediaProvider getMediaProvider() {
            return this.scraper.getMediaProvider();
        }
    }
}

