/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcores.jre.CommonCore;
import net.jcores.jre.options.Option;
import net.jcores.jre.utils.internal.processing.Folder;
import net.jcores.jre.utils.internal.processing.Mapper;
import net.jcores.jre.utils.internal.structures.ProfileInformation;

public abstract class Core
implements Serializable {
    private static final long serialVersionUID = 2195880634253143587L;
    protected transient CommonCore commonCore;

    protected Core(CommonCore commonCore) {
        this.commonCore = commonCore;
    }

    public abstract int size();

    protected void map(final Mapper mapper, Option ... optionArray) {
        int n;
        final int n2 = mapper.core().size();
        CommonCore commonCore = this.commonCore;
        if (n2 <= 0) {
            return;
        }
        if (n2 == 1) {
            mapper.handle(0);
            return;
        }
        ProfileInformation profileInformation = commonCore.profileInformation();
        final int n3 = Math.max(this.size() / 10, 1);
        final AtomicInteger atomicInteger = new AtomicInteger();
        long l = 0L;
        Iterator iterator = mapper.core().iterator();
        while (iterator.hasNext()) {
            n = iterator.nextIndex();
            Object e = iterator.next();
            if (e == null) continue;
            atomicInteger.set(n + 1);
            long l2 = System.nanoTime();
            mapper.handle(n);
            l = System.nanoTime() - l2;
            break;
        }
        n = n2 - atomicInteger.get();
        long l3 = l * (long)n;
        int n4 = Math.min(n, this.commonCore.profileInformation().numCPUs);
        if (l3 < 2L * profileInformation.forkTime && n > 1 || n4 < 2) {
            while (iterator.hasNext()) {
                int n5 = iterator.nextIndex();
                iterator.next();
                mapper.handle(n5);
            }
            return;
        }
        final CyclicBarrier cyclicBarrier = new CyclicBarrier(n4 + 1);
        final AtomicInteger atomicInteger2 = new AtomicInteger();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n = atomicInteger2.getAndIncrement() * n3;
                int n22 = Math.max(atomicInteger.get(), n);
                while (n22 < n2) {
                    int n32 = Math.min(Math.min(n22 + n3, n2), n + n3);
                    for (int i = n22; i < n32; ++i) {
                        mapper.handle(i);
                    }
                    n22 = n = atomicInteger2.getAndIncrement() * n3;
                }
                try {
                    cyclicBarrier.await();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (BrokenBarrierException brokenBarrierException) {
                    brokenBarrierException.printStackTrace();
                }
            }
        };
        for (int i = 0; i < n4; ++i) {
            commonCore.executor().getExecutor().execute(runnable);
        }
        try {
            cyclicBarrier.await();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (BrokenBarrierException brokenBarrierException) {
            brokenBarrierException.printStackTrace();
        }
    }

    protected void fold(final Folder folder, Option ... optionArray) {
        final int n = folder.core().size();
        if (n <= 1) {
            return;
        }
        if (n == 2) {
            folder.handle(0, 1, 0);
            return;
        }
        int n2 = this.commonCore.profileInformation().numCPUs;
        final AtomicInteger atomicInteger = new AtomicInteger();
        final AtomicInteger atomicInteger2 = new AtomicInteger();
        final CyclicBarrier cyclicBarrier = new CyclicBarrier(n2);
        final CyclicBarrier cyclicBarrier2 = new CyclicBarrier(n2 + 1);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n7 = atomicInteger2.get();
                int n2 = (int)Math.pow(2.0, n7);
                while (n2 < n) {
                    int n3 = n - n2;
                    int n4 = -1;
                    int n5 = atomicInteger.getAndAdd(2) * n2;
                    int n6 = n5 + n2;
                    while (n6 <= n3) {
                        folder.handle(n5, n6, n5);
                        n4 = n5;
                        n5 = atomicInteger.getAndAdd(2) * n2;
                        n6 = n5 + n2;
                    }
                    if (n4 + 2 * n2 <= n3 && n4 + 3 * n2 > n3 && n4 >= 0) {
                        folder.handle(n4, n4 + 2 * n2, n4);
                    }
                    try {
                        cyclicBarrier.await();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (BrokenBarrierException brokenBarrierException) {
                        brokenBarrierException.printStackTrace();
                    }
                    if (atomicInteger2.compareAndSet(n7, n7 + 1)) {
                        atomicInteger.set(0);
                    }
                    try {
                        cyclicBarrier.await();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (BrokenBarrierException brokenBarrierException) {
                        brokenBarrierException.printStackTrace();
                    }
                    n7 = atomicInteger2.get();
                    n2 = (int)Math.pow(2.0, n7);
                }
                try {
                    cyclicBarrier2.await();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (BrokenBarrierException brokenBarrierException) {
                    brokenBarrierException.printStackTrace();
                }
            }
        };
        for (int i = 0; i < n2; ++i) {
            this.commonCore.executor().getExecutor().execute(runnable);
        }
        try {
            cyclicBarrier2.await();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (BrokenBarrierException brokenBarrierException) {
            brokenBarrierException.printStackTrace();
        }
    }
}

