/*
 * Decompiled with CFR 0.152.
 */
package org.japura.util.date;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.japura.util.date.DateMask;
import org.japura.util.date.DateSeparator;

public final class DateUtil {
    private static final String dayOrMonthRegex = "[0-9]{1,2}";
    private static final String yearRegex = "[0-9]{4}";
    private static StringBuilder regex = new StringBuilder();
    private static Split staticSplit = new Split();
    private static StringBuilder newDate = new StringBuilder();
    private GregorianCalendar gc;
    private Split split = new Split();

    private DateUtil(TimeZone timeZone) {
        this.gc = new GregorianCalendar(timeZone);
    }

    public static DateUtil getInstance() {
        return new DateUtil(TimeZone.getDefault());
    }

    public static DateUtil getInstance(TimeZone timeZone) {
        return new DateUtil(timeZone);
    }

    private static synchronized boolean validateDateWithRegex(String date, DateMask mask, DateSeparator separator) {
        regex.setLength(0);
        if (mask.equals((Object)DateMask.MMDDYYYY) || mask.equals((Object)DateMask.DDMMYYYY)) {
            regex.append(dayOrMonthRegex);
            regex.append("\\");
            regex.append(separator.getSeparator());
            regex.append(dayOrMonthRegex);
            regex.append("\\");
            regex.append(separator.getSeparator());
            regex.append(yearRegex);
        } else if (mask.equals((Object)DateMask.YYYYMMDD) || mask.equals((Object)DateMask.YYYYDDMM)) {
            regex.append(yearRegex);
            regex.append("\\");
            regex.append(separator.getSeparator());
            regex.append(dayOrMonthRegex);
            regex.append("\\");
            regex.append(separator.getSeparator());
            regex.append(dayOrMonthRegex);
        }
        return date != null && date.matches(regex.toString());
    }

    public static synchronized String convert(String sourceDate, DateMask sourceMask, DateSeparator sourceSeparator, DateMask targetMask, DateSeparator targetSeparator) {
        if (DateUtil.validateDateWithRegex(sourceDate, sourceMask, sourceSeparator)) {
            String year = null;
            String month = null;
            String day = null;
            staticSplit.perform(sourceDate, sourceSeparator.getSeparator());
            if (sourceMask == DateMask.DDMMYYYY) {
                day = DateUtil.staticSplit.n1.toString();
                month = DateUtil.staticSplit.n2.toString();
                year = DateUtil.staticSplit.n3.toString();
            } else if (sourceMask == DateMask.MMDDYYYY) {
                month = DateUtil.staticSplit.n1.toString();
                day = DateUtil.staticSplit.n2.toString();
                year = DateUtil.staticSplit.n3.toString();
            } else if (sourceMask == DateMask.YYYYMMDD) {
                year = DateUtil.staticSplit.n1.toString();
                month = DateUtil.staticSplit.n2.toString();
                day = DateUtil.staticSplit.n3.toString();
            } else if (sourceMask == DateMask.YYYYDDMM) {
                year = DateUtil.staticSplit.n1.toString();
                day = DateUtil.staticSplit.n2.toString();
                month = DateUtil.staticSplit.n3.toString();
            }
            newDate.setLength(0);
            if (targetMask == DateMask.DDMMYYYY) {
                newDate.append(DateUtil.convert(day));
                newDate.append(targetSeparator.getSeparator());
                newDate.append(DateUtil.convert(month));
                newDate.append(targetSeparator.getSeparator());
                newDate.append(DateUtil.convert(year));
            } else if (targetMask == DateMask.MMDDYYYY) {
                newDate.append(DateUtil.convert(month));
                newDate.append(targetSeparator.getSeparator());
                newDate.append(DateUtil.convert(day));
                newDate.append(targetSeparator.getSeparator());
                newDate.append(DateUtil.convert(year));
            } else if (targetMask == DateMask.YYYYMMDD) {
                newDate.append(DateUtil.convert(year));
                newDate.append(targetSeparator.getSeparator());
                newDate.append(DateUtil.convert(month));
                newDate.append(targetSeparator.getSeparator());
                newDate.append(DateUtil.convert(day));
            } else if (targetMask == DateMask.YYYYDDMM) {
                newDate.append(DateUtil.convert(year));
                newDate.append(targetSeparator.getSeparator());
                newDate.append(DateUtil.convert(day));
                newDate.append(targetSeparator.getSeparator());
                newDate.append(DateUtil.convert(month));
            }
            return newDate.toString();
        }
        return null;
    }

    public boolean isValid(DateMask mask, DateSeparator separator, String date) {
        return this.toDate(mask, separator, date) != null;
    }

    public Date toDate(Locale locale, DateSeparator separator, String date) {
        DateMask mask = DateMask.getMask(locale);
        return this.toDate(mask, separator, date);
    }

    public Date toDate(DateMask mask, DateSeparator separator, String date) {
        if (DateUtil.validateDateWithRegex(date, mask, separator)) {
            int year = 0;
            int month = 0;
            int day = 0;
            this.split.perform(date, separator.getSeparator());
            if (mask == DateMask.DDMMYYYY) {
                day = Integer.parseInt(this.split.n1.toString());
                month = Integer.parseInt(this.split.n2.toString());
                year = Integer.parseInt(this.split.n3.toString());
            } else if (mask == DateMask.MMDDYYYY) {
                month = Integer.parseInt(this.split.n1.toString());
                day = Integer.parseInt(this.split.n2.toString());
                year = Integer.parseInt(this.split.n3.toString());
            } else if (mask == DateMask.YYYYMMDD) {
                year = Integer.parseInt(this.split.n1.toString());
                month = Integer.parseInt(this.split.n2.toString());
                day = Integer.parseInt(this.split.n3.toString());
            } else if (mask == DateMask.YYYYDDMM) {
                year = Integer.parseInt(this.split.n1.toString());
                day = Integer.parseInt(this.split.n2.toString());
                month = Integer.parseInt(this.split.n3.toString());
            }
            try {
                this.gc.setLenient(false);
                this.gc.clear();
                this.gc.set(5, day);
                this.gc.set(2, month - 1);
                this.gc.set(1, year);
                return this.gc.getTime();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String toString(Locale locale, DateSeparator separator, long date) {
        return this.toString(DateMask.getMask(locale), separator, date);
    }

    public String toString(DateMask mask, DateSeparator separator, long date) {
        this.gc.setLenient(true);
        this.gc.clear();
        this.gc.setTimeInMillis(date);
        int year = this.gc.get(1);
        int month = this.gc.get(2) + 1;
        int day = this.gc.get(5);
        return DateUtil.toString(mask, separator, day, month, year);
    }

    public static String toString(DateMask mask, DateSeparator separator, int day, int month, int year) {
        char sep = separator.getSeparator();
        String strDate = "";
        if (day > 0 && month > 0 && year > 0) {
            if (mask.equals((Object)DateMask.DDMMYYYY)) {
                strDate = DateUtil.convert(day) + sep + DateUtil.convert(month) + sep + DateUtil.convert(year);
            } else if (mask.equals((Object)DateMask.MMDDYYYY)) {
                strDate = DateUtil.convert(month) + sep + DateUtil.convert(day) + sep + DateUtil.convert(year);
            } else if (mask.equals((Object)DateMask.YYYYMMDD)) {
                strDate = DateUtil.convert(year) + sep + DateUtil.convert(month) + sep + DateUtil.convert(day);
            } else if (mask.equals((Object)DateMask.YYYYDDMM)) {
                strDate = DateUtil.convert(year) + sep + DateUtil.convert(day) + sep + DateUtil.convert(month);
            }
        }
        return strDate;
    }

    private static String convert(int value) {
        if (value >= 0 && value <= 9) {
            return "0" + value;
        }
        return Integer.toString(value);
    }

    private static String convert(String value) {
        if (value.length() == 1) {
            return "0" + value;
        }
        return value;
    }

    private static class Split {
        public StringBuilder n1 = new StringBuilder();
        public StringBuilder n2 = new StringBuilder();
        public StringBuilder n3 = new StringBuilder();

        private Split() {
        }

        public void clear() {
            this.n1.setLength(0);
            this.n2.setLength(0);
            this.n3.setLength(0);
        }

        public void perform(String str, char separator) {
            this.clear();
            int n = 1;
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == separator) {
                    ++n;
                    continue;
                }
                if (n == 1) {
                    this.n1.append(c);
                    continue;
                }
                if (n == 2) {
                    this.n2.append(c);
                    continue;
                }
                if (n != 3) continue;
                this.n3.append(c);
            }
        }
    }
}

