/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import com.uwetrottmann.tmdb2.Tmdb;
import com.uwetrottmann.tmdb2.entities.Collection;
import com.uwetrottmann.tmdb2.entities.CollectionResultsPage;
import com.uwetrottmann.tmdb2.entities.Part;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.tmdb.TmdbConnectionCounter;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;

class TmdbMovieSetMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbMovieSetMetadataProvider.class);
    private Tmdb api;

    public TmdbMovieSetMetadataProvider(Tmdb api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaSearchResult> search(MediaSearchOptions query) throws Exception {
        LOGGER.debug("search() " + query.toString());
        ArrayList<MediaSearchResult> movieSetsFound = new ArrayList<MediaSearchResult>();
        String searchString = "";
        if (StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isNotEmpty((CharSequence)query.getQuery())) {
            searchString = query.getQuery();
        }
        if (StringUtils.isEmpty((CharSequence)searchString)) {
            LOGGER.debug("TMDB Scraper: empty searchString");
            return movieSetsFound;
        }
        String language = query.getLanguage().getLanguage();
        if (StringUtils.isNotBlank((CharSequence)query.getLanguage().getCountry())) {
            language = language + "-" + query.getLanguage().getCountry();
        }
        CollectionResultsPage resultsPage = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            TmdbConnectionCounter.trackConnections();
            try {
                resultsPage = (CollectionResultsPage)this.api.searchService().collection(searchString, 1, language).execute().body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to search: " + e.getMessage());
            }
        }
        if (resultsPage == null) {
            return movieSetsFound;
        }
        for (Collection collection : ListUtils.nullSafe(resultsPage.results)) {
            MediaSearchResult searchResult = new MediaSearchResult(TmdbMetadataProvider.providerInfo.getId(), MediaType.MOVIE_SET);
            searchResult.setId(Integer.toString(collection.id));
            searchResult.setTitle(collection.name);
            searchResult.setPosterUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + collection.poster_path);
            searchResult.setScore(MetadataUtil.calculateScore((String)searchString, (String)collection.name));
            movieSetsFound.add(searchResult);
        }
        return movieSetsFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaMetadata getMetadata(MediaScrapeOptions options) throws Exception {
        MediaArtwork ma;
        LOGGER.debug("getMetadata() " + options.toString());
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        int tmdbId = 0;
        try {
            tmdbId = Integer.parseInt(options.getId(TmdbMetadataProvider.providerInfo.getId()));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        if (tmdbId == 0) {
            tmdbId = options.getTmdbId();
        }
        if (tmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            return md;
        }
        String language = options.getLanguage().getLanguage();
        if (StringUtils.isNotBlank((CharSequence)options.getLanguage().getCountry())) {
            language = language + "-" + options.getLanguage().getCountry();
        }
        Collection collection = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            TmdbConnectionCounter.trackConnections();
            try {
                collection = (Collection)this.api.collectionService().summary(tmdbId, language, null).execute().body();
                if (StringUtils.isBlank((CharSequence)collection.overview) || StringUtils.isBlank((CharSequence)collection.name)) {
                    TmdbConnectionCounter.trackConnections();
                    Collection collectionInEn = (Collection)this.api.collectionService().summary(tmdbId, "en", null).execute().body();
                    if (StringUtils.isBlank((CharSequence)collection.name) && StringUtils.isNotBlank((CharSequence)collectionInEn.name)) {
                        collection.name = collectionInEn.name;
                    }
                    if (StringUtils.isBlank((CharSequence)collection.overview) && StringUtils.isNotBlank((CharSequence)collectionInEn.overview)) {
                        collection.overview = collectionInEn.overview;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: " + e.getMessage());
            }
        }
        md.setId("tmdbSet", (Object)collection.id);
        md.setTitle(collection.name);
        md.setPlot(collection.overview);
        if (StringUtils.isNotBlank((CharSequence)collection.poster_path)) {
            ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            ma.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w185" + collection.poster_path);
            ma.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + collection.poster_path);
            ma.setLanguage(options.getLanguage().getLanguage());
            ma.setTmdbId(tmdbId);
            md.addMediaArt(ma);
        }
        if (StringUtils.isNotBlank((CharSequence)collection.backdrop_path)) {
            ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
            ma.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w300" + collection.backdrop_path);
            ma.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "w1280" + collection.backdrop_path);
            ma.setLanguage(options.getLanguage().getLanguage());
            ma.setTmdbId(tmdbId);
            md.addMediaArt(ma);
        }
        for (Part part : ListUtils.nullSafe(collection.parts)) {
            MediaArtwork ma2;
            MediaMetadata mdSubItem = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
            mdSubItem.setId(TmdbMetadataProvider.providerInfo.getId(), (Object)part.id);
            mdSubItem.setTitle(part.title);
            if (StringUtils.isNotBlank((CharSequence)part.poster_path)) {
                ma2 = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
                ma2.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w185" + part.poster_path);
                ma2.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + part.poster_path);
                ma2.setLanguage(options.getLanguage().getLanguage());
                ma2.setTmdbId(part.id);
                mdSubItem.addMediaArt(ma2);
            }
            if (StringUtils.isNotBlank((CharSequence)part.backdrop_path)) {
                ma2 = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                ma2.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w300" + part.backdrop_path);
                ma2.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "w1280" + part.backdrop_path);
                ma2.setLanguage(options.getLanguage().getLanguage());
                ma2.setTmdbId(part.id);
                mdSubItem.addMediaArt(ma2);
            }
            mdSubItem.setReleaseDate(part.release_date);
            md.addSubItem(mdSubItem);
        }
        return md;
    }
}

