/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.dialogs.MovieEditorDialog;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieEditAction
extends AbstractAction {
    private static final long serialVersionUID = 1848573591741154631L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieEditAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("movie.edit"));
        }
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", BUNDLE.getString("movie.edit"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Movie movie;
        MovieEditorDialog editor;
        List<Movie> selectedMovies = MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovies();
        Iterator<Movie> i$ = selectedMovies.iterator();
        while (i$.hasNext() && (editor = new MovieEditorDialog(movie = i$.next(), selectedMovies.size() > 1)).showDialog()) {
        }
    }
}

