/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.fourthline.cling.support.contentdirectory.AbstractContentDirectoryService;
import org.fourthline.cling.support.contentdirectory.ContentDirectoryErrorCode;
import org.fourthline.cling.support.contentdirectory.ContentDirectoryException;
import org.fourthline.cling.support.contentdirectory.DIDLParser;
import org.fourthline.cling.support.model.BrowseFlag;
import org.fourthline.cling.support.model.BrowseResult;
import org.fourthline.cling.support.model.DIDLContent;
import org.fourthline.cling.support.model.SortCriterion;
import org.fourthline.cling.support.model.container.Container;
import org.fourthline.cling.support.model.container.StorageFolder;
import org.fourthline.cling.support.model.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.DynaComparator;
import org.tinymediamanager.thirdparty.upnp.Metadata;
import org.tinymediamanager.ui.UTF8Control;

public class ContentDirectoryService
extends AbstractContentDirectoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentDirectoryService.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public BrowseResult browse(String objectID, BrowseFlag browseFlag, String filter, long firstResult, long maxResults, SortCriterion[] orderby) throws ContentDirectoryException {
        try {
            LOGGER.debug("ObjectId: " + objectID);
            LOGGER.debug("BrowseFlag: " + browseFlag);
            LOGGER.debug("Filter: " + filter);
            LOGGER.debug("FirstResult: " + firstResult);
            LOGGER.debug("MaxResults: " + maxResults);
            LOGGER.debug("OrderBy: " + SortCriterion.toString((SortCriterion[])orderby));
            String orderMovie = "getTitle";
            String orderShow = "getTitle";
            DIDLContent didl = new DIDLContent();
            String[] path = StringUtils.split((String)objectID, (char)'/');
            if (browseFlag.equals((Object)BrowseFlag.METADATA)) {
                if (path[0].equals("0")) {
                    LOGGER.warn("Unable to get Metadata from root object!");
                    throw new ContentDirectoryException(ContentDirectoryErrorCode.CANNOT_PROCESS, "cannot get metadata from root");
                }
                if (path[0].equals("1")) {
                    Movie m;
                    if (path.length == 2 && (m = MovieList.getInstance().lookupMovie(UUID.fromString(path[1]))) != null) {
                        didl.addItem((Item)Metadata.getUpnpMovie(m, true));
                        return this.returnResult(didl);
                    }
                    throw new ContentDirectoryException(ContentDirectoryErrorCode.NO_SUCH_OBJECT, "cannot get metadata for " + objectID);
                }
                if (path[0].equals("2")) {
                    TvShowEpisode ep;
                    TvShow t;
                    if (path.length > 1 && (t = TvShowList.getInstance().lookupTvShow(UUID.fromString(path[1]))) != null && (ep = t.getEpisode(this.getInt(path[2]), this.getInt(path[3]))) != null) {
                        didl.addItem((Item)Metadata.getUpnpTvShowEpisode(t, ep, true));
                        return this.returnResult(didl);
                    }
                    throw new ContentDirectoryException(ContentDirectoryErrorCode.NO_SUCH_OBJECT, "cannot get metadata for " + objectID);
                }
            } else if (browseFlag.equals((Object)BrowseFlag.DIRECT_CHILDREN)) {
                if (path[0].equals("0")) {
                    StorageFolder cont = new StorageFolder();
                    cont.setId("1");
                    cont.setParentID("0");
                    cont.setTitle(BUNDLE.getString("tmm.movies"));
                    cont.setChildCount(Integer.valueOf(MovieList.getInstance().getMovieCount()));
                    didl.addContainer((Container)cont);
                    cont = new StorageFolder();
                    cont.setId("2");
                    cont.setParentID("0");
                    cont.setTitle(BUNDLE.getString("tmm.tvshows"));
                    cont.setChildCount(Integer.valueOf(TvShowList.getInstance().getTvShowCount()));
                    didl.addContainer((Container)cont);
                    return this.returnResult(didl);
                }
                if (path[0].equals("1")) {
                    List<Movie> tmmMovies = MovieList.getInstance().getMovies();
                    Collections.sort(tmmMovies, new DynaComparator(orderMovie));
                    for (Movie m : tmmMovies) {
                        didl.addItem((Item)Metadata.getUpnpMovie(m, false));
                    }
                    return this.returnResult(didl);
                }
                if (path[0].equals("2")) {
                    if (path.length == 1) {
                        List<TvShow> tmmShows = TvShowList.getInstance().getTvShows();
                        Collections.sort(tmmShows, new DynaComparator(orderShow));
                        for (TvShow t : tmmShows) {
                            StorageFolder cont = new StorageFolder();
                            cont.setId("2/" + t.getDbId());
                            cont.setParentID("0");
                            cont.setTitle(t.getTitle());
                            cont.setChildCount(Integer.valueOf(t.getEpisodeCount()));
                            didl.addContainer((Container)cont);
                        }
                        return this.returnResult(didl);
                    }
                    if (path.length == 2) {
                        UUID uuid = UUID.fromString(path[1]);
                        TvShow show = TvShowList.getInstance().lookupTvShow(uuid);
                        if (show != null) {
                            for (TvShowEpisode ep : show.getEpisodes()) {
                                didl.addItem((Item)Metadata.getUpnpTvShowEpisode(show, ep, false));
                            }
                            return this.returnResult(didl);
                        }
                        throw new ContentDirectoryException(ContentDirectoryErrorCode.NO_SUCH_OBJECT, "cannot get metadata for " + objectID);
                    }
                } else {
                    LOGGER.warn("Whoops. There was an error in our directory structure. " + objectID);
                }
            }
            throw new ContentDirectoryException(ContentDirectoryErrorCode.CANNOT_PROCESS, "BrowseFlag wrong " + browseFlag);
        }
        catch (Exception ex) {
            LOGGER.error("Browse failed", (Throwable)ex);
            throw new ContentDirectoryException(ContentDirectoryErrorCode.CANNOT_PROCESS, ex.toString());
        }
    }

    private BrowseResult returnResult(DIDLContent didl) throws Exception {
        DIDLParser dip = new DIDLParser();
        int count = didl.getItems().size() + didl.getContainers().size();
        String ret = dip.generate(didl);
        LOGGER.trace(ContentDirectoryService.prettyFormat(ret, 2));
        return new BrowseResult(ret, (long)count, (long)count);
    }

    private int getInt(String s) {
        int i = 0;
        try {
            i = Integer.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn("Cannot parse number from " + s);
        }
        return i;
    }

    public BrowseResult search(String containerId, String searchCriteria, String filter, long firstResult, long maxResults, SortCriterion[] orderBy) throws ContentDirectoryException {
        return super.search(containerId, searchCriteria, filter, firstResult, maxResults, orderBy);
    }

    public static String prettyFormat(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            return "! error parsing xml !";
        }
    }
}

