/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol.async;

import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.message.discovery.OutgoingSearchRequest;
import org.fourthline.cling.model.message.header.MXHeader;
import org.fourthline.cling.model.message.header.STAllHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.protocol.SendingAsync;
import org.fourthline.cling.transport.RouterException;

public class SendingSearch
extends SendingAsync {
    private static final Logger log = Logger.getLogger(SendingSearch.class.getName());
    private final UpnpHeader searchTarget;
    private final int mxSeconds;

    public SendingSearch(UpnpService upnpService) {
        this(upnpService, new STAllHeader());
    }

    public SendingSearch(UpnpService upnpService, UpnpHeader searchTarget) {
        this(upnpService, searchTarget, MXHeader.DEFAULT_VALUE);
    }

    public SendingSearch(UpnpService upnpService, UpnpHeader searchTarget, int mxSeconds) {
        super(upnpService);
        if (!UpnpHeader.Type.ST.isValidHeaderType(searchTarget.getClass())) {
            throw new IllegalArgumentException("Given search target instance is not a valid header class for type ST: " + searchTarget.getClass());
        }
        this.searchTarget = searchTarget;
        this.mxSeconds = mxSeconds;
    }

    public UpnpHeader getSearchTarget() {
        return this.searchTarget;
    }

    public int getMxSeconds() {
        return this.mxSeconds;
    }

    @Override
    protected void execute() throws RouterException {
        log.fine("Executing search for target: " + this.searchTarget.getString() + " with MX seconds: " + this.getMxSeconds());
        OutgoingSearchRequest msg = new OutgoingSearchRequest(this.searchTarget, this.getMxSeconds());
        this.prepareOutgoingSearchRequest(msg);
        for (int i = 0; i < this.getBulkRepeat(); ++i) {
            try {
                this.getUpnpService().getRouter().send(msg);
                log.finer("Sleeping " + this.getBulkIntervalMilliseconds() + " milliseconds");
                Thread.sleep(this.getBulkIntervalMilliseconds());
                continue;
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    public int getBulkRepeat() {
        return 5;
    }

    public int getBulkIntervalMilliseconds() {
        return 500;
    }

    protected void prepareOutgoingSearchRequest(OutgoingSearchRequest message) {
    }
}

