/*
 * Decompiled with CFR 0.152.
 */
package org.seamless.swing;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import org.seamless.swing.Controller;
import org.seamless.swing.DefaultAction;
import org.seamless.swing.Event;
import org.seamless.swing.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractController<V extends Container>
implements Controller<V> {
    private static Logger log = Logger.getLogger(AbstractController.class.getName());
    private V view;
    private Controller parentController;
    private List<Controller> subControllers = new ArrayList<Controller>();
    private Map<String, DefaultAction> actions = new HashMap<String, DefaultAction>();
    private Map<Class, List<EventListener>> eventListeners = new HashMap<Class, List<EventListener>>();

    public AbstractController(V view) {
        this.view = view;
    }

    public AbstractController() {
    }

    public AbstractController(Controller parentController) {
        this(null, parentController);
    }

    public AbstractController(V view, Controller parentController) {
        this.view = view;
        if (parentController != null) {
            this.parentController = parentController;
            parentController.getSubControllers().add(this);
        }
    }

    @Override
    public V getView() {
        return this.view;
    }

    @Override
    public Controller getParentController() {
        return this.parentController;
    }

    @Override
    public List<Controller> getSubControllers() {
        return this.subControllers;
    }

    @Override
    public void dispose() {
        log.fine("Disposing controller");
        Iterator<Controller> it = this.subControllers.iterator();
        while (it.hasNext()) {
            Controller subcontroller = it.next();
            subcontroller.dispose();
            it.remove();
        }
    }

    @Override
    public void registerAction(AbstractButton source, DefaultAction action) {
        source.removeActionListener(this);
        source.addActionListener(this);
        this.actions.put(source.getActionCommand(), action);
    }

    @Override
    public void registerAction(AbstractButton source, String actionCommand, DefaultAction action) {
        source.setActionCommand(actionCommand);
        this.registerAction(source, action);
    }

    public void deregisterAction(String actionCommand) {
        this.actions.remove(actionCommand);
    }

    @Override
    public void registerEventListener(Class eventClass, EventListener eventListener) {
        log.fine("Registering listener: " + eventListener + " for event type: " + eventClass.getName());
        List<EventListener> listenersForEvent = this.eventListeners.get(eventClass);
        if (listenersForEvent == null) {
            listenersForEvent = new ArrayList<EventListener>();
        }
        listenersForEvent.add(eventListener);
        this.eventListeners.put(eventClass, listenersForEvent);
    }

    @Override
    public void fireEvent(Event event) {
        this.fireEvent(event, false);
    }

    @Override
    public void fireEventGlobal(Event event) {
        this.fireEvent(event, true);
    }

    @Override
    public void fireEvent(Event event, boolean global) {
        if (!event.alreadyFired(this)) {
            log.finest("Event has not been fired already");
            if (this.eventListeners.get(event.getClass()) != null) {
                log.finest("Have listeners for this type of event: " + this.eventListeners.get(event.getClass()));
                for (EventListener eventListener : this.eventListeners.get(event.getClass())) {
                    log.fine("Processing event: " + event.getClass().getName() + " with listener: " + eventListener.getClass().getName());
                    eventListener.handleEvent(event);
                }
            }
            event.addFiredInController(this);
            log.fine("Passing event: " + event.getClass().getName() + " DOWN in the controller hierarchy");
            for (Controller subController : this.subControllers) {
                subController.fireEvent(event, global);
            }
        } else {
            log.finest("Event already fired here, ignoring...");
        }
        if (this.getParentController() != null && !event.alreadyFired(this.getParentController()) && global) {
            log.fine("Passing event: " + event.getClass().getName() + " UP in the controller hierarchy");
            this.getParentController().fireEvent(event, global);
        } else {
            log.finest("Event does not propagate up the tree from here");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block10: {
            try {
                AbstractButton button = (AbstractButton)actionEvent.getSource();
                String actionCommand = button.getActionCommand();
                DefaultAction action = this.actions.get(actionCommand);
                if (action != null) {
                    log.fine("Handling command: " + actionCommand + " with action: " + action.getClass());
                    try {
                        this.preActionExecute();
                        log.fine("Dispatching to action for execution");
                        action.executeInController(this, actionEvent);
                        this.postActionExecute();
                        break block10;
                    }
                    catch (RuntimeException ex) {
                        this.failedActionExecute();
                        throw ex;
                    }
                    catch (Exception ex) {
                        this.failedActionExecute();
                        throw new RuntimeException(ex);
                    }
                    finally {
                        this.finalActionExecute();
                    }
                }
                if (this.getParentController() != null) {
                    log.fine("Passing action on to parent controller");
                    this.parentController.actionPerformed(actionEvent);
                    break block10;
                }
                throw new RuntimeException("Nobody is responsible for action command: " + actionCommand);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Action source is not an Abstractbutton: " + actionEvent);
            }
        }
    }

    @Override
    public void preActionExecute() {
    }

    @Override
    public void postActionExecute() {
    }

    @Override
    public void failedActionExecute() {
    }

    @Override
    public void finalActionExecute() {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
        ((JFrame)this.getView()).dispose();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

