/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.net;

import com.a.a.a;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.net.Downloader;
import com.threerings.getdown.util.ConnectionUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPDownloader
extends Downloader {
    public HTTPDownloader(List<Resource> list, Downloader.Observer observer) {
        super(list, observer);
    }

    @Override
    protected long checkSize(Resource resource) throws IOException {
        URLConnection uRLConnection = ConnectionUtil.open(resource.getRemote());
        try {
            HttpURLConnection httpURLConnection;
            if (uRLConnection instanceof HttpURLConnection) {
                httpURLConnection = (HttpURLConnection)uRLConnection;
                httpURLConnection.setRequestMethod("HEAD");
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() != 200) {
                    throw new IOException("Unable to check up-to-date for " + resource.getRemote() + ": " + httpURLConnection.getResponseCode());
                }
            } else if (uRLConnection instanceof HttpsURLConnection) {
                httpURLConnection = (HttpsURLConnection)uRLConnection;
                httpURLConnection.setRequestMethod("HEAD");
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() != 200) {
                    throw new IOException("Unable to check up-to-date for " + resource.getRemote() + ": " + httpURLConnection.getResponseCode());
                }
            }
            long l2 = uRLConnection.getContentLength();
            return l2;
        }
        finally {
            uRLConnection.getInputStream().close();
        }
    }

    @Override
    protected void doDownload(Resource object) throws IOException {
        HttpURLConnection httpURLConnection;
        URLConnection uRLConnection = ConnectionUtil.open(((Resource)object).getRemote());
        uRLConnection.connect();
        if (uRLConnection instanceof HttpURLConnection ? (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode() != 200 : uRLConnection instanceof HttpsURLConnection && (httpURLConnection = (HttpsURLConnection)uRLConnection).getResponseCode() != 200) {
            throw new IOException("Unable to download resource " + ((Resource)object).getRemote() + ": " + httpURLConnection.getResponseCode());
        }
        long l2 = uRLConnection.getContentLength();
        Log.log.a("Downloading resource", "url", ((Resource)object).getRemote(), "size", l2);
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        long l3 = 0L;
        try {
            int n2;
            inputStream = uRLConnection.getInputStream();
            fileOutputStream = new FileOutputStream(((Resource)object).getLocal());
            while ((n2 = inputStream.read(this._buffer)) != -1) {
                fileOutputStream.write(this._buffer, 0, n2);
                if (this._obs == null) continue;
                this.updateObserver((Resource)object, l3 += (long)n2, l2);
            }
        }
        catch (Throwable throwable) {
            a.a(inputStream);
            a.a(fileOutputStream);
            object = ((Resource)object).getLocal();
            if (((File)object).getName().toLowerCase().endsWith(".sh")) {
                ((File)object).setExecutable(true);
            }
            throw throwable;
        }
        a.a(inputStream);
        a.a(fileOutputStream);
        File file = ((Resource)object).getLocal();
        if (file.getName().toLowerCase().endsWith(".sh")) {
            file.setExecutable(true);
        }
    }
}

