/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlUtil.class);

    public static URI getURIEncoded(String url) throws URISyntaxException {
        String[] trArr = url.split("://");
        return new URI(trArr[0], "//" + trArr[1], null);
    }

    public static String getFileExtension(String url) throws URISyntaxException {
        String ext = UrlUtil.getURIEncoded(url).getPath();
        if (ext == null || ext.isEmpty() || !ext.contains(".")) {
            LOGGER.warn("Url " + url + " has no extension!");
            return "";
        }
        ext = UrlUtil.getFileNameArray(url)[1];
        return ext;
    }

    public static String getBasename(String url) {
        return UrlUtil.getFileNameArray(url)[0];
    }

    public static String getExtension(String url) {
        return UrlUtil.getFileNameArray(url)[1];
    }

    public static String getFilename(String url) {
        return UrlUtil.getFileNameArray(url)[2];
    }

    public static String getBaseUrl(String url) {
        String path = UrlUtil.getPathName(url);
        if (path != null && path.contains("/")) {
            path = path.substring(0, path.lastIndexOf(47));
        }
        return UrlUtil.getDomainUrl(url) + path;
    }

    public static String getDomainUrl(String url) {
        try {
            URL u = new URL(url);
            return String.format("%s://%s/", u.getProtocol(), u.getHost());
        }
        catch (MalformedURLException e) {
            LOGGER.error("Failed to get domain url for: " + url);
            return null;
        }
    }

    public static String joinUrlPath(String baseUrl, String path) {
        StringBuffer sb = new StringBuffer(baseUrl);
        if (baseUrl.endsWith("/") && path.startsWith("/")) {
            path = path.substring(1);
        }
        sb.append(path);
        return sb.toString();
    }

    public static String getPathName(String url) {
        try {
            URL u = new URL(url);
            return u.getPath();
        }
        catch (MalformedURLException e) {
            LOGGER.error("getPathName() Failed! " + url, (Throwable)e);
            return null;
        }
    }

    public static String[] getFileNameArray(String url) {
        String[] ret = new String[]{"", "", ""};
        String filename = "";
        String path = "";
        try {
            url = UrlUtil.getURIEncoded(url).toString();
            path = new URL(url).getPath();
        }
        catch (Exception e) {
            return ret;
        }
        String[] pathContents = path.split("[\\\\/]");
        if (pathContents != null) {
            int pathContentsLength = pathContents.length;
            String lastPart = pathContents[pathContentsLength - 1];
            String[] lastPartContents = lastPart.split("\\.");
            if (lastPartContents != null && lastPartContents.length > 1) {
                int lastPartContentLength = lastPartContents.length;
                String name = "";
                for (int i = 0; i < lastPartContentLength; ++i) {
                    if (i >= lastPartContents.length - 1) continue;
                    name = name + lastPartContents[i];
                    if (i >= lastPartContentLength - 2) continue;
                    name = name + ".";
                }
                String extension = lastPartContents[lastPartContentLength - 1];
                filename = name + "." + extension;
                ret = new String[]{name, extension, filename};
            } else {
                String name = lastPartContents[0];
                ret = new String[]{name, "", name};
            }
        }
        return ret;
    }

    public static String encode(String data) {
        if (data == null) {
            return "";
        }
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("Failed to url encode data: " + data + " as UTF-8; will try again using default encoding", (Throwable)e);
            return URLEncoder.encode(data);
        }
    }

    public static String generateUA() {
        return UrlUtil.generateUA(Locale.getDefault().getLanguage());
    }

    public static String generateUA(String language) {
        String hardcodeOS = "";
        hardcodeOS = SystemUtils.IS_OS_WINDOWS ? "Windows; Windows NT " + System.getProperty("os.version") : (SystemUtils.IS_OS_MAC ? "Macintosh" : (SystemUtils.IS_OS_LINUX ? "X11" : System.getProperty("os.name")));
        Locale l = UrlUtil.getLocaleFromLanguage(language);
        return String.format("Mozilla/5.0 (%1$s; %2$s %3$s; U; %4$s; %5$s-%6$s; rv:40.0) Gecko/20100101 Firefox/40.0", hardcodeOS, System.getProperty("os.name", ""), System.getProperty("os.version", ""), System.getProperty("os.arch", ""), l.getLanguage(), l.getCountry());
    }

    public static Locale getLocaleFromLanguage(String language) {
        if (language == null || language.isEmpty()) {
            return null;
        }
        if (language.equalsIgnoreCase("en")) {
            return new Locale("en", "US");
        }
        Locale l = null;
        List countries = LocaleUtils.countriesByLanguage((String)language.toLowerCase(Locale.ROOT));
        for (Locale locale : countries) {
            if (!locale.getCountry().equalsIgnoreCase(language)) continue;
            l = locale;
        }
        if (l == null && countries.size() > 0) {
            l = (Locale)countries.get(0);
        }
        return l;
    }
}

