/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.scraper.http.Url;

public class YoutubeLinkExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(YoutubeLinkExtractor.class);
    static final Map<Integer, VideoQuality> itagMap = new HashMap<Integer, VideoQuality>();
    private static Pattern patternAge;
    private static Pattern patternUnavailable;
    private static Pattern patternUrlencod;
    private static Pattern patternUrl;
    private static Pattern patternStream;
    private static Pattern patternLink;
    private static Pattern patternDecryptFunction;
    private static Pattern patternSubfunction;
    private static Pattern playerUrlPattern;
    private String youtubeUrl;
    private String id;
    private String jsonConfiguration;
    private String playerJavascript;

    public YoutubeLinkExtractor(String youtubeUrl) {
        this.youtubeUrl = youtubeUrl;
    }

    public String extractVideoUrl() throws IOException, InterruptedException {
        this.id = YoutubeLinkExtractor.extractId(this.youtubeUrl);
        if (StringUtils.isBlank((CharSequence)this.id)) {
            return "";
        }
        LOGGER.debug("Parsed youtube id: " + this.id);
        VideoQuality desiredQuality = itagMap.get(YoutubeLinkExtractor.extractQuality(this.youtubeUrl));
        if (desiredQuality == null) {
            switch (MovieModuleManager.MOVIE_SETTINGS.getTrailerQuality()) {
                case HD_1080: {
                    desiredQuality = VideoQuality.p1080;
                    break;
                }
                case HD_720: {
                    desiredQuality = VideoQuality.p720;
                    break;
                }
                default: {
                    desiredQuality = VideoQuality.p480;
                }
            }
        }
        try {
            Url jsonConfigUrl = new Url(this.youtubeUrl + "&spf=prefetch");
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)jsonConfigUrl.getInputStream(), (Writer)writer, (String)"UTF-8");
            this.jsonConfiguration = writer.toString();
            List<VideoDownload> downloads = this.extractJsonInfo();
            if (!downloads.isEmpty()) {
                for (VideoDownload dl : downloads) {
                    if (dl.vq != desiredQuality) continue;
                    return URLDecoder.decode(dl.url.toExternalForm(), "UTF-8");
                }
                Iterator<VideoDownload> i$ = downloads.iterator();
                if (i$.hasNext()) {
                    VideoDownload dl;
                    dl = i$.next();
                    return URLDecoder.decode(dl.url.toExternalForm(), "UTF-8");
                }
            }
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    public static String extractId(String url) {
        Pattern u = Pattern.compile("youtube.com/watch?.*v=([^&]*)");
        Matcher um = u.matcher(url.toString());
        if (um.find()) {
            return um.group(1);
        }
        u = Pattern.compile("youtube.com/v/([^&]*)");
        um = u.matcher(url.toString());
        if (um.find()) {
            return um.group(1);
        }
        return "";
    }

    public static int extractQuality(String url) {
        Pattern u = Pattern.compile("youtube.com/watch?.*fmt=([^&]*)");
        Matcher um = u.matcher(url.toString());
        if (um.find()) {
            try {
                return Integer.parseInt(um.group(1));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((um = (u = Pattern.compile("youtube.com/v/.*fmt=([^&]*)")).matcher(url.toString())).find()) {
            try {
                return Integer.parseInt(um.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private List<VideoDownload> extractJsonInfo() throws Exception {
        ArrayList<VideoDownload> sNextVideoURL = new ArrayList<VideoDownload>();
        Matcher matcher = patternAge.matcher(this.jsonConfiguration);
        if (matcher.find()) {
            return sNextVideoURL;
        }
        matcher = patternUnavailable.matcher(this.jsonConfiguration);
        if (matcher.find()) {
            return sNextVideoURL;
        }
        matcher = patternUrlencod.matcher(this.jsonConfiguration);
        if (matcher.find()) {
            Matcher encodStreamMatch;
            String url_encoded_fmt_stream_map = matcher.group(1);
            Matcher encodMatch = patternUrl.matcher(url_encoded_fmt_stream_map);
            if (encodMatch.find()) {
                String sline = encodMatch.group(1);
                sNextVideoURL.addAll(this.extractUrlEncodedVideos(sline, this.id));
            }
            if ((encodStreamMatch = patternStream.matcher(url_encoded_fmt_stream_map)).find()) {
                String[] urlStrings;
                String sline = encodStreamMatch.group(1);
                for (String urlString : urlStrings = sline.split("stream=")) {
                    Matcher linkMatch = patternLink.matcher(urlString = StringEscapeUtils.unescapeJava((String)urlString));
                    if (!linkMatch.find()) continue;
                    String sparams = linkMatch.group(1);
                    String itag = linkMatch.group(2);
                    String url = linkMatch.group(3);
                    url = "http" + url + "?" + sparams;
                    url = URLDecoder.decode(url, "UTF-8");
                    this.addVideo(sNextVideoURL, itag, new URL(url));
                }
            }
        }
        Collections.sort(sNextVideoURL, new VideoUrlComparator());
        return sNextVideoURL;
    }

    private List<VideoDownload> extractUrlEncodedVideos(String sline, String id) throws Exception {
        String[] urlStrings;
        ArrayList<VideoDownload> sNextVideoURL = new ArrayList<VideoDownload>();
        for (String urlString : urlStrings = sline.split("url=")) {
            Pattern link;
            Matcher linkMatch;
            String sig;
            urlString = StringEscapeUtils.unescapeJava((String)urlString);
            String urlFull = URLDecoder.decode(urlString, "UTF-8");
            String url = null;
            Pattern link2 = Pattern.compile("([^&,]*)[&,]");
            Matcher linkMatch2 = link2.matcher(urlString);
            if (linkMatch2.find()) {
                url = linkMatch2.group(1);
                url = URLDecoder.decode(url, "UTF-8");
            }
            String itag = null;
            Pattern link3 = Pattern.compile("itag=(\\d+)");
            Matcher linkMatch3 = link3.matcher(urlFull);
            if (linkMatch3.find()) {
                itag = linkMatch3.group(1);
            }
            if ((sig = null) == null && (linkMatch = (link = Pattern.compile("&signature=([^&,]*)")).matcher(urlFull)).find()) {
                sig = linkMatch.group(1);
            }
            if (sig == null && (linkMatch = (link = Pattern.compile("sig=([^&,]*)")).matcher(urlFull)).find()) {
                sig = linkMatch.group(1);
            }
            if (sig == null && (linkMatch = (link = Pattern.compile("[&,]s=([^&,]*)")).matcher(urlFull)).find()) {
                sig = linkMatch.group(1);
                sig = this.decryptSignature(sig);
            }
            if (url == null || itag == null || sig == null) continue;
            try {
                url = url + "&signature=" + sig;
                this.addVideo(sNextVideoURL, itag, new URL(url));
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return sNextVideoURL;
    }

    private void addVideo(List<VideoDownload> sNextVideoURL, String itag, URL url) {
        Integer i = Integer.decode(itag);
        VideoQuality vd = itagMap.get(i);
        sNextVideoURL.add(new VideoDownload(vd, url));
    }

    private String decryptSignature(String encryptedSignature) throws Exception {
        Matcher matcher = playerUrlPattern.matcher(this.jsonConfiguration);
        if (matcher.find()) {
            if (StringUtils.isBlank((CharSequence)this.playerJavascript)) {
                Url jsPlayer = new Url("https:" + matcher.group(1).replaceAll("\\\\", ""));
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)jsPlayer.getInputStream(), (Writer)writer, (String)"UTF-8");
                this.playerJavascript = writer.toString();
            }
            if (StringUtils.isBlank((CharSequence)this.playerJavascript)) {
                return "";
            }
            matcher = patternDecryptFunction.matcher(this.playerJavascript);
            if (matcher.find()) {
                String decryptFunction = matcher.group(1);
                String javaScript = this.extractJavascriptCode(this.playerJavascript, decryptFunction);
                ScriptEngineManager factory = new ScriptEngineManager();
                ScriptEngine engine = factory.getEngineByName("JavaScript");
                engine.eval(javaScript);
                Invocable inv = (Invocable)((Object)engine);
                String result = (String)inv.invokeFunction(decryptFunction, encryptedSignature);
                return result;
            }
        }
        return "";
    }

    private String extractJavascriptCode(String fullSource, String functionName) {
        String functionSource = this.getMethodBody(fullSource, functionName);
        if (StringUtils.isNotBlank((CharSequence)functionSource)) {
            List<JSObjectMethod> subfunctions = this.getSubfunctions(functionSource);
            for (JSObjectMethod function : subfunctions) {
                if (function.method.equals("split") || function.method.equals("join")) continue;
                if (function.object != null) {
                    Pattern pattern;
                    Matcher matcher;
                    if (functionSource.contains(function.object + "={") || !(matcher = (pattern = Pattern.compile("(" + function.object + "=\\{.*?\\});")).matcher(fullSource)).find()) continue;
                    functionSource = functionSource + matcher.group(1);
                    continue;
                }
                functionSource = functionSource + this.getMethodBody(fullSource, function.method);
            }
        }
        return functionSource;
    }

    private String getMethodBody(String fullSource, String functionName) {
        Pattern pattern = Pattern.compile("(function " + functionName + "\\([^)]+?\\)\\{[^}]+?\\})");
        Matcher matcher = pattern.matcher(fullSource);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private List<JSObjectMethod> getSubfunctions(String functionSource) {
        boolean first = true;
        ArrayList<JSObjectMethod> subfunctions = new ArrayList<JSObjectMethod>();
        Matcher matcher = patternSubfunction.matcher(functionSource);
        while (matcher.find()) {
            if (first) {
                first = false;
                continue;
            }
            subfunctions.add(new JSObjectMethod(matcher.group(1), matcher.group(2)));
        }
        return subfunctions;
    }

    static {
        itagMap.put(264, VideoQuality.p1080);
        itagMap.put(248, VideoQuality.p1080);
        itagMap.put(247, VideoQuality.p720);
        itagMap.put(246, VideoQuality.p480);
        itagMap.put(245, VideoQuality.p480);
        itagMap.put(244, VideoQuality.p480);
        itagMap.put(243, VideoQuality.p360);
        itagMap.put(242, VideoQuality.p240);
        itagMap.put(137, VideoQuality.p1080);
        itagMap.put(136, VideoQuality.p720);
        itagMap.put(135, VideoQuality.p480);
        itagMap.put(134, VideoQuality.p360);
        itagMap.put(133, VideoQuality.p240);
        itagMap.put(120, VideoQuality.p720);
        itagMap.put(102, VideoQuality.p720);
        itagMap.put(101, VideoQuality.p360);
        itagMap.put(100, VideoQuality.p360);
        itagMap.put(85, VideoQuality.p1080);
        itagMap.put(84, VideoQuality.p720);
        itagMap.put(83, VideoQuality.p480);
        itagMap.put(82, VideoQuality.p360);
        itagMap.put(46, VideoQuality.p1080);
        itagMap.put(45, VideoQuality.p720);
        itagMap.put(44, VideoQuality.p480);
        itagMap.put(43, VideoQuality.p360);
        itagMap.put(38, VideoQuality.p3072);
        itagMap.put(37, VideoQuality.p1080);
        itagMap.put(36, VideoQuality.p240);
        itagMap.put(35, VideoQuality.p480);
        itagMap.put(34, VideoQuality.p360);
        itagMap.put(22, VideoQuality.p720);
        itagMap.put(18, VideoQuality.p360);
        itagMap.put(17, VideoQuality.p144);
        itagMap.put(6, VideoQuality.p270);
        itagMap.put(5, VideoQuality.p240);
        patternAge = Pattern.compile("(verify_age)");
        patternUnavailable = Pattern.compile("(unavailable-player)");
        patternUrlencod = Pattern.compile("\"url_encoded_fmt_stream_map\":\"([^\"]*)\"");
        patternUrl = Pattern.compile("url=(.*)");
        patternStream = Pattern.compile("stream=(.*)");
        patternLink = Pattern.compile("(sparams.*)&itag=(\\d+)&.*&conn=rtmpe(.*),");
        patternDecryptFunction = Pattern.compile("signature=(\\w+?)\\([^)]\\)");
        patternSubfunction = Pattern.compile("([a-zA-Z]*?)[.]?(\\w+?)\\([^)]*?\\)");
        playerUrlPattern = Pattern.compile("\\\"assets\\\":\\{.*?\\\"js\\\":\\\"(.*?)\\\"");
    }

    private class VideoUrlComparator
    implements Comparator<VideoDownload> {
        private VideoUrlComparator() {
        }

        @Override
        public int compare(VideoDownload o1, VideoDownload o2) {
            if (o1.vq == null) {
                return 1;
            }
            if (o2.vq == null) {
                return -1;
            }
            if (o1.vq.ordinal() == o2.vq.ordinal()) {
                return 0;
            }
            if (o1.vq.ordinal() > o2.vq.ordinal()) {
                return 1;
            }
            return -1;
        }
    }

    private class JSObjectMethod {
        String object;
        String method;

        public JSObjectMethod(String object, String method) {
            this.object = object;
            this.method = method;
        }
    }

    private class VideoDownload {
        public VideoQuality vq;
        public URL url;

        public VideoDownload(VideoQuality vq, URL u) {
            this.vq = vq;
            this.url = u;
        }
    }

    private static enum VideoQuality {
        p3072,
        p2304,
        p1080,
        p720,
        p520,
        p480,
        p360,
        p270,
        p240,
        p224,
        p144;

    }
}

