/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.thetvdbapi;

import com.omertron.thetvdbapi.TvDbException;
import com.omertron.thetvdbapi.model.Actor;
import com.omertron.thetvdbapi.model.Banners;
import com.omertron.thetvdbapi.model.Episode;
import com.omertron.thetvdbapi.model.Language;
import com.omertron.thetvdbapi.model.Series;
import com.omertron.thetvdbapi.model.TVDBUpdates;
import com.omertron.thetvdbapi.tools.TvdbParser;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TheTVDBApi {
    private static final Logger LOG = LoggerFactory.getLogger(TheTVDBApi.class);
    private String apiKey = null;
    private static final String BASE_URL = "http://thetvdb.com/api/";
    private static final String XML_EXTENSION = ".xml";
    private static final String SERIES_URL = "/series/";
    private static final String ALL_URL = "/all/";
    private static final String WEEKLY_UPDATES_URL = "/updates/updates_week.xml";
    private static final String URL = "URL: {}";

    public TheTVDBApi(String apiKey) {
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            return;
        }
        this.apiKey = apiKey;
    }

    public Series getSeries(String id, String language) throws TvDbException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(BASE_URL).append(this.apiKey).append(SERIES_URL).append(id).append("/");
        if (StringUtils.isNotBlank((CharSequence)language)) {
            urlBuilder.append(language).append(XML_EXTENSION);
        }
        LOG.trace(URL, (Object)urlBuilder.toString());
        List<Series> seriesList = TvdbParser.getSeriesList(urlBuilder.toString());
        if (seriesList.isEmpty()) {
            return null;
        }
        return seriesList.get(0);
    }

    public List<Episode> getAllEpisodes(String id, String language) throws TvDbException {
        List<Episode> episodeList = Collections.emptyList();
        if (this.isValidNumber(id)) {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(BASE_URL).append(this.apiKey).append(SERIES_URL).append(id).append(ALL_URL);
            if (StringUtils.isNotBlank((CharSequence)language)) {
                urlBuilder.append(language).append(XML_EXTENSION);
            }
            LOG.trace(URL, (Object)urlBuilder.toString());
            episodeList = TvdbParser.getAllEpisodes(urlBuilder.toString(), -1);
        }
        return episodeList;
    }

    public List<Episode> getSeasonEpisodes(String id, int season, String language) throws TvDbException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(BASE_URL).append(this.apiKey).append(SERIES_URL).append(id).append(ALL_URL);
        if (StringUtils.isNotBlank((CharSequence)language)) {
            urlBuilder.append(language).append(XML_EXTENSION);
        }
        LOG.trace(URL, (Object)urlBuilder.toString());
        return TvdbParser.getAllEpisodes(urlBuilder.toString(), season);
    }

    public Episode getEpisode(String seriesId, int seasonNbr, int episodeNbr, String language) throws TvDbException {
        return this.getTVEpisode(seriesId, seasonNbr, episodeNbr, language, "/default/");
    }

    public Episode getDVDEpisode(String seriesId, int seasonNbr, int episodeNbr, String language) throws TvDbException {
        return this.getTVEpisode(seriesId, seasonNbr, episodeNbr, language, "/dvd/");
    }

    private Episode getTVEpisode(String seriesId, int seasonNbr, int episodeNbr, String language, String episodeType) throws TvDbException {
        if (!(this.isValidNumber(seriesId) && this.isValidNumber(seasonNbr) && this.isValidNumber(episodeNbr))) {
            return new Episode();
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(BASE_URL).append(this.apiKey).append(SERIES_URL).append(seriesId).append(episodeType).append(seasonNbr).append("/").append(episodeNbr).append("/");
        if (StringUtils.isNotBlank((CharSequence)language)) {
            urlBuilder.append(language).append(XML_EXTENSION);
        }
        LOG.trace(URL, (Object)urlBuilder.toString());
        return TvdbParser.getEpisode(urlBuilder.toString());
    }

    public Episode getAbsoluteEpisode(String seriesId, int episodeNbr, String language) throws TvDbException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(BASE_URL).append(this.apiKey).append(SERIES_URL).append(seriesId).append("/absolute/").append(episodeNbr).append("/");
        if (StringUtils.isNotBlank((CharSequence)language)) {
            urlBuilder.append(language).append(XML_EXTENSION);
        }
        LOG.trace(URL, (Object)urlBuilder.toString());
        return TvdbParser.getEpisode(urlBuilder.toString());
    }

    public String getSeasonYear(String id, int seasonNbr, String language) throws TvDbException {
        String year = null;
        Episode episode = this.getEpisode(id, seasonNbr, 1, language);
        if (episode != null && StringUtils.isNotBlank((CharSequence)episode.getFirstAired())) {
            Date date;
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                date = dateFormat.parse(episode.getFirstAired());
            }
            catch (ParseException ex) {
                LOG.trace("Failed to transform date: {}", (Object)episode.getFirstAired(), (Object)ex);
                date = null;
            }
            if (date != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                year = String.valueOf(cal.get(1));
            }
        }
        return year;
    }

    public Banners getBanners(String seriesId) throws TvDbException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(BASE_URL).append(this.apiKey).append(SERIES_URL).append(seriesId).append("/banners.xml");
        LOG.trace(URL, (Object)urlBuilder.toString());
        Banners b = TvdbParser.getBanners(urlBuilder.toString());
        if (b != null) {
            b.setSeriesId(NumberUtils.toInt((String)seriesId));
        }
        return b;
    }

    public List<Actor> getActors(String seriesId) throws TvDbException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(BASE_URL).append(this.apiKey).append(SERIES_URL).append(seriesId).append("/actors.xml");
        LOG.trace(URL, (Object)urlBuilder.toString());
        return TvdbParser.getActors(urlBuilder.toString());
    }

    public List<Series> searchSeries(String title, String language) throws TvDbException {
        StringBuilder urlBuilder = new StringBuilder();
        try {
            urlBuilder.append(BASE_URL).append("GetSeries.php?seriesname=").append(URLEncoder.encode(title, "UTF-8"));
            if (StringUtils.isNotBlank((CharSequence)language)) {
                urlBuilder.append("&language=").append(language);
            }
        }
        catch (UnsupportedEncodingException ex) {
            LOG.trace("Failed to encode title: {}", (Object)title, (Object)ex);
            urlBuilder.append(title);
        }
        LOG.trace(URL, (Object)urlBuilder.toString());
        return TvdbParser.getSeriesList(urlBuilder.toString());
    }

    public Episode getEpisodeById(String episodeId, String language) throws TvDbException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(BASE_URL).append(this.apiKey).append("/episodes/").append(episodeId).append("/");
        if (StringUtils.isNotBlank((CharSequence)language)) {
            urlBuilder.append(language);
            urlBuilder.append(XML_EXTENSION);
        }
        LOG.trace(URL, (Object)urlBuilder.toString());
        return TvdbParser.getEpisode(urlBuilder.toString());
    }

    public TVDBUpdates getWeeklyUpdates() throws TvDbException {
        return this.getWeeklyUpdates(0);
    }

    public TVDBUpdates getWeeklyUpdates(int seriesId) throws TvDbException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(BASE_URL).append(this.apiKey).append(WEEKLY_UPDATES_URL);
        LOG.trace(URL, (Object)urlBuilder.toString());
        return TvdbParser.getUpdates(urlBuilder.toString(), seriesId);
    }

    public List<Language> getLanguages() throws TvDbException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(BASE_URL).append(this.apiKey).append("/languages").append(XML_EXTENSION);
        LOG.trace(URL, (Object)urlBuilder.toString());
        return TvdbParser.getLanguages(urlBuilder.toString());
    }

    private boolean isValidNumber(String number) {
        return this.isValidNumber(NumberUtils.toInt((String)number, (int)0));
    }

    private boolean isValidNumber(int number) {
        return number >= 0;
    }
}

