/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class BaseTextAreaUI
extends BasicTextAreaUI {
    private Border orgBorder = null;
    private FocusListener focusListener = null;

    public static ComponentUI createUI(JComponent c) {
        return new BaseTextAreaUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.updateBackground();
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (JTattooUtilities.isMac()) {
            InputMap im = (InputMap)UIManager.get("TextArea.focusInputMap");
            int commandKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            im.put(KeyStroke.getKeyStroke(67, commandKey), "copy-to-clipboard");
            im.put(KeyStroke.getKeyStroke(86, commandKey), "paste-from-clipboard");
            im.put(KeyStroke.getKeyStroke(88, commandKey), "cut-to-clipboard");
            im.put(KeyStroke.getKeyStroke(39, 512), "caret-next-word");
            im.put(KeyStroke.getKeyStroke(37, 512), "caret-previous-word");
        }
    }

    protected void installListeners() {
        super.installListeners();
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame()) {
            this.focusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    if (BaseTextAreaUI.this.getComponent() != null) {
                        BaseTextAreaUI.this.orgBorder = BaseTextAreaUI.this.getComponent().getBorder();
                        LookAndFeel laf = UIManager.getLookAndFeel();
                        if (laf instanceof AbstractLookAndFeel && BaseTextAreaUI.this.orgBorder instanceof UIResource) {
                            Border focusBorder = ((AbstractLookAndFeel)laf).getBorderFactory().getFocusFrameBorder();
                            BaseTextAreaUI.this.getComponent().setBorder(focusBorder);
                        }
                        BaseTextAreaUI.this.getComponent().invalidate();
                        BaseTextAreaUI.this.getComponent().repaint();
                    }
                }

                public void focusLost(FocusEvent e) {
                    if (BaseTextAreaUI.this.getComponent() != null) {
                        if (BaseTextAreaUI.this.orgBorder instanceof UIResource) {
                            BaseTextAreaUI.this.getComponent().setBorder(BaseTextAreaUI.this.orgBorder);
                        }
                        BaseTextAreaUI.this.getComponent().invalidate();
                        BaseTextAreaUI.this.getComponent().repaint();
                    }
                }
            };
            this.getComponent().addFocusListener(this.focusListener);
        }
    }

    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
        super.uninstallListeners();
    }

    protected void paintBackground(Graphics g) {
        g.setColor(this.getComponent().getBackground());
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && this.getComponent().hasFocus() && this.getComponent().isEditable()) {
            g.setColor(AbstractLookAndFeel.getTheme().getFocusBackgroundColor());
        }
        g.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
    }

    protected void paintSafely(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        Object savedRenderingHint = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        super.paintSafely(g);
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
        }
    }

    protected void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("editable") || evt.getPropertyName().equals("enabled")) {
            this.updateBackground();
        }
        super.propertyChange(evt);
    }

    private void updateBackground() {
        JTextComponent c = this.getComponent();
        if (c.getBackground() instanceof UIResource) {
            if (!c.isEnabled() || !c.isEditable()) {
                c.setBackground(AbstractLookAndFeel.getDisabledBackgroundColor());
            } else {
                c.setBackground(AbstractLookAndFeel.getInputBackgroundColor());
            }
        }
    }
}

