/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt5.services;

import com.uwetrottmann.trakt5.entities.BaseShow;
import com.uwetrottmann.trakt5.entities.Comment;
import com.uwetrottmann.trakt5.entities.Credits;
import com.uwetrottmann.trakt5.entities.Ratings;
import com.uwetrottmann.trakt5.entities.Show;
import com.uwetrottmann.trakt5.entities.Stats;
import com.uwetrottmann.trakt5.entities.Translation;
import com.uwetrottmann.trakt5.entities.TrendingShow;
import com.uwetrottmann.trakt5.enums.Extended;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface Shows {
    @GET(value="shows/popular")
    public Call<List<Show>> popular(@Query(value="page") Integer var1, @Query(value="limit") Integer var2, @Query(value="extended", encoded=true) Extended var3);

    @GET(value="shows/trending")
    public Call<List<TrendingShow>> trending(@Query(value="page") Integer var1, @Query(value="limit") Integer var2, @Query(value="extended", encoded=true) Extended var3);

    @GET(value="shows/{id}")
    public Call<Show> summary(@Path(value="id") String var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="shows/{id}/translations")
    public Call<List<Translation>> translations(@Path(value="id") String var1);

    @GET(value="shows/{id}/translations/{language}")
    public Call<List<Translation>> translation(@Path(value="id") String var1, @Path(value="language") String var2);

    @GET(value="shows/{id}/comments")
    public Call<List<Comment>> comments(@Path(value="id") String var1, @Query(value="page") Integer var2, @Query(value="limit") Integer var3, @Query(value="extended", encoded=true) Extended var4);

    @GET(value="shows/{id}/progress/collection")
    public Call<BaseShow> collectedProgress(@Path(value="id") String var1, @Query(value="hidden") Boolean var2, @Query(value="specials") Boolean var3, @Query(value="extended", encoded=true) Extended var4);

    @GET(value="shows/{id}/progress/watched")
    public Call<BaseShow> watchedProgress(@Path(value="id") String var1, @Query(value="hidden") Boolean var2, @Query(value="specials") Boolean var3, @Query(value="extended", encoded=true) Extended var4);

    @GET(value="shows/{id}/people")
    public Call<Credits> people(@Path(value="id") String var1);

    @GET(value="shows/{id}/ratings")
    public Call<Ratings> ratings(@Path(value="id") String var1);

    @GET(value="shows/{id}/stats")
    public Call<Stats> stats(@Path(value="id") String var1);
}

