/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.rottentomatoes;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.bind.DateTypeAdapter;
import com.jakewharton.retrofit.Ok3Client;
import java.lang.reflect.Type;
import java.util.Date;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.rottentomatoes.services.MovieAliasService;
import org.tinymediamanager.scraper.rottentomatoes.services.MovieInfoService;
import org.tinymediamanager.scraper.rottentomatoes.services.MovieSearchService;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

class RottenTomatoes {
    public static final String API_URL = "http://api.rottentomatoes.com/api/public/v1.0/";
    public static final String PARAM_API_KEY = "apikey";
    private RestAdapter restAdapter;
    private boolean isDebug;
    private String apiKey;

    public RottenTomatoes(String apiKey) {
        this.apiKey = apiKey;
    }

    public RottenTomatoes setIsDebug(boolean isDebug) {
        this.isDebug = isDebug;
        if (this.restAdapter != null) {
            this.restAdapter.setLogLevel(isDebug ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE);
        }
        return this;
    }

    protected RestAdapter.Builder newRestAdapterBuilder() {
        return new RestAdapter.Builder();
    }

    protected RestAdapter getRestAdapter() {
        if (this.restAdapter == null) {
            RestAdapter.Builder builder = this.newRestAdapterBuilder();
            builder.setEndpoint(API_URL);
            builder.setConverter((Converter)new GsonConverter(this.getGsonBuilder().create()));
            builder.setClient((Client)new Ok3Client(TmmHttpClient.getHttpClient()));
            builder.setRequestInterceptor(new RequestInterceptor(){

                public void intercept(RequestInterceptor.RequestFacade requestFacade) {
                    requestFacade.addQueryParam(RottenTomatoes.PARAM_API_KEY, RottenTomatoes.this.apiKey);
                }
            });
            if (this.isDebug) {
                builder.setLogLevel(RestAdapter.LogLevel.FULL);
            }
            this.restAdapter = builder.build();
        }
        return this.restAdapter;
    }

    protected GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (Object)new JsonDeserializer<Integer>(){

            public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return json.getAsInt();
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        return builder;
    }

    public MovieInfoService getMovieInfoService() {
        return (MovieInfoService)this.getRestAdapter().create(MovieInfoService.class);
    }

    public MovieAliasService getMovieAliasService() {
        return (MovieAliasService)this.getRestAdapter().create(MovieAliasService.class);
    }

    public MovieSearchService getMovieSearchService() {
        return (MovieSearchService)this.getRestAdapter().create(MovieSearchService.class);
    }
}

