/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;

class TvShowSourcePanel
extends JPanel {
    private static final long serialVersionUID = -7126616245313008341L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private JList<String> listDataSources;
    private JCheckBox cbDvdOrder;

    public TvShowSourcePanel() {
        this.initComponents();
        this.initDataBindings();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.LINE_GAP_ROWSPEC}));
        JPanel panelTvShowDataSources = new JPanel();
        this.add((Component)panelTvShowDataSources, "2, 2, fill, fill");
        panelTvShowDataSources.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"50dlu:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow(3)"), FormSpecs.RELATED_GAP_ROWSPEC}));
        JLabel lblDataSource = new JLabel(BUNDLE.getString("wizard.tvshow.datasources"));
        panelTvShowDataSources.add((Component)lblDataSource, "2, 2, 7, 1");
        JTextPane tpDatasourceHint = new JTextPane();
        tpDatasourceHint.setText(BUNDLE.getString("wizard.datasource.hint"));
        tpDatasourceHint.setOpaque(false);
        panelTvShowDataSources.add((Component)tpDatasourceHint, "2, 3, 7, 1, fill, fill");
        JScrollPane scrollPaneDataSources = new JScrollPane();
        panelTvShowDataSources.add((Component)scrollPaneDataSources, "2, 5, 5, 1, fill, fill");
        this.listDataSources = new JList();
        scrollPaneDataSources.setViewportView(this.listDataSources);
        JPanel panelTvShowSourcesButtons = new JPanel();
        panelTvShowDataSources.add((Component)panelTvShowSourcesButtons, "8, 5, fill, top");
        panelTvShowSourcesButtons.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JButton btnAdd = new JButton(IconManager.LIST_ADD);
        btnAdd.setToolTipText(BUNDLE.getString("Button.add"));
        btnAdd.setMargin(new Insets(2, 2, 2, 2));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String path = TmmProperties.getInstance().getProperty("tvshow.datasource.path");
                Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.tvshowdatasource.folderchooser"), path);
                if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                    TvShowSourcePanel.this.settings.addTvShowDataSources(file.toAbsolutePath().toString());
                    TmmProperties.getInstance().putProperty("tvshow.datasource.path", file.toAbsolutePath().toString());
                }
            }
        });
        panelTvShowSourcesButtons.add((Component)btnAdd, "1, 1, fill, top");
        JButton btnRemove = new JButton(IconManager.LIST_REMOVE);
        btnRemove.setToolTipText(BUNDLE.getString("Button.remove"));
        btnRemove.setMargin(new Insets(2, 2, 2, 2));
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = TvShowSourcePanel.this.listDataSources.getSelectedIndex();
                if (row != -1) {
                    String path = TvShowSourcePanel.this.settings.getTvShowDataSource().get(row);
                    Object[] choices = new String[]{BUNDLE.getString("Button.continue"), BUNDLE.getString("Button.abort")};
                    int decision = JOptionPane.showOptionDialog(null, String.format(BUNDLE.getString("Settings.tvshowdatasource.remove.info"), path), BUNDLE.getString("Settings.datasource.remove"), 0, -1, null, choices, BUNDLE.getString("Button.abort"));
                    if (decision == 0) {
                        TvShowSourcePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                        TvShowSourcePanel.this.settings.removeTvShowDataSources(path);
                        TvShowSourcePanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        });
        panelTvShowSourcesButtons.add((Component)btnRemove, "1, 3, fill, top");
        JLabel lblDvdOrder = new JLabel(BUNDLE.getString("Settings.dvdorder"));
        panelTvShowDataSources.add((Component)lblDvdOrder, "2, 7, right, default");
        this.cbDvdOrder = new JCheckBox("");
        panelTvShowDataSources.add((Component)this.cbDvdOrder, "4, 7");
    }

    protected void initDataBindings() {
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"dvdOrder");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.cbDvdOrder, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"tvShowDataSource");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, this.listDataSources);
        jListBinding.bind();
    }
}

