/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowReloadMediaInformationTask;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowMediaInformationAction
extends AbstractAction {
    private static final long serialVersionUID = -1274423130095036944L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowMediaInformationAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("tvshow.updatemediainfo"));
        }
        this.putValue("SwingLargeIconKey", new ImageIcon(this.getClass().getResource("/org/tinymediamanager/ui/images/mediainfo.png")));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/org/tinymediamanager/ui/images/mediainfo.png")));
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.updatemediainfo"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        ArrayList<TvShowEpisode> selectedEpisodes = new ArrayList<TvShowEpisode>();
        for (Object obj : TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects()) {
            TvShowEpisode episode;
            if (!(obj instanceof TvShowEpisode) || selectedTvShows.contains((episode = (TvShowEpisode)obj).getTvShow())) continue;
            selectedEpisodes.add(episode);
        }
        if (selectedTvShows.size() > 0 || selectedEpisodes.size() > 0) {
            TvShowReloadMediaInformationTask task = new TvShowReloadMediaInformationTask(selectedTvShows, selectedEpisodes);
            if (TmmTaskManager.getInstance().addMainTask(task)) {
                JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
            }
        }
    }
}

