/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.tasks.TvShowMissingArtworkDownloadTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowDownloadMissingArtworkAction
extends AbstractAction {
    private static final long serialVersionUID = 6102632119900792735L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowDownloadMissingArtworkAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.downloadmissingartwork"));
        this.putValue("SmallIcon", IconManager.IMAGE);
        this.putValue("SwingLargeIconKey", IconManager.IMAGE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        HashSet<TvShowEpisode> selectedEpisodes = new HashSet<TvShowEpisode>();
        for (Object obj : TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects()) {
            if (obj instanceof TvShow) {
                TvShow show = (TvShow)obj;
                for (TvShowEpisode episode : show.getEpisodes()) {
                    selectedEpisodes.add(episode);
                }
            }
            if (obj instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)obj;
                selectedEpisodes.add(episode);
            }
            if (!(obj instanceof TvShowSeason)) continue;
            TvShowSeason season = (TvShowSeason)obj;
            for (TvShowEpisode episode : season.getEpisodes()) {
                selectedEpisodes.add(episode);
            }
        }
        if (!selectedTvShows.isEmpty() || !selectedEpisodes.isEmpty()) {
            TvShowMissingArtworkDownloadTask task = new TvShowMissingArtworkDownloadTask(selectedTvShows, new ArrayList<TvShowEpisode>(selectedEpisodes));
            TmmTaskManager.getInstance().addDownloadTask(task);
        }
    }
}

