/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ButtonUI;
import org.apache.commons.lang3.StringUtils;
import org.japura.gui.CheckComboBox;
import org.japura.gui.event.ListCheckListener;
import org.japura.gui.event.ListEvent;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.ui.SmallCheckBoxUI;
import org.tinymediamanager.ui.SmallTextFieldBorder;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.SmallCheckComboBox;
import org.tinymediamanager.ui.components.SmallComboBox;
import org.tinymediamanager.ui.movies.MovieExtendedComparator;
import org.tinymediamanager.ui.panels.RoundedPanel;
import org.tinymediamanager.ui.tvshows.TvShowExtendedMatcher;
import org.tinymediamanager.ui.tvshows.TvShowTreeModel;

public class TvShowExtendedSearchPanel
extends RoundedPanel {
    private static final long serialVersionUID = 5003714573168481816L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final float FONT_SIZE = Math.round((double)Globals.settings.getFontSize() * 0.916);
    private static final SmallCheckBoxUI CHECKBOX_UI = AbstractLookAndFeel.getTheme() != null ? new SmallCheckBoxUI() : null;
    private TvShowTreeModel tvShowTreeModel;
    private JTree tree;
    private TvShowList tvShowList = TvShowList.getInstance();
    private JCheckBox cbFilterDatasource;
    private CheckComboBox cbDatasource;
    private JCheckBox cbFilterCast;
    private JTextField tfCastMember;
    private JCheckBox cbFilterMissingMetadata;
    private JCheckBox cbFilterMissingArtwork;
    private JCheckBox cbFilterMissingSubtitles;
    private JCheckBox cbFilterNewEpisodes;
    private JCheckBox cbFilterWatched;
    private JComboBox cbWatched;
    private JCheckBox cbFilterGenres;
    private JComboBox cbGenres;
    private JCheckBox cbFilterTag;
    private CheckComboBox cbTag;
    private JCheckBox cbFilterVideoCodec;
    private JComboBox cbVideoCodec;
    private JCheckBox cbFilterAudioCodec;
    private JComboBox cbAudioCodec;
    private JCheckBox cbFilterVideoFormat;
    private JComboBox cbVideoFormat;
    private final Action actionFilter = new FilterAction();
    private final ListCheckListener listCheckListener;
    private JCheckBox cbFilterMediaSource;
    private JLabel lblMediaSource;
    private JComboBox cbMediaSource;

    public TvShowExtendedSearchPanel(TvShowTreeModel model, JTree tree) {
        this.setOpaque(false);
        this.shadowAlpha = 100;
        this.arcs = new Dimension(10, 10);
        this.tvShowTreeModel = model;
        this.tree = tree;
        this.addMouseListener(new MouseAdapter(){});
        this.listCheckListener = new ListCheckListener(){

            public void removeCheck(ListEvent event) {
                TvShowExtendedSearchPanel.this.actionFilter.actionPerformed(new ActionEvent(event.getSource(), 1, "checked"));
            }

            public void addCheck(ListEvent event) {
                TvShowExtendedSearchPanel.this.actionFilter.actionPerformed(new ActionEvent(event.getSource(), 1, "checked"));
            }
        };
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.UNRELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC}));
        JLabel lblFilterBy = new JLabel(BUNDLE.getString("movieextendedsearch.filterby"));
        this.setComponentFont(lblFilterBy);
        this.add((Component)lblFilterBy, "2, 2, 3, 1");
        this.cbFilterNewEpisodes = new JCheckBox("");
        this.cbFilterNewEpisodes.setAction(this.actionFilter);
        this.add((Component)this.cbFilterNewEpisodes, "2, 4");
        JLabel lblNewEpisodes = new JLabel(BUNDLE.getString("movieextendedsearch.newepisodes"));
        this.setComponentFont(lblNewEpisodes);
        this.add((Component)lblNewEpisodes, "4, 4, right, default");
        this.cbFilterWatched = new JCheckBox("");
        this.cbFilterWatched.setAction(this.actionFilter);
        this.cbFilterWatched.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.add((Component)this.cbFilterWatched, "2, 5");
        JLabel lblWatched = new JLabel(BUNDLE.getString("metatag.watched"));
        this.setComponentFont(lblWatched);
        this.add((Component)lblWatched, "4, 5, right, default");
        this.cbWatched = new SmallComboBox((Object[])MovieExtendedComparator.WatchedFlag.values());
        this.setComponentFont(this.cbWatched);
        this.cbWatched.setAction(this.actionFilter);
        this.add((Component)this.cbWatched, "6, 5, fill, default");
        this.cbFilterGenres = new JCheckBox("");
        this.cbFilterGenres.setAction(this.actionFilter);
        this.cbFilterGenres.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.add((Component)this.cbFilterGenres, "2, 6");
        JLabel lblGenres = new JLabel(BUNDLE.getString("metatag.genre"));
        this.setComponentFont(lblGenres);
        this.add((Component)lblGenres, "4, 6, right, default");
        this.cbGenres = new SmallComboBox(MediaGenres.values());
        this.setComponentFont(this.cbGenres);
        this.cbGenres.setAction(this.actionFilter);
        this.add((Component)this.cbGenres, "6, 6, fill, default");
        this.cbFilterCast = new JCheckBox("");
        this.cbFilterCast.setAction(this.actionFilter);
        this.cbFilterCast.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.add((Component)this.cbFilterCast, "2, 7");
        JLabel lblCastMember = new JLabel(BUNDLE.getString("movieextendedsearch.cast"));
        this.setComponentFont(lblCastMember);
        this.add((Component)lblCastMember, "4, 7, right, default");
        this.tfCastMember = new JTextField();
        this.setComponentFont(this.tfCastMember);
        this.tfCastMember.setBorder(new SmallTextFieldBorder());
        this.add((Component)this.tfCastMember, "6, 7, fill, default");
        this.tfCastMember.setColumns(10);
        this.tfCastMember.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TvShowExtendedSearchPanel.this.actionFilter.actionPerformed(null);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TvShowExtendedSearchPanel.this.actionFilter.actionPerformed(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TvShowExtendedSearchPanel.this.actionFilter.actionPerformed(null);
            }
        });
        this.cbFilterTag = new JCheckBox("");
        this.cbFilterTag.setAction(this.actionFilter);
        this.cbFilterTag.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.add((Component)this.cbFilterTag, "2, 8");
        JLabel lblTag = new JLabel(BUNDLE.getString("movieextendedsearch.tag"));
        this.setComponentFont(lblTag);
        this.add((Component)lblTag, "4, 8, right, default");
        this.cbTag = new SmallCheckComboBox();
        this.cbTag.setTextFor(CheckComboBox.NONE, BUNDLE.getString("movieextendedsearch.tags.selected.none"));
        this.cbTag.setTextFor(CheckComboBox.MULTIPLE, BUNDLE.getString("movieextendedsearch.tags.selected.multiple"));
        this.cbTag.setTextFor(CheckComboBox.ALL, BUNDLE.getString("movieextendedsearch.tags.selected.all"));
        this.cbTag.getModel().addListCheckListener(this.listCheckListener);
        this.add((Component)this.cbTag, "6, 8, fill, default");
        this.cbFilterVideoFormat = new JCheckBox("");
        this.cbFilterVideoFormat.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.cbFilterVideoFormat.setAction(this.actionFilter);
        this.add((Component)this.cbFilterVideoFormat, "2, 9");
        JLabel lblVideoFormat = new JLabel(BUNDLE.getString("metatag.resolution"));
        this.setComponentFont(lblVideoFormat);
        this.add((Component)lblVideoFormat, "4, 9, right, default");
        this.cbVideoFormat = new SmallComboBox(this.getVideoFormats());
        this.setComponentFont(this.cbVideoFormat);
        this.cbVideoFormat.setAction(this.actionFilter);
        this.add((Component)this.cbVideoFormat, "6, 9, fill, default");
        this.cbFilterVideoCodec = new JCheckBox("");
        this.cbFilterVideoCodec.setAction(this.actionFilter);
        this.cbFilterVideoCodec.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.add((Component)this.cbFilterVideoCodec, "2, 10");
        JLabel lblVideoCodec = new JLabel(BUNDLE.getString("metatag.videocodec"));
        this.setComponentFont(lblVideoCodec);
        this.add((Component)lblVideoCodec, "4, 10, right, default");
        this.cbVideoCodec = new SmallComboBox();
        this.setComponentFont(this.cbVideoCodec);
        this.cbVideoCodec.setAction(this.actionFilter);
        this.add((Component)this.cbVideoCodec, "6, 10, fill, default");
        this.cbFilterAudioCodec = new JCheckBox("");
        this.cbFilterAudioCodec.setAction(this.actionFilter);
        this.cbFilterAudioCodec.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.add((Component)this.cbFilterAudioCodec, "2, 11");
        JLabel lblAudioCodec = new JLabel(BUNDLE.getString("metatag.audiocodec"));
        this.setComponentFont(lblAudioCodec);
        this.add((Component)lblAudioCodec, "4, 11, right, default");
        this.cbAudioCodec = new SmallComboBox();
        this.setComponentFont(this.cbAudioCodec);
        this.cbAudioCodec.setAction(this.actionFilter);
        this.add((Component)this.cbAudioCodec, "6, 11, fill, default");
        this.cbFilterDatasource = new JCheckBox("");
        this.cbFilterDatasource.setAction(this.actionFilter);
        this.cbFilterDatasource.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.add((Component)this.cbFilterDatasource, "2, 12");
        JLabel lblDatasource = new JLabel(BUNDLE.getString("metatag.datasource"));
        this.setComponentFont(lblDatasource);
        this.add((Component)lblDatasource, "4, 12, right, default");
        this.cbDatasource = new SmallCheckComboBox();
        this.cbDatasource.setTextFor(CheckComboBox.NONE, BUNDLE.getString("checkcombobox.selected.none"));
        this.cbDatasource.setTextFor(CheckComboBox.MULTIPLE, BUNDLE.getString("checkcombobox.selected.multiple"));
        this.cbDatasource.setTextFor(CheckComboBox.ALL, BUNDLE.getString("checkcombobox.selected.all"));
        this.cbDatasource.getModel().addListCheckListener(this.listCheckListener);
        this.add((Component)this.cbDatasource, "6, 12, fill, default");
        this.cbFilterMediaSource = new JCheckBox("");
        this.cbFilterMediaSource.setAction(this.actionFilter);
        this.cbFilterMediaSource.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.add((Component)this.cbFilterMediaSource, "2, 13");
        this.lblMediaSource = new JLabel(BUNDLE.getString("metatag.source"));
        this.setComponentFont(this.lblMediaSource);
        this.add((Component)this.lblMediaSource, "4, 13, right, default");
        this.cbMediaSource = new SmallComboBox((Object[])MediaSource.values());
        this.setComponentFont(this.cbMediaSource);
        this.cbMediaSource.setAction(this.actionFilter);
        this.add((Component)this.cbMediaSource, "6, 13, fill, default");
        this.cbFilterMissingMetadata = new JCheckBox("");
        this.cbFilterMissingMetadata.setAction(this.actionFilter);
        this.cbFilterMissingMetadata.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.add((Component)this.cbFilterMissingMetadata, "2, 14");
        JLabel lblMissingMetadata = new JLabel(BUNDLE.getString("movieextendedsearch.missingmetadata"));
        this.setComponentFont(lblMissingMetadata);
        this.add((Component)lblMissingMetadata, "4, 14, right, default");
        this.cbFilterMissingArtwork = new JCheckBox("");
        this.cbFilterMissingArtwork.setAction(this.actionFilter);
        this.cbFilterMissingArtwork.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.add((Component)this.cbFilterMissingArtwork, "2, 15");
        JLabel lblMissingArtwork = new JLabel(BUNDLE.getString("movieextendedsearch.missingartwork"));
        this.setComponentFont(lblMissingArtwork);
        this.add((Component)lblMissingArtwork, "4, 15, right, default");
        this.cbFilterMissingSubtitles = new JCheckBox("");
        this.cbFilterMissingSubtitles.setAction(this.actionFilter);
        this.cbFilterMissingSubtitles.setUI((ButtonUI)((Object)CHECKBOX_UI));
        this.add((Component)this.cbFilterMissingSubtitles, "2, 16");
        JLabel lblMissingSubtitles = new JLabel(BUNDLE.getString("movieextendedsearch.missingsubtitles"));
        this.setComponentFont(lblMissingSubtitles);
        this.add((Component)lblMissingSubtitles, "4, 16, right, default");
        this.cbFilterNewEpisodes.setUI((ButtonUI)((Object)CHECKBOX_UI));
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() instanceof TvShowSettings && "tvShowDataSource".equals(evt.getPropertyName())) {
                    TvShowExtendedSearchPanel.this.buildAndInstallDatasourceArray();
                }
                if (evt.getSource() instanceof TvShowList && "tag".equals(evt.getPropertyName())) {
                    TvShowExtendedSearchPanel.this.buildAndInstallTagsArray();
                }
                if (evt.getSource() instanceof TvShowList && ("audioCodec".equals(evt.getPropertyName()) || "videoCodec".equals(evt.getPropertyName()))) {
                    TvShowExtendedSearchPanel.this.buildAndInstallCodecArray();
                }
            }
        };
        this.tvShowList.addPropertyChangeListener(propertyChangeListener);
        TvShowModuleManager.SETTINGS.addPropertyChangeListener(propertyChangeListener);
        this.buildAndInstallDatasourceArray();
        this.buildAndInstallTagsArray();
        this.buildAndInstallCodecArray();
    }

    private void buildAndInstallDatasourceArray() {
        List oldValues = this.cbDatasource.getModel().getCheckeds();
        this.cbDatasource.getModel().removeListCheckListener(this.listCheckListener);
        this.cbDatasource.getModel().clear();
        ArrayList<String> datasources = new ArrayList<String>(TvShowModuleManager.SETTINGS.getTvShowDataSource());
        for (String datasource : datasources) {
            this.cbDatasource.getModel().addElement(new Object[]{datasource});
        }
        if (oldValues != null) {
            for (Object obj : oldValues) {
                this.cbDatasource.getModel().setCheck(new Object[]{obj});
            }
        }
        this.cbDatasource.getModel().addListCheckListener(this.listCheckListener);
    }

    private void buildAndInstallTagsArray() {
        List oldValues = this.cbTag.getModel().getCheckeds();
        this.cbTag.getModel().removeListCheckListener(this.listCheckListener);
        this.cbTag.getModel().clear();
        TreeSet<String> tags = new TreeSet<String>(this.tvShowList.getTagsInTvShows());
        tags.addAll(this.tvShowList.getTagsInEpisodes());
        for (String tag : tags) {
            this.cbTag.getModel().addElement(new Object[]{tag});
        }
        if (oldValues != null) {
            for (Object obj : oldValues) {
                this.cbTag.getModel().setCheck(new Object[]{obj});
            }
        }
        this.cbTag.getModel().addListCheckListener(this.listCheckListener);
    }

    private void buildAndInstallCodecArray() {
        this.cbVideoCodec.removeAllItems();
        ArrayList<String> codecs = new ArrayList<String>(this.tvShowList.getVideoCodecsInEpisodes());
        Collections.sort(codecs);
        for (String codec : codecs) {
            this.cbVideoCodec.addItem(codec);
        }
        this.cbAudioCodec.removeAllItems();
        codecs = new ArrayList<String>(this.tvShowList.getAudioCodecsInEpisodes());
        Collections.sort(codecs);
        for (String codec : codecs) {
            this.cbAudioCodec.addItem(codec);
        }
    }

    private void setComponentFont(JComponent comp) {
        comp.setFont(comp.getFont().deriveFont(FONT_SIZE));
    }

    private String[] getVideoFormats() {
        return new String[]{"480p", "540p", "576p", "720p", "1080p", "4k", "SD", "HD"};
    }

    private class FilterAction
    extends AbstractAction {
        private static final long serialVersionUID = 2680577442970097443L;

        private FilterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TvShowExtendedSearchPanel.this.cbFilterWatched.isSelected()) {
                if (TvShowExtendedSearchPanel.this.cbWatched.getSelectedItem() == MovieExtendedComparator.WatchedFlag.WATCHED) {
                    TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.WATCHED, true);
                } else {
                    TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.WATCHED, false);
                }
            } else {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.removeFilter(TvShowExtendedMatcher.SearchOptions.WATCHED);
            }
            if (TvShowExtendedSearchPanel.this.cbFilterGenres.isSelected()) {
                MediaGenres genre = (MediaGenres)TvShowExtendedSearchPanel.this.cbGenres.getSelectedItem();
                TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.GENRE, genre);
            } else {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.removeFilter(TvShowExtendedMatcher.SearchOptions.GENRE);
            }
            if (TvShowExtendedSearchPanel.this.cbFilterTag.isSelected()) {
                List tags = TvShowExtendedSearchPanel.this.cbTag.getModel().getCheckeds();
                TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.TAG, tags);
            } else {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.removeFilter(TvShowExtendedMatcher.SearchOptions.TAG);
            }
            if (TvShowExtendedSearchPanel.this.cbFilterDatasource.isSelected()) {
                List datasources = TvShowExtendedSearchPanel.this.cbDatasource.getModel().getCheckeds();
                TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.DATASOURCE, datasources);
            } else {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.removeFilter(TvShowExtendedMatcher.SearchOptions.DATASOURCE);
            }
            if (TvShowExtendedSearchPanel.this.cbFilterMediaSource.isSelected()) {
                MediaSource mediaSource = (MediaSource)((Object)TvShowExtendedSearchPanel.this.cbMediaSource.getSelectedItem());
                TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.MEDIA_SOURCE, (Object)mediaSource);
            } else {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.removeFilter(TvShowExtendedMatcher.SearchOptions.MEDIA_SOURCE);
            }
            if (TvShowExtendedSearchPanel.this.cbFilterCast.isSelected() && StringUtils.isNotBlank((CharSequence)TvShowExtendedSearchPanel.this.tfCastMember.getText())) {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.CAST, TvShowExtendedSearchPanel.this.tfCastMember.getText());
            } else {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.removeFilter(TvShowExtendedMatcher.SearchOptions.CAST);
            }
            if (TvShowExtendedSearchPanel.this.cbFilterMissingMetadata.isSelected()) {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.MISSING_METADATA, Boolean.TRUE);
            } else {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.removeFilter(TvShowExtendedMatcher.SearchOptions.MISSING_METADATA);
            }
            if (TvShowExtendedSearchPanel.this.cbFilterMissingArtwork.isSelected()) {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.MISSING_ARTWORK, Boolean.TRUE);
            } else {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.removeFilter(TvShowExtendedMatcher.SearchOptions.MISSING_ARTWORK);
            }
            if (TvShowExtendedSearchPanel.this.cbFilterMissingSubtitles.isSelected()) {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.MISSING_SUBTITLES, Boolean.TRUE);
            } else {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.removeFilter(TvShowExtendedMatcher.SearchOptions.MISSING_SUBTITLES);
            }
            if (TvShowExtendedSearchPanel.this.cbFilterNewEpisodes.isSelected()) {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.NEW_EPISODES, Boolean.TRUE);
            } else {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.removeFilter(TvShowExtendedMatcher.SearchOptions.NEW_EPISODES);
            }
            if (TvShowExtendedSearchPanel.this.cbFilterVideoCodec.isSelected()) {
                String videoCodec = (String)TvShowExtendedSearchPanel.this.cbVideoCodec.getSelectedItem();
                if (StringUtils.isNotBlank((CharSequence)videoCodec)) {
                    TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.VIDEO_CODEC, videoCodec);
                }
            } else {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.removeFilter(TvShowExtendedMatcher.SearchOptions.VIDEO_CODEC);
            }
            if (TvShowExtendedSearchPanel.this.cbFilterAudioCodec.isSelected()) {
                String audioCodec = (String)TvShowExtendedSearchPanel.this.cbAudioCodec.getSelectedItem();
                if (StringUtils.isNotBlank((CharSequence)audioCodec)) {
                    TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.AUDIO_CODEC, audioCodec);
                }
            } else {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.removeFilter(TvShowExtendedMatcher.SearchOptions.AUDIO_CODEC);
            }
            if (TvShowExtendedSearchPanel.this.cbFilterVideoFormat.isSelected()) {
                String videoFormat = (String)TvShowExtendedSearchPanel.this.cbVideoFormat.getSelectedItem();
                if (StringUtils.isNotBlank((CharSequence)videoFormat)) {
                    TvShowExtendedSearchPanel.this.tvShowTreeModel.setFilter(TvShowExtendedMatcher.SearchOptions.VIDEO_FORMAT, videoFormat);
                }
            } else {
                TvShowExtendedSearchPanel.this.tvShowTreeModel.removeFilter(TvShowExtendedMatcher.SearchOptions.VIDEO_FORMAT);
            }
            TvShowExtendedSearchPanel.this.tvShowTreeModel.filter(TvShowExtendedSearchPanel.this.tree);
        }
    }
}

