/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.scraper.trakttv.TraktTv;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.panels.ScrollablePanel;

public class ExternalServicesSettingsPanel
extends ScrollablePanel {
    private static final long serialVersionUID = 7266564870819511988L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private Settings settings = Settings.getInstance();

    public ExternalServicesSettingsPanel() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JPanel panelTrakttv = new JPanel();
        panelTrakttv.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.trakttv"), 4, 2, null, null));
        this.add((Component)panelTrakttv, "2, 2, fill, fill");
        panelTrakttv.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(25dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        final JLabel lblTraktStatus = new JLabel("");
        panelTrakttv.add((Component)lblTraktStatus, "2, 2, 5, 1");
        JButton btnGetTraktPin = new JButton(BUNDLE.getString("Settings.trakt.getpin"));
        panelTrakttv.add((Component)btnGetTraktPin, "2, 4");
        JButton btnTestTraktConnection = new JButton(BUNDLE.getString("Settings.trakt.testconnection"));
        panelTrakttv.add((Component)btnTestTraktConnection, "4, 4");
        if (!Globals.isDonator()) {
            btnGetTraktPin.setEnabled(false);
            btnTestTraktConnection.setEnabled(false);
            String msg = "<html><body>" + BUNDLE.getString("tmm.donatorfunction.hint") + "</body></html>";
            JLabel lblTraktDonator = new JLabel(msg);
            lblTraktDonator.setForeground(Color.RED);
            panelTrakttv.add((Component)lblTraktDonator, "2, 8, 3, 1, default, default");
        } else {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Globals.settings.getTraktAccessToken(), Globals.settings.getTraktRefreshToken()})) {
                lblTraktStatus.setText(BUNDLE.getString("Settings.trakt.status.good"));
            } else {
                lblTraktStatus.setText(BUNDLE.getString("Settings.trakt.status.bad"));
            }
            btnGetTraktPin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        TmmUIHelper.browseUrl("https://trakt.tv/pin/799");
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(MainWindow.getFrame(), BUNDLE.getString("Settings.trakt.getpin.fallback"), BUNDLE.getString("Settings.trakt.getpin"), 1);
                    }
                    String pin = JOptionPane.showInputDialog(MainWindow.getFrame(), (Object)BUNDLE.getString("Settings.trakt.getpin.entercode"));
                    String accessToken = "";
                    String refreshToken = "";
                    try {
                        Map<String, String> tokens = TraktTv.authenticateViaPin(pin);
                        accessToken = tokens.get("accessToken") == null ? "" : tokens.get("accessToken");
                        refreshToken = tokens.get("refreshToken") == null ? "" : tokens.get("refreshToken");
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    Globals.settings.setTraktAccessToken(accessToken);
                    Globals.settings.setTraktRefreshToken(refreshToken);
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Globals.settings.getTraktAccessToken(), Globals.settings.getTraktRefreshToken()})) {
                        lblTraktStatus.setText(BUNDLE.getString("Settings.trakt.status.good"));
                    } else {
                        JOptionPane.showMessageDialog(MainWindow.getFrame(), BUNDLE.getString("Settings.trakt.getpin.problem"), BUNDLE.getString("Settings.trakt.getpin"), 0);
                        lblTraktStatus.setText(BUNDLE.getString("Settings.trakt.status.bad"));
                    }
                }
            });
            btnTestTraktConnection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        TraktTv.refreshAccessToken();
                        JOptionPane.showMessageDialog(MainWindow.getFrame(), BUNDLE.getString("Settings.trakt.testconnection.good"), BUNDLE.getString("Settings.trakt.testconnection"), 1);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(MainWindow.getFrame(), BUNDLE.getString("Settings.trakt.testconnection.bad"), BUNDLE.getString("Settings.trakt.testconnection"), 0);
                    }
                }
            });
        }
        this.initDataBindings();
    }

    protected void initDataBindings() {
    }
}

