/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.mediaprovider.IMediaProvider;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieScraperMetadataPanel;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

public class MovieScraperSettingsPanel
extends ScrollablePanel {
    private static final long serialVersionUID = -299825914193235308L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSettings settings = MovieModuleManager.MOVIE_SETTINGS;
    private List<MovieScraper> scrapers = ObservableCollections.observableList(new ArrayList());
    private JComboBox cbScraperLanguage;
    private JComboBox cbCertificationCountry;
    private JCheckBox chckbxAutomaticallyScrapeImages;
    private JPanel panelScraperMetadata;
    private JPanel panelScraperMetadataContainer;
    private JTextPane lblScraperThresholdHint;
    private JPanel panelAutomaticScraper;
    private JSlider sliderThreshold;
    private JCheckBox chckbxScraperFallback;
    private JCheckBox chckbxImageLanguage;
    private JPanel panelScraperDetails;
    private JPanel panelScraperOptions;
    private JTextPane tpScraperDescription;
    private JScrollPane scrollPaneScraper;
    private JTable tableScraper;
    private JScrollPane scrollPane;

    public MovieScraperSettingsPanel() {
        MediaScraper defaultMediaScraper = MovieList.getInstance().getDefaultMediaScraper();
        int selectedIndex = 0;
        int counter = 0;
        for (MediaScraper scraper : MovieList.getInstance().getAvailableMediaScrapers()) {
            MovieScraper movieScraper = new MovieScraper(scraper);
            if (scraper.equals(defaultMediaScraper)) {
                movieScraper.defaultScraper = true;
                selectedIndex = counter;
            }
            this.scrapers.add(movieScraper);
            ++counter;
        }
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JPanel panelMovieScrapers = new JPanel();
        panelMovieScrapers.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), BUNDLE.getString("scraper.metadata"), 4, 2, null, null));
        this.add((Component)panelMovieScrapers, "2, 2, 3, 1, fill, fill");
        panelMovieScrapers.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"150dlu:grow"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.scrollPaneScraper = new JScrollPane();
        panelMovieScrapers.add((Component)this.scrollPaneScraper, "2, 2, 3, 1, fill, fill");
        this.tableScraper = new JTable(){
            private static final long serialVersionUID = -144223066269069772L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                String value = this.getModel().getValueAt(row, 2).toString();
                if (!Globals.isDonator() && value.startsWith("Kodi")) {
                    comp.setBackground(Color.lightGray);
                    comp.setEnabled(false);
                } else {
                    comp.setBackground(Color.white);
                    comp.setEnabled(true);
                }
                return comp;
            }
        };
        this.tableScraper.setRowHeight(29);
        this.scrollPaneScraper.setViewportView(this.tableScraper);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBorder(null);
        panelMovieScrapers.add((Component)this.scrollPane, "6, 1, 1, 7, fill, fill");
        this.panelScraperDetails = new ScrollablePanel();
        this.scrollPane.setViewportView(this.panelScraperDetails);
        this.panelScraperDetails.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        this.tpScraperDescription = new JTextPane();
        this.tpScraperDescription.setOpaque(false);
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        this.panelScraperDetails.add((Component)this.tpScraperDescription, "1, 1, default, top");
        this.panelScraperOptions = new JPanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        this.panelScraperDetails.add((Component)this.panelScraperOptions, "1, 3, fill, top");
        JSeparator separator = new JSeparator();
        panelMovieScrapers.add((Component)separator, "2, 4, 3, 1");
        JLabel lblScraperLanguage = new JLabel(BUNDLE.getString("Settings.preferredLanguage"));
        panelMovieScrapers.add((Component)lblScraperLanguage, "2, 5, right, default");
        this.cbScraperLanguage = new JComboBox<MediaLanguages>(MediaLanguages.values());
        panelMovieScrapers.add((Component)this.cbScraperLanguage, "4, 5");
        JLabel lblCountry = new JLabel(BUNDLE.getString("Settings.certificationCountry"));
        panelMovieScrapers.add((Component)lblCountry, "2, 7, right, default");
        this.cbCertificationCountry = new JComboBox<CountryCode>(CountryCode.values());
        panelMovieScrapers.add((Component)this.cbCertificationCountry, "4, 7, fill, default");
        panelMovieScrapers.add((Component)new JSeparator(), "2, 8, 5, 1");
        this.chckbxScraperFallback = new JCheckBox(BUNDLE.getString("Settings.scraperfallback"));
        panelMovieScrapers.add((Component)this.chckbxScraperFallback, "2, 9, 5, 1");
        this.panelScraperMetadataContainer = new JPanel();
        this.panelScraperMetadataContainer.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), BUNDLE.getString("scraper.metadata.defaults"), 4, 2, null, new Color(51, 51, 51)));
        this.add((Component)this.panelScraperMetadataContainer, "2, 4, fill, fill");
        this.panelScraperMetadataContainer.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"10dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        this.panelScraperMetadata = new MovieScraperMetadataPanel(Settings.getInstance().getMovieScraperMetadataConfig());
        this.panelScraperMetadataContainer.add((Component)this.panelScraperMetadata, "1, 1, 4, 1, fill, default");
        this.chckbxAutomaticallyScrapeImages = new JCheckBox(BUNDLE.getString("Settings.default.autoscrape"));
        this.panelScraperMetadataContainer.add((Component)this.chckbxAutomaticallyScrapeImages, "2, 3, 3, 1");
        this.chckbxImageLanguage = new JCheckBox(BUNDLE.getString("Settings.default.autoscrape.language"));
        this.panelScraperMetadataContainer.add((Component)this.chckbxImageLanguage, "4, 5");
        this.panelAutomaticScraper = new JPanel();
        this.panelAutomaticScraper.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.automaticscraper"), 4, 2, null, null));
        this.add((Component)this.panelAutomaticScraper, "4, 4, fill, fill");
        this.panelAutomaticScraper.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblScraperTreshold = new JLabel(BUNDLE.getString("Settings.scraperTreshold"));
        this.panelAutomaticScraper.add((Component)lblScraperTreshold, "1, 2, default, top");
        this.sliderThreshold = new JSlider();
        this.sliderThreshold.setMinorTickSpacing(5);
        this.sliderThreshold.setMajorTickSpacing(10);
        this.sliderThreshold.setPaintTicks(true);
        this.sliderThreshold.setPaintLabels(true);
        this.sliderThreshold.setValue((int)(this.settings.getScraperThreshold() * 100.0));
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(100, new JLabel("1.0"));
        labelTable.put(75, new JLabel("0.75"));
        labelTable.put(50, new JLabel("0.50"));
        labelTable.put(25, new JLabel("0.25"));
        labelTable.put(0, new JLabel("0.0"));
        this.sliderThreshold.setLabelTable(labelTable);
        this.sliderThreshold.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                MovieScraperSettingsPanel.this.settings.setScraperThreshold((double)MovieScraperSettingsPanel.this.sliderThreshold.getValue() / 100.0);
            }
        });
        this.panelAutomaticScraper.add((Component)this.sliderThreshold, "3, 2");
        this.lblScraperThresholdHint = new JTextPane();
        this.panelAutomaticScraper.add((Component)this.lblScraperThresholdHint, "1, 6, 3, 1");
        this.lblScraperThresholdHint.setOpaque(false);
        TmmFontHelper.changeFont((JComponent)this.lblScraperThresholdHint, 0.833);
        this.lblScraperThresholdHint.setText(BUNDLE.getString("Settings.scraperTreshold.hint"));
        this.initDataBindings();
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 2);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        this.tableScraper.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (arg0.getColumn() == 0) {
                    int row = arg0.getFirstRow();
                    MovieScraper changedScraper = (MovieScraper)MovieScraperSettingsPanel.this.scrapers.get(row);
                    if (changedScraper.getDefaultScraper().booleanValue()) {
                        MovieScraperSettingsPanel.this.settings.setMovieScraper(changedScraper.getScraperId());
                        for (MovieScraper scraper : MovieScraperSettingsPanel.this.scrapers) {
                            if (scraper == changedScraper) continue;
                            scraper.setDefaultScraper(Boolean.FALSE);
                        }
                    }
                }
            }
        });
        this.tableScraper.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = MovieScraperSettingsPanel.this.tableScraper.convertRowIndexToModel(MovieScraperSettingsPanel.this.tableScraper.getSelectedRow());
                if (index > -1) {
                    MovieScraperSettingsPanel.this.panelScraperOptions.removeAll();
                    if (((MovieScraper)MovieScraperSettingsPanel.this.scrapers.get(index)).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                        MovieScraperSettingsPanel.this.panelScraperOptions.add(new MediaScraperConfigurationPanel(((MovieScraper)MovieScraperSettingsPanel.this.scrapers.get(index)).getMediaProvider()));
                    }
                    MovieScraperSettingsPanel.this.panelScraperOptions.revalidate();
                }
            }
        });
        if (counter > 0) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"scraperLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, (Object)this.cbScraperLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"certificationCountry");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, (Object)this.cbCertificationCountry, (Property)jComboBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"scrapeBestImage");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxAutomaticallyScrapeImages, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"scraperFallback");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxScraperFallback, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxAutomaticallyScrapeImages, (Property)jCheckBoxBeanProperty, (Object)this.chckbxImageLanguage, (Property)jCheckBoxBeanProperty_1);
        autoBinding_10.bind();
        BeanProperty settingsBeanProperty_10 = BeanProperty.create((String)"imageLanguagePriority");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_10, (Object)this.chckbxImageLanguage, (Property)jCheckBoxBeanProperty);
        autoBinding_11.bind();
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableScraper);
        BeanProperty movieScraperBeanProperty = BeanProperty.create((String)"defaultScraper");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty).setColumnName("Default").setColumnClass(Boolean.class);
        BeanProperty movieScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty_1).setColumnName("Logo").setColumnClass(Icon.class);
        BeanProperty movieScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty_2).setColumnName("Name").setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding_12.bind();
    }

    public static class MovieScraper
    extends AbstractModelObject {
        private MediaScraper scraper;
        private Icon scraperLogo;
        private boolean defaultScraper;

        public MovieScraper(MediaScraper scraper) {
            this.scraper = scraper;
            this.scraperLogo = scraper.getMediaProvider() == null || scraper.getMediaProvider().getProviderInfo() == null || scraper.getMediaProvider().getProviderInfo().getProviderLogo() == null ? new ImageIcon() : this.getScaledIcon(new ImageIcon(scraper.getMediaProvider().getProviderInfo().getProviderLogo()));
        }

        public String getScraperId() {
            return this.scraper.getId();
        }

        public String getScraperName() {
            return this.scraper.getName() + " - " + this.scraper.getVersion();
        }

        public String getScraperDescription() {
            String description = null;
            try {
                description = BUNDLE.getString("scraper." + this.scraper.getId() + ".hint");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isBlank(description)) {
                description = this.scraper.getDescription();
            }
            return description;
        }

        private ImageIcon getScaledIcon(ImageIcon original) {
            Canvas c = new Canvas();
            FontMetrics fm = c.getFontMetrics(new JPanel().getFont());
            int height = (int)((float)fm.getHeight() * 2.0f);
            int width = original.getIconWidth() / original.getIconHeight() * height;
            BufferedImage scaledImage = !this.scraper.isEnabled() ? Scalr.resize((BufferedImage)ImageCache.createImage(original.getImage()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_GRAYSCALE}) : Scalr.resize((BufferedImage)ImageCache.createImage(original.getImage()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            return new ImageIcon(scaledImage);
        }

        public Icon getScraperLogo() {
            return this.scraperLogo;
        }

        public Boolean getDefaultScraper() {
            return this.defaultScraper;
        }

        public void setDefaultScraper(Boolean newValue) {
            if (this.scraper.isEnabled()) {
                Boolean oldValue = this.defaultScraper;
                this.defaultScraper = newValue;
                this.firePropertyChange("defaultScraper", oldValue, newValue);
            }
        }

        public IMediaProvider getMediaProvider() {
            return this.scraper.getMediaProvider();
        }
    }
}

