/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieRenameAction
extends AbstractAction {
    private static final long serialVersionUID = 4804592958868052533L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieRenameAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("movie.rename"));
        }
        this.putValue("ShortDescription", BUNDLE.getString("movie.rename"));
        this.putValue("SwingLargeIconKey", new ImageIcon(this.getClass().getResource("/org/tinymediamanager/ui/images/rename-icon.png")));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/org/tinymediamanager/ui/images/rename-icon.png")));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        MovieRenameTask renameTask = new MovieRenameTask(selectedMovies);
        if (TmmTaskManager.getInstance().addMainTask(renameTask)) {
            JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
        }
    }
}

