/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieBatchEditorDialog;

public class MovieBatchEditAction
extends AbstractAction {
    private static final long serialVersionUID = -3974602352019088416L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieBatchEditAction() {
        this.putValue("Name", BUNDLE.getString("movie.bulkedit"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.bulkedit.desc"));
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.size() > 0) {
            MovieBatchEditorDialog editor = new MovieBatchEditorDialog(selectedMovies);
            editor.setLocationRelativeTo(MainWindow.getActiveInstance());
            editor.pack();
            editor.setVisible(true);
        }
    }
}

