/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.movie.MovieSearchOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieActor;
import org.tinymediamanager.core.movie.entities.MovieProducer;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaGenres;

public class MovieExtendedMatcher
implements ca.odell.glazedlists.matchers.Matcher<Movie> {
    private Map<MovieSearchOptions, Object> searchOptions;

    public MovieExtendedMatcher(Map<MovieSearchOptions, Object> searchOptions) {
        this.searchOptions = searchOptions;
    }

    public boolean matches(Movie movie) {
        List datasources;
        String audioCodec;
        String videoCodec;
        List tags;
        String castSearch;
        Certification cert;
        if (movie == null) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.DUPLICATES) && !movie.isDuplicate()) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.WATCHED)) {
            boolean result;
            boolean watched = (Boolean)this.searchOptions.get((Object)MovieSearchOptions.WATCHED);
            boolean bl = result = !(movie.isWatched() ^ watched);
            if (!result) {
                return false;
            }
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.GENRE)) {
            MediaGenres genre = (MediaGenres)this.searchOptions.get((Object)MovieSearchOptions.GENRE);
            if (!movie.getGenres().contains(genre)) {
                return false;
            }
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.CERTIFICATION) && (cert = (Certification)this.searchOptions.get((Object)MovieSearchOptions.CERTIFICATION)) != movie.getCertification()) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.CAST) && !this.containsCast(movie, castSearch = (String)this.searchOptions.get((Object)MovieSearchOptions.CAST))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.TAG) && this.searchOptions.get((Object)MovieSearchOptions.TAG) instanceof List && !this.containsTag(movie, tags = (List)this.searchOptions.get((Object)MovieSearchOptions.TAG))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.MOVIESET)) {
            Boolean isInSet = (Boolean)this.searchOptions.get((Object)MovieSearchOptions.MOVIESET);
            if (movie.getMovieSet() != null != isInSet) {
                return false;
            }
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.VIDEO_FORMAT)) {
            String videoFormat = (String)this.searchOptions.get((Object)MovieSearchOptions.VIDEO_FORMAT);
            if (videoFormat == "HD" || videoFormat == "SD") {
                if (videoFormat == "HD" && !this.isVideoHD(movie.getMediaInfoVideoFormat())) {
                    return false;
                }
                if (videoFormat == "SD" && this.isVideoHD(movie.getMediaInfoVideoFormat())) {
                    return false;
                }
            } else if (videoFormat != movie.getMediaInfoVideoFormat()) {
                return false;
            }
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.VIDEO_CODEC) && !(videoCodec = (String)this.searchOptions.get((Object)MovieSearchOptions.VIDEO_CODEC)).equals(movie.getMediaInfoVideoCodec())) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.AUDIO_CODEC) && !this.containsAudioCodec(movie, audioCodec = (String)this.searchOptions.get((Object)MovieSearchOptions.AUDIO_CODEC))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.DATASOURCE) && this.searchOptions.get((Object)MovieSearchOptions.DATASOURCE) instanceof List && !(datasources = (List)this.searchOptions.get((Object)MovieSearchOptions.DATASOURCE)).isEmpty() && !datasources.contains(movie.getDataSource())) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.MISSING_METADATA) && movie.isScraped()) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.MISSING_ARTWORK) && movie.getHasImages().booleanValue()) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.MISSING_SUBTITLES) && movie.hasSubtitles()) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.NEW_MOVIES) && !movie.isNewlyAdded()) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.MEDIA_SOURCE)) {
            MediaSource mediaSource = (MediaSource)((Object)this.searchOptions.get((Object)MovieSearchOptions.MEDIA_SOURCE));
            if (movie.getMediaSource() != mediaSource) {
                return false;
            }
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.YEAR)) {
            Integer year = (Integer)this.searchOptions.get((Object)MovieSearchOptions.YEAR);
            if (!movie.getYear().equals(year.toString())) {
                return false;
            }
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.VIDEO_3D) && !movie.isVideoIn3D()) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)MovieSearchOptions.OFFLINE)) {
            Boolean offline = (Boolean)this.searchOptions.get((Object)MovieSearchOptions.OFFLINE);
            if (movie.isOffline() != offline.booleanValue()) {
                return false;
            }
        }
        return true;
    }

    private boolean isVideoHD(String videoFormat) {
        if ("720p".equals(videoFormat)) {
            return true;
        }
        if ("1080p".equals(videoFormat)) {
            return true;
        }
        if ("4k".equals(videoFormat)) {
            return true;
        }
        return "8k".equals(videoFormat);
    }

    private boolean containsAudioCodec(Movie movie, String codec) {
        List<MediaFile> videoFiles = movie.getMediaFiles(MediaFileType.VIDEO);
        if (videoFiles.size() == 0) {
            return false;
        }
        MediaFile mf = videoFiles.get(0);
        for (MediaFileAudioStream stream : mf.getAudioStreams()) {
            if (!codec.equals(stream.getCodec())) continue;
            return true;
        }
        return false;
    }

    private boolean containsTag(Movie movie, List<?> tags) {
        ArrayList<String> cleanedTags = new ArrayList<String>();
        for (Object obj : tags) {
            if (!(obj instanceof String) || !StringUtils.isNotBlank((CharSequence)((String)obj))) continue;
            cleanedTags.add((String)obj);
        }
        if (cleanedTags.isEmpty()) {
            return movie.getTags().isEmpty();
        }
        return movie.getTags().containsAll(cleanedTags);
    }

    private boolean containsCast(Movie movie, String name) {
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            Pattern pattern = Pattern.compile("(?i)" + Pattern.quote(name));
            Matcher matcher = null;
            if (StringUtils.isNotEmpty((CharSequence)movie.getDirector()) && (matcher = pattern.matcher(movie.getDirector())).find()) {
                return true;
            }
            if (StringUtils.isNotEmpty((CharSequence)movie.getWriter()) && (matcher = pattern.matcher(movie.getWriter())).find()) {
                return true;
            }
            for (MovieActor cast : movie.getActors()) {
                if (!StringUtils.isNotEmpty((CharSequence)cast.getName()) || !(matcher = pattern.matcher(cast.getName())).find()) continue;
                return true;
            }
            for (MovieProducer producer : movie.getProducers()) {
                if (!StringUtils.isNotEmpty((CharSequence)producer.getName()) || !(matcher = pattern.matcher(producer.getName())).find()) continue;
                return true;
            }
        }
        return false;
    }
}

