/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieActor;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ActorImageLabel;
import org.tinymediamanager.ui.components.ZebraJTable;
import org.tinymediamanager.ui.movies.MovieSelectionModel;

public class MovieActorPanel
extends JPanel {
    private static final long serialVersionUID = 2972207353452870494L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSelectionModel selectionModel;
    private EventList<MovieActor> actorEventList = null;
    private DefaultEventTableModel<MovieActor> actorTableModel = null;
    private ActorImageLabel lblActorThumb;
    private JTable tableCast;

    public MovieActorPanel(MovieSelectionModel model) {
        this.selectionModel = model;
        this.actorEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(MovieActor.class)));
        this.actorTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.actorEventList), (TableFormat)new ActorTableFormat());
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100px:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"125px"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"fill:80px:grow"), FormFactory.NARROW_LINE_GAP_ROWSPEC}));
        this.tableCast = new ZebraJTable((TableModel)this.actorTableModel);
        JScrollPane scrollPaneMovieCast = ZebraJTable.createStripedJScrollPane(this.tableCast);
        this.add((Component)scrollPaneMovieCast, "2, 2, 1, 1");
        scrollPaneMovieCast.setViewportView(this.tableCast);
        this.lblActorThumb = new ActorImageLabel();
        this.add((Component)this.lblActorThumb, "4, 2, fill, fill");
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source.getClass() == MovieSelectionModel.class && "selectedMovie".equals(property) || source.getClass() == Movie.class && "actors".equals(property)) {
                    MovieActorPanel.this.actorEventList.clear();
                    MovieActorPanel.this.actorEventList.addAll(MovieActorPanel.this.selectionModel.getSelectedMovie().getActors());
                    if (MovieActorPanel.this.actorEventList.size() > 0) {
                        MovieActorPanel.this.tableCast.getSelectionModel().setSelectionInterval(0, 0);
                    }
                }
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
        this.tableCast.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (!arg0.getValueIsAdjusting()) {
                    int selectedRow = MovieActorPanel.this.tableCast.convertRowIndexToModel(MovieActorPanel.this.tableCast.getSelectedRow());
                    if (selectedRow >= 0 && selectedRow < MovieActorPanel.this.actorEventList.size()) {
                        MovieActor actor = (MovieActor)MovieActorPanel.this.actorEventList.get(selectedRow);
                        MovieActorPanel.this.lblActorThumb.setActor(actor);
                    } else {
                        MovieActorPanel.this.lblActorThumb.setImageUrl("");
                    }
                }
            }
        });
    }

    protected void initDataBindings() {
    }

    private static class ActorTableFormat
    implements AdvancedTableFormat<MovieActor> {
        private ActorTableFormat() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return BUNDLE.getString("metatag.name");
                }
                case 1: {
                    return BUNDLE.getString("metatag.role");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(MovieActor actor, int column) {
            switch (column) {
                case 0: {
                    return actor.getName();
                }
                case 1: {
                    return actor.getCharacter();
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: 
                case 1: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int column) {
            return null;
        }
    }
}

