/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.WolDevice;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class WolDeviceDialog
extends TmmDialog {
    private static final long serialVersionUID = -8293021735704401080L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private WolDevice device = null;
    private JTextField tfName;
    private JTextField tfMacAddress;
    private final Action actionSave = new SaveAction();
    private final Action actionCancel = new CancelAction();

    public WolDeviceDialog() {
        super(BUNDLE.getString("tmm.wakeonlandevice"), "wolDialog");
        this.setResizable(false);
        this.getContentPane().setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(100px;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(100px;default)"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblDeviceName = new JLabel(BUNDLE.getString("Settings.devicename"));
        this.getContentPane().add((Component)lblDeviceName, "2, 2, right, default");
        this.tfName = new JTextField();
        this.getContentPane().add((Component)this.tfName, "4, 2, 5, 1, fill, default");
        this.tfName.setColumns(10);
        JLabel lblMacAddress = new JLabel(BUNDLE.getString("Settings.macaddress"));
        this.getContentPane().add((Component)lblMacAddress, "2, 4, right, default");
        this.tfMacAddress = new JTextField();
        this.getContentPane().add((Component)this.tfMacAddress, "4, 4, 5, 1, fill, default");
        this.tfMacAddress.setColumns(10);
        JButton btnSave = new JButton(BUNDLE.getString("Button.save"));
        btnSave.setAction(this.actionSave);
        this.getContentPane().add((Component)btnSave, "6, 6");
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setAction(this.actionCancel);
        this.getContentPane().add((Component)btnCancel, "8, 6");
    }

    public void setDevice(WolDevice device) {
        this.device = device;
        this.tfName.setText(device.getName());
        this.tfMacAddress.setText(device.getMacAddress());
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -8416641526799936831L;

        public CancelAction() {
            this.putValue("Name", BUNDLE.getString("Button.cancel"));
            this.putValue("SmallIcon", IconManager.CANCEL);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WolDeviceDialog.this.setVisible(false);
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1740130137146252281L;

        public SaveAction() {
            this.putValue("Name", BUNDLE.getString("Button.save"));
            this.putValue("SmallIcon", IconManager.APPLY);
            this.putValue("SwingLargeIconKey", IconManager.APPLY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StringUtils.isBlank((CharSequence)WolDeviceDialog.this.tfName.getText()) || StringUtils.isBlank((CharSequence)WolDeviceDialog.this.tfMacAddress.getText())) {
                JOptionPane.showMessageDialog(null, BUNDLE.getString("message.missingitems"));
                return;
            }
            Pattern pattern = Pattern.compile("^([0-9a-fA-F]{2}[:-]){5}([0-9a-fA-F]{2})$");
            Matcher matcher = pattern.matcher(WolDeviceDialog.this.tfMacAddress.getText());
            if (!matcher.matches()) {
                JOptionPane.showMessageDialog(null, BUNDLE.getString("message.invalidmac"));
                return;
            }
            if (WolDeviceDialog.this.device == null) {
                WolDeviceDialog.this.device = new WolDevice();
                Globals.settings.addWolDevice(WolDeviceDialog.this.device);
            }
            WolDeviceDialog.this.device.setName(WolDeviceDialog.this.tfName.getText());
            WolDeviceDialog.this.device.setMacAddress(WolDeviceDialog.this.tfMacAddress.getText());
            WolDeviceDialog.this.setVisible(false);
        }
    }
}

