/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.License;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.images.Logo;

public class AboutDialog
extends TmmDialog {
    private static final long serialVersionUID = 2298570526828925319L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(AboutDialog.class);
    private static final String TRANSLATORS = "Joostzilla, Zagoslav, zbynek.fiala, roliverosc, roandr, Andrey Gorodnov, julienbloch, nerve, carlosmarchi, espiman, beonex, otefenli, sxczmnb, piodio, peppe_sr, szobidani, kriss1981, mrj, xsintive, Gam, ppanhh, SeNmaN, Translador, Deleuze23, ShevAbam, abrupt_neurosis, lynxstrike, Spegni, carfesh, vekheoqf, keleniki, htrex, namuit, stickell, Voltinus, Zwanzig, vipkozaAmarante.pt_BR, TaniaC, maopequena, leandrofuscaldi, dukobpa3, bleuge";
    private final JPanel contentPanel = new JPanel();
    private final Action action = new SwingAction();

    public AboutDialog() {
        super(BUNDLE.getString("tmm.about"), "aboutDialog");
        this.setBounds(100, 100, 655, 500);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"300dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(25px;min)"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JLabel lblLogo = new JLabel("");
        lblLogo.setIcon(new Logo(96));
        this.contentPanel.add((Component)lblLogo, "2, 2, 1, 9, default, top");
        JLabel lblTinymediamanager = new JLabel("tinyMediaManager");
        TmmFontHelper.changeFont(lblTinymediamanager, 1.5, 1);
        this.contentPanel.add((Component)lblTinymediamanager, "4, 2, 3, 1, center, default");
        JLabel lblByManuel = new JLabel("\u00a9 2012 - 2016 by Manuel Laggner");
        this.contentPanel.add((Component)lblByManuel, "4, 4, 3, 1, center, default");
        if (Globals.isDonator()) {
            Properties p = License.decrypt();
            JLabel lblRegged = new JLabel(BUNDLE.getString("tmm.registeredto") + " " + p.getProperty("user"));
            TmmFontHelper.changeFont(lblRegged, 1.166, 1);
            this.contentPanel.add((Component)lblRegged, "4, 6, 3, 1, center, default");
        }
        JLabel lblVersion = new JLabel(BUNDLE.getString("tmm.version") + ": " + ReleaseInfo.getRealVersion());
        this.contentPanel.add((Component)lblVersion, "6, 8, left, top");
        JLabel lblBuild = new JLabel(BUNDLE.getString("tmm.builddate") + ": " + ReleaseInfo.getRealBuildDate());
        this.contentPanel.add((Component)lblBuild, "6, 10, left, top");
        JLabel lblHomepage = new JLabel(BUNDLE.getString("tmm.homepage"));
        this.contentPanel.add((Component)lblHomepage, "2, 12, right, default");
        lblHomepage = new LinkLabel("http://www.tinymediamanager.org/");
        ((LinkLabel)lblHomepage).addActionListener(new ActionListener((LinkLabel)lblHomepage){
            final /* synthetic */ LinkLabel val$lblHomepage;
            {
                this.val$lblHomepage = linkLabel;
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    TmmUIHelper.browseUrl(this.val$lblHomepage.getNormalText());
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.val$lblHomepage.getNormalText(), "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        });
        this.contentPanel.add((Component)lblHomepage, "6, 12");
        JLabel lblThanksTo = new JLabel(BUNDLE.getString("tmm.thanksto"));
        this.contentPanel.add((Component)lblThanksTo, "2, 16, right, default");
        JLabel lblMyronForHelping = new JLabel("Myron for helping me with coding, scrapers, localization, setup, everything...");
        this.contentPanel.add((Component)lblMyronForHelping, "6, 16");
        JLabel lblXysm = new JLabel("xysm for excessive testing and lots of feedback");
        this.contentPanel.add((Component)lblXysm, "6, 18");
        JLabel lblXzener = new JLabel("Xzener for genre images");
        this.contentPanel.add((Component)lblXzener, "6, 20");
        JLabel lblMatthewSandersFor = new JLabel("Matthew Sanders for the cool export templates");
        this.contentPanel.add((Component)lblMatthewSandersFor, "6, 22");
        JLabel lblLblakya = new JLabel("Akya for the reworked logo");
        this.contentPanel.add((Component)lblLblakya, "6, 24");
        JPanel panelTranslators = new JPanel();
        this.contentPanel.add((Component)panelTranslators, "6, 26, fill, fill");
        panelTranslators.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200dlu:grow")}, new RowSpec[]{RowSpec.decode((String)"top:max(50dlu;pref)")}));
        JLabel lblTranslatorsT = new JLabel(BUNDLE.getString("tmm.translators"));
        panelTranslators.add((Component)lblTranslatorsT, "1, 1, right, top");
        JTextPane tpTranslators = new JTextPane();
        tpTranslators.setBorder(null);
        tpTranslators.setEditable(false);
        tpTranslators.setOpaque(false);
        tpTranslators.setText(TRANSLATORS);
        panelTranslators.add((Component)tpTranslators, "3, 1, fill, fill");
        JLabel lblLibs = new JLabel("The creators of all libs I've used");
        this.contentPanel.add((Component)lblLibs, "6, 28");
        JLabel lblTester = new JLabel("Everyone who tested and provided feedback");
        this.contentPanel.add((Component)lblTester, "6, 30");
        JPanel buttonPane = new JPanel();
        this.getContentPane().add((Component)buttonPane, "South");
        buttonPane.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow"), FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"23px"), FormFactory.RELATED_GAP_ROWSPEC}));
        JButton okButton = new JButton();
        okButton.setAction(this.action);
        buttonPane.add((Component)okButton, "2, 2, fill, top");
        this.getRootPane().setDefaultButton(okButton);
    }

    @Override
    public void pack() {
    }

    private class SwingAction
    extends AbstractAction {
        private static final long serialVersionUID = 4652946848116365706L;

        public SwingAction() {
            this.putValue("Name", BUNDLE.getString("Button.ok"));
            this.putValue("SmallIcon", IconManager.APPLY);
            this.putValue("SwingLargeIconKey", IconManager.APPLY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialog.this.setVisible(false);
        }
    }
}

