/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieMediaFileComparator;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetArtworkHelper;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public class MovieSet
extends MediaEntity {
    private static final Comparator<Movie> MOVIE_SET_COMPARATOR = new MovieInMovieSetComparator();
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new MovieMediaFileComparator();
    @JsonProperty
    private List<UUID> movieIds = new ArrayList<UUID>(0);
    private List<Movie> movies = new CopyOnWriteArrayList<Movie>();
    private String titleSortable = "";

    public MovieSet() {
    }

    public MovieSet(String title) {
        this();
        this.setTitle(title);
        MovieSetArtworkHelper.updateArtwork(this);
    }

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        for (UUID uuid : this.movieIds) {
            Movie movie = MovieList.getInstance().lookupMovie(uuid);
            if (movie == null) continue;
            this.movies.add(movie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTitle(String newValue) {
        super.setTitle(newValue);
        List<Movie> list = this.movies;
        synchronized (list) {
            for (Movie movie : this.movies) {
                movie.movieSetTitleChanged();
            }
        }
    }

    public String getTitleSortable() {
        if (StringUtils.isEmpty((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public int getTmdbId() {
        int id;
        try {
            id = (Integer)this.ids.get("tmdb");
        }
        catch (Exception e) {
            return 0;
        }
        return id;
    }

    public void setTmdbId(int newValue) {
        int oldValue = this.getTmdbId();
        this.ids.put("tmdb", newValue);
        this.firePropertyChange("tmdb", oldValue, newValue);
    }

    @Override
    public void setArtworkUrl(String url, MediaFileType type) {
        super.setArtworkUrl(url, type);
        MovieSetArtworkHelper.downloadArtwork(this, type);
    }

    public void setArtwork(List<MediaArtwork> artwork, MovieScraperMetadataConfig config) {
        if (config.isArtwork()) {
            MovieSetArtworkHelper.setArtwork(this, artwork);
        }
    }

    @Override
    public String getArtworkFilename(MediaFileType type) {
        Path artworkFile;
        String artworkUrl;
        String artworkFilename = super.getArtworkFilename(type);
        if (StringUtils.isBlank((CharSequence)artworkFilename) && StringUtils.isNotBlank((CharSequence)(artworkUrl = this.getArtworkUrl(type))) && Files.exists(artworkFile = ImageCache.getCacheDir().resolve(ImageCache.getMD5(artworkUrl)), new LinkOption[0])) {
            artworkFilename = artworkFile.toAbsolutePath().toString();
        }
        return artworkFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMovie(Movie movie) {
        List<Movie> list = this.movies;
        synchronized (list) {
            if (this.movies.contains(movie)) {
                return;
            }
            this.movies.add(movie);
            this.movieIds.add(movie.getDbId());
            MovieSetArtworkHelper.updateArtwork(this);
            this.saveToDb();
        }
        ArrayList<Movie> movies = new ArrayList<Movie>(1);
        movies.add(movie);
        if (MovieModuleManager.MOVIE_SETTINGS.isEnableMovieSetArtworkMovieFolder()) {
            MovieSetArtworkHelper.writeImagesToMovieFolder(this, movies);
        }
        this.firePropertyChange("addedMovie", null, movie);
        this.firePropertyChange("movies", null, movies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMovie(Movie movie) {
        List<Movie> list = this.movies;
        synchronized (list) {
            if (this.movies.contains(movie)) {
                return;
            }
            int index = Collections.binarySearch(this.movies, movie, MOVIE_SET_COMPARATOR);
            if (index < 0) {
                this.movies.add(-index - 1, movie);
                this.movieIds.add(-index - 1, movie.getDbId());
            } else if (index >= 0) {
                this.movies.add(index, movie);
                this.movieIds.add(index, movie.getDbId());
            }
            MovieSetArtworkHelper.updateArtwork(this);
            this.saveToDb();
        }
        ArrayList<Movie> movies = new ArrayList<Movie>(1);
        movies.add(movie);
        if (MovieModuleManager.MOVIE_SETTINGS.isEnableMovieSetArtworkMovieFolder()) {
            MovieSetArtworkHelper.writeImagesToMovieFolder(this, movies);
        }
        this.firePropertyChange("addedMovie", null, movie);
        this.firePropertyChange("movies", null, movies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMovie(Movie movie, boolean doCleanup) {
        if (doCleanup) {
            MovieSetArtworkHelper.cleanMovieSetArtworkInMovieFolder(movie);
        }
        if (movie.getMovieSet() != null) {
            movie.setMovieSet(null);
            movie.saveToDb();
        }
        List<Movie> list = this.movies;
        synchronized (list) {
            this.movies.remove(movie);
            this.movieIds.remove(movie.getDbId());
            if (doCleanup) {
                MovieSetArtworkHelper.updateArtwork(this);
            }
            this.saveToDb();
        }
        this.firePropertyChange("movies", null, this.movies);
        this.firePropertyChange("removedMovie", null, movie);
    }

    public List<Movie> getMovies() {
        return this.movies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortMovies() {
        List<Movie> list = this.movies;
        synchronized (list) {
            Utils.sortList(this.movies, MOVIE_SET_COMPARATOR);
            this.movieIds.clear();
            for (Movie movie : this.movies) {
                this.movieIds.add(movie.getDbId());
            }
        }
        this.firePropertyChange("movies", null, this.movies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMovies() {
        ArrayList<Movie> oldValue = new ArrayList<Movie>(this.movies);
        List<Movie> list = this.movies;
        synchronized (list) {
            for (Movie movie : this.movies) {
                MovieSetArtworkHelper.cleanMovieSetArtworkInMovieFolder(movie);
                if (movie.getMovieSet() == null) continue;
                movie.setMovieSet(null);
                movie.writeNFO();
                movie.saveToDb();
            }
            this.movies.clear();
            this.movieIds.clear();
            MovieSetArtworkHelper.updateArtwork(this);
            this.saveToDb();
        }
        this.firePropertyChange("movies", null, this.movies);
        this.firePropertyChange("removedAllMovies", oldValue, this.movies);
    }

    public String toString() {
        return this.getTitle();
    }

    public int getMovieIndex(Movie movie) {
        return this.movies.indexOf(movie);
    }

    public void rewriteAllImages() {
        List<MediaFileType> types = Arrays.asList(MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.LOGO, MediaFileType.CLEARLOGO, MediaFileType.CLEARART);
        for (MediaFileType type : types) {
            MovieSetArtworkHelper.downloadArtwork(this, type);
        }
    }

    public Boolean getHasImages() {
        if (!MovieModuleManager.MOVIE_SETTINGS.getMoviePosterFilenames().isEmpty() && StringUtils.isEmpty((CharSequence)this.getArtworkFilename(MediaFileType.POSTER))) {
            return false;
        }
        if (!MovieModuleManager.MOVIE_SETTINGS.getMovieFanartFilenames().isEmpty() && StringUtils.isEmpty((CharSequence)this.getArtworkFilename(MediaFileType.FANART))) {
            return false;
        }
        return true;
    }

    public List<Path> getImagesToCache() {
        ArrayList<Path> filesToCache = new ArrayList<Path>();
        if (StringUtils.isNotBlank((CharSequence)this.getArtworkFilename(MediaFileType.POSTER))) {
            filesToCache.add(Paths.get(this.getArtworkFilename(MediaFileType.POSTER), new String[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getArtworkFilename(MediaFileType.FANART))) {
            filesToCache.add(Paths.get(this.getArtworkFilename(MediaFileType.FANART), new String[0]));
        }
        return filesToCache;
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
    }

    @Override
    public void saveToDb() {
        MovieList.getInstance().persistMovieSet(this);
    }

    @Override
    public void deleteFromDb() {
        MovieList.getInstance().removeMovieSetFromDb(this);
    }

    public void cleanMovieSet() {
        MovieList movieList = MovieList.getInstance();
        boolean dirty = false;
        for (Movie movie : new ArrayList<Movie>(this.movies)) {
            if (movieList.getMovies().contains(movie)) continue;
            this.movies.remove(movie);
            this.movieIds.remove(movie.getDbId());
            dirty = true;
        }
        if (dirty) {
            this.saveToDb();
        }
    }

    private static class MovieInMovieSetComparator
    implements Comparator<Movie> {
        private MovieInMovieSetComparator() {
        }

        @Override
        public int compare(Movie o1, Movie o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            if (o1.getReleaseDate() != null && o2.getReleaseDate() != null) {
                return o1.getReleaseDate().compareTo(o2.getReleaseDate());
            }
            if (StringUtils.isNotBlank((CharSequence)o1.getYear()) && StringUtils.isNotBlank((CharSequence)o2.getYear())) {
                try {
                    int year1 = Integer.parseInt(o1.getYear());
                    int year2 = Integer.parseInt(o2.getYear());
                    return year1 - year2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 0;
        }
    }
}

