/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.scraper.http.Url;

public class UpdaterTask
extends SwingWorker<Boolean, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdaterTask.class);
    private static final String REGULAR_PATH = "/build";
    private static final String LEGACY_PATH = "/java6";
    private String changelog = "";
    private boolean forceUpdate = false;

    @Override
    public Boolean doInBackground() {
        if (ReleaseInfo.isGitBuild()) {
            return false;
        }
        File getdownFile = new File("getdown.txt");
        File digestFile = new File("digest.txt");
        ArrayList<String> updateUrls = new ArrayList<String>();
        try {
            Thread.currentThread().setName("updateThread");
            LOGGER.info("Checking for updates...");
            for (String line : UpdaterTask.readLines(new FileReader(getdownFile))) {
                String[] kv = line.split("=");
                if (!"appbase".equals(kv[0].trim()) && !"mirror".equals(kv[0].trim())) continue;
                updateUrls.add(kv[1].trim());
            }
            boolean valid = false;
            boolean changeReleasePath = false;
            String remoteDigest = "";
            String remoteUrl = "";
            for (String uu : updateUrls) {
                try {
                    if (!uu.endsWith("/")) {
                        uu = uu + '/';
                    }
                    if (uu.contains(LEGACY_PATH)) {
                        if (!SystemUtils.IS_JAVA_1_6) {
                            changeReleasePath = true;
                            uu = uu.replace(LEGACY_PATH, REGULAR_PATH);
                        }
                    } else if (SystemUtils.IS_JAVA_1_6) {
                        changeReleasePath = true;
                        uu = uu.replace(REGULAR_PATH, LEGACY_PATH);
                    }
                    Url upd = new Url(uu + "digest.txt?z=" + System.currentTimeMillis());
                    LOGGER.trace("Checking " + uu);
                    remoteDigest = IOUtils.toString((InputStream)upd.getInputStream(), (String)"UTF-8");
                    if (remoteDigest != null && remoteDigest.contains("tmm.jar")) {
                        remoteDigest = remoteDigest.trim();
                        valid = true;
                        remoteUrl = uu;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to download from mirror: " + e.getMessage());
                }
                if (!valid) continue;
                break;
            }
            if (!valid) {
                throw new Exception("Error downloading remote checksum information.");
            }
            String localDigest = FileUtils.readFileToString((File)digestFile, (String)"UTF-8");
            if (!(localDigest = localDigest.trim()).equals(remoteDigest)) {
                LOGGER.info("Update needed...");
                Url gd = new Url(remoteUrl + "getdown.txt?z=" + System.currentTimeMillis());
                String remoteGD = IOUtils.toString((InputStream)gd.getInputStream(), (String)"UTF-8");
                if (remoteGD.contains("forceUpdate")) {
                    this.forceUpdate = true;
                }
                if (changeReleasePath) {
                    LOGGER.debug("Switching distribution due to java versoin, preloading correct files.");
                    FileUtils.writeStringToFile((File)getdownFile, (String)remoteGD, (String)"UTF-8");
                    FileUtils.writeStringToFile((File)digestFile, (String)remoteDigest, (String)"UTF-8");
                }
                Url upd = new Url(remoteUrl + "changelog.txt?z=" + System.currentTimeMillis());
                this.changelog = IOUtils.toString((InputStream)upd.getInputStream(), (String)"UTF-8");
                return true;
            }
            LOGGER.info("Already up2date :)");
        }
        catch (Exception e) {
            LOGGER.error("Update task failed badly! " + e.getMessage());
            try {
                Url upd;
                InputStream is;
                LOGGER.info("Trying fallback...");
                String fallback = "http://www.tinymediamanager.org";
                if (SystemUtils.IS_JAVA_1_6) {
                    fallback = fallback + LEGACY_PATH;
                }
                if ((is = (upd = new Url(fallback = ReleaseInfo.isPreRelease() ? fallback + "/getdown_prerelease.txt" : (ReleaseInfo.isNightly() ? fallback + "/getdown_nightly.txt" : fallback + "/getdown.txt"))).getInputStream()) == null) {
                    throw new Exception("Server returned " + upd.getStatusCode() + "\nIf this error persists, please check forum!");
                }
                String gd = IOUtils.toString((InputStream)is, (String)"UTF-8");
                if (gd == null || gd.isEmpty() || !gd.contains("appbase")) {
                    throw new Exception("could not even download our fallback");
                }
                FileUtils.writeStringToFile((File)getdownFile, (String)gd);
                return true;
            }
            catch (Exception e2) {
                LOGGER.error("Update fallback failed!" + e2.getMessage());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "Update check failed :(", e2.getMessage()));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readLines(Reader in) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader bin = new BufferedReader(in);
            String line = null;
            while ((line = bin.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lines;
    }

    public String getChangelog() {
        return this.changelog;
    }

    public boolean isForcedUpdate() {
        return this.forceUpdate;
    }
}

