/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public enum MediaSource {
    TV("TV"),
    VHS("VHS"),
    DVD("DVD"),
    HDDVD("HDDVD"),
    BLURAY("Blu-ray"),
    HDRIP("HDRip"),
    CAM("Cam"),
    TS("Telesync"),
    TC("Telecine"),
    DVDSCR("DVD Screener"),
    R5("R5"),
    WEBRIP("Webrip"),
    WEB_DL("Web-DL"),
    STREAM("Stream"),
    UNKNOWN("Unknown");

    private static final String START_TOKEN = "[ .\\-_/\\\\\\[\\(]";
    private static final String END_TOKEN = "([ .\\-_/\\\\\\]\\)]|$)";
    private static Pattern blurayPattern;
    private static Pattern hdripPattern;
    private static Pattern hddvdPattern;
    private static Pattern dvdPattern;
    private static Pattern tvPattern;
    private static Pattern vhsPattern;
    private static Pattern camPattern;
    private static Pattern tsPattern;
    private static Pattern tcPattern;
    private static Pattern dvdscrPattern;
    private static Pattern r5Pattern;
    private static Pattern webripPattern;
    private static Pattern webdlPattern;
    private String title;

    private MediaSource(String title) {
        this.title = title;
    }

    public String toString() {
        return this.title;
    }

    public static MediaSource parseMediaSource(String filename) {
        String fn = filename.toLowerCase(Locale.ROOT);
        String ext = FilenameUtils.getExtension((String)fn);
        if (blurayPattern.matcher(fn).find()) {
            return BLURAY;
        }
        if (hdripPattern.matcher(fn).find()) {
            return HDRIP;
        }
        if (dvdPattern.matcher(fn).find()) {
            return DVD;
        }
        if (hddvdPattern.matcher(fn).find()) {
            return HDDVD;
        }
        if (tsPattern.matcher(fn).find()) {
            return TS;
        }
        if (dvdscrPattern.matcher(fn).find()) {
            return DVDSCR;
        }
        if (tvPattern.matcher(fn).find()) {
            return TV;
        }
        if (camPattern.matcher(fn).find()) {
            return CAM;
        }
        if (webripPattern.matcher(fn).find()) {
            return WEBRIP;
        }
        if (webdlPattern.matcher(fn).find()) {
            return WEB_DL;
        }
        if (vhsPattern.matcher(fn).find()) {
            return VHS;
        }
        if (tcPattern.matcher(fn).find()) {
            return TC;
        }
        if (r5Pattern.matcher(fn).find()) {
            return R5;
        }
        if (ext.equals("strm")) {
            return STREAM;
        }
        return UNKNOWN;
    }

    static {
        blurayPattern = Pattern.compile("[ .\\-_/\\\\\\[\\(](bluray|blueray|bdrip|brrip|dbrip|bd25|bd50|bdmv|blu\\-ray)([ .\\-_/\\\\\\]\\)]|$)");
        hdripPattern = Pattern.compile("[ .\\-_/\\\\\\[\\(](hdrip)([ .\\-_/\\\\\\]\\)]|$)");
        hddvdPattern = Pattern.compile("[ .\\-_/\\\\\\[\\(](hddvd|hddvdrip)([ .\\-_/\\\\\\]\\)]|$)");
        dvdPattern = Pattern.compile("[ .\\-_/\\\\\\[\\(](dvd|video_ts|dvdrip|dvdr|r5)([ .\\-_/\\\\\\]\\)]|$)");
        tvPattern = Pattern.compile("[ .\\-_/\\\\\\[\\(](hdtv|pdtv|dsr|dtv|hdtvrip|tvrip|dvbrip)([ .\\-_/\\\\\\]\\)]|$)");
        vhsPattern = Pattern.compile("[ .\\-_/\\\\\\[\\(](vhs)([ .\\-_/\\\\\\]\\)]|$)");
        camPattern = Pattern.compile("[ .\\-_/\\\\\\[\\(](cam)([ .\\-_/\\\\\\]\\)]|$)");
        tsPattern = Pattern.compile("[ .\\-_/\\\\\\[\\(](ts|telesync|hdts|ht\\-ts)([ .\\-_/\\\\\\]\\)]|$)");
        tcPattern = Pattern.compile("[ .\\-_/\\\\\\[\\(](tc|telecine|hdtc|ht\\-tc)([ .\\-_/\\\\\\]\\)]|$)");
        dvdscrPattern = Pattern.compile("[ .\\-_/\\\\\\[\\(](dvdscr)([ .\\-_/\\\\\\]\\)]|$)");
        r5Pattern = Pattern.compile("[ .\\-_/\\\\\\[\\(](r5)([ .\\-_/\\\\\\]\\)]|$)");
        webripPattern = Pattern.compile("[ .\\-_/\\\\\\[\\(](webrip)([ .\\-_/\\\\\\]\\)]|$)");
        webdlPattern = Pattern.compile("[ .\\-_/\\\\\\[\\(](web-dl|webdl)([ .\\-_/\\\\\\]\\)]|$)");
    }
}

