/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import org.tinymediamanager.scraper.entities.MediaArtwork;

public enum MediaFileType {
    VIDEO,
    VIDEO_EXTRA,
    TRAILER,
    SAMPLE,
    AUDIO,
    SUBTITLE,
    NFO,
    POSTER,
    FANART,
    BANNER,
    CLEARART,
    DISCART,
    LOGO,
    CLEARLOGO,
    THUMB,
    SEASON_POSTER,
    EXTRAFANART,
    EXTRATHUMB,
    GRAPHIC,
    MEDIAINFO,
    VSMETA,
    TEXT,
    UNKNOWN;


    public static MediaFileType getMediaFileType(MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case BACKGROUND: {
                return FANART;
            }
            case BANNER: {
                return BANNER;
            }
            case POSTER: {
                return POSTER;
            }
            case SEASON: {
                return SEASON_POSTER;
            }
            case THUMB: {
                return THUMB;
            }
            case CLEARART: {
                return CLEARART;
            }
            case LOGO: {
                return LOGO;
            }
            case CLEARLOGO: {
                return CLEARLOGO;
            }
            case DISC: {
                return DISCART;
            }
        }
        return GRAPHIC;
    }

    public static MediaArtwork.MediaArtworkType getMediaArtworkType(MediaFileType fileType) {
        switch (fileType) {
            case FANART: {
                return MediaArtwork.MediaArtworkType.BACKGROUND;
            }
            case BANNER: {
                return MediaArtwork.MediaArtworkType.BANNER;
            }
            case POSTER: {
                return MediaArtwork.MediaArtworkType.POSTER;
            }
            case SEASON_POSTER: {
                return MediaArtwork.MediaArtworkType.SEASON;
            }
            case THUMB: {
                return MediaArtwork.MediaArtworkType.THUMB;
            }
            case CLEARART: {
                return MediaArtwork.MediaArtworkType.CLEARART;
            }
            case LOGO: {
                return MediaArtwork.MediaArtworkType.LOGO;
            }
            case CLEARLOGO: {
                return MediaArtwork.MediaArtworkType.CLEARLOGO;
            }
            case DISCART: {
                return MediaArtwork.MediaArtworkType.DISC;
            }
        }
        throw new IllegalStateException();
    }

    public static MediaFileType[] getGraphicMediaFileTypes() {
        return new MediaFileType[]{FANART, POSTER, BANNER, CLEARART, DISCART, LOGO, CLEARLOGO, THUMB, SEASON_POSTER, EXTRAFANART, EXTRATHUMB};
    }
}

