/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

public class TvUtils {
    public static int getEpisodeNumber(Object ... numbers) {
        return TvUtils.getFirstValidNumber(-1, 1, numbers);
    }

    public static int getSeasonNumber(Object ... numbers) {
        return TvUtils.getFirstValidNumber(-1, 0, numbers);
    }

    public static int parseInt(Object ... numbers) {
        return TvUtils.getFirstValidNumber(0, 0, numbers);
    }

    static int getFirstValidNumber(int defaultValue, int minimumValue, Object ... numbers) {
        int nr = defaultValue;
        if (numbers != null) {
            for (Object o : numbers) {
                if (o == null || nr > minimumValue) continue;
                if (o instanceof String) {
                    String s = (String)o;
                    if (s.isEmpty()) continue;
                    try {
                        nr = Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        nr = (int)Math.floor(Double.parseDouble(s));
                    }
                    continue;
                }
                if (o instanceof Integer) {
                    nr = (Integer)o;
                    continue;
                }
                if (o instanceof Double) {
                    nr = (int)Math.floor((Double)o);
                    continue;
                }
                if (!(o instanceof Float)) continue;
                nr = (int)Math.floor(((Float)o).floatValue());
            }
        }
        if (nr < minimumValue) {
            nr = defaultValue;
        }
        return nr;
    }
}

