/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath.loader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import net.xeoh.plugins.base.impl.PluginManagerImpl;
import net.xeoh.plugins.base.impl.classpath.loader.FileLoader;
import net.xeoh.plugins.base.options.AddPluginsFromOption;

public class HTTPLoader
extends FileLoader {
    public HTTPLoader(PluginManagerImpl pluginManager) {
        super(pluginManager);
    }

    @Override
    public boolean handlesURI(URI uri) {
        return uri != null && "http".equals(uri.getScheme());
    }

    @Override
    public void loadFrom(URI url, AddPluginsFromOption[] options) {
        if ("http".equals(url.getScheme())) {
            try {
                File tmpFile = File.createTempFile("jspfplugindownload", ".jar");
                FileOutputStream fos = new FileOutputStream(tmpFile);
                URL url2 = url.toURL();
                InputStream openStream = url2.openStream();
                int read = 0;
                byte[] buf = new byte[1024];
                while ((read = openStream.read(buf)) > 0) {
                    fos.write(buf, 0, read);
                }
                fos.close();
                openStream.close();
                this.locateAllPluginsAt(tmpFile);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.warning("Error downloading plugins from " + url);
            }
        }
    }
}

