/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.utils.internal.processing;

import java.util.ListIterator;

public class NonNullIterator<T>
implements ListIterator<T> {
    private ListIterator<T> parent;
    private T next = null;
    private T previous = null;
    private int nextIndex = 0;
    private int previousIndex = -1;

    public NonNullIterator(ListIterator<T> listIterator) {
        this.parent = listIterator;
    }

    private void getNext() {
        this.next = null;
        while (this.parent.hasNext()) {
            this.nextIndex = this.parent.nextIndex();
            this.next = this.parent.next();
            if (this.next == null) continue;
            return;
        }
    }

    private void getPrevious() {
        this.previous = null;
        while (this.parent.hasPrevious()) {
            this.previousIndex = this.parent.previousIndex();
            this.previous = this.parent.previous();
            if (this.previous == null) continue;
            return;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        this.getNext();
        return this.next != null;
    }

    @Override
    public T next() {
        T t = this.next;
        this.previous = this.next;
        this.previousIndex = this.nextIndex;
        this.getNext();
        return t;
    }

    @Override
    public boolean hasPrevious() {
        if (this.previous != null) {
            return true;
        }
        this.getPrevious();
        return this.previous != null;
    }

    @Override
    public T previous() {
        T t = this.previous;
        this.next = this.previous;
        this.nextIndex = this.previousIndex;
        this.getPrevious();
        return t;
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    @Override
    public int previousIndex() {
        return this.previousIndex;
    }

    @Override
    public void remove() {
    }

    @Override
    public void set(T t) {
    }

    @Override
    public void add(T t) {
    }
}

