/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import org.fourthline.cling.model.DiscoveryOptions;
import org.fourthline.cling.model.gena.CancelReason;
import org.fourthline.cling.model.gena.GENASubscription;
import org.fourthline.cling.model.gena.LocalGENASubscription;
import org.fourthline.cling.model.meta.Device;
import org.fourthline.cling.model.meta.DeviceIdentity;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.meta.LocalService;
import org.fourthline.cling.model.resource.Resource;
import org.fourthline.cling.model.types.UDN;
import org.fourthline.cling.protocol.async.SendingNotificationByebye;
import org.fourthline.cling.registry.RegistrationException;
import org.fourthline.cling.registry.Registry;
import org.fourthline.cling.registry.RegistryImpl;
import org.fourthline.cling.registry.RegistryItem;
import org.fourthline.cling.registry.RegistryItems;
import org.fourthline.cling.registry.RegistryListener;

class LocalItems
extends RegistryItems<LocalDevice, LocalGENASubscription> {
    private static Logger log = Logger.getLogger(Registry.class.getName());
    protected Map<UDN, DiscoveryOptions> discoveryOptions = new HashMap<UDN, DiscoveryOptions>();
    protected long lastAliveIntervalTimestamp = 0L;
    protected Random randomGenerator = new Random();

    LocalItems(RegistryImpl registry) {
        super(registry);
    }

    protected void setDiscoveryOptions(UDN udn, DiscoveryOptions options) {
        if (options != null) {
            this.discoveryOptions.put(udn, options);
        } else {
            this.discoveryOptions.remove(udn);
        }
    }

    protected DiscoveryOptions getDiscoveryOptions(UDN udn) {
        return this.discoveryOptions.get(udn);
    }

    protected boolean isAdvertised(UDN udn) {
        return this.getDiscoveryOptions(udn) == null || this.getDiscoveryOptions(udn).isAdvertised();
    }

    protected boolean isByeByeBeforeFirstAlive(UDN udn) {
        return this.getDiscoveryOptions(udn) != null && this.getDiscoveryOptions(udn).isByeByeBeforeFirstAlive();
    }

    @Override
    void add(LocalDevice localDevice) throws RegistrationException {
        this.add(localDevice, null);
    }

    void add(final LocalDevice localDevice, DiscoveryOptions options) throws RegistrationException {
        this.setDiscoveryOptions(((DeviceIdentity)localDevice.getIdentity()).getUdn(), options);
        if (this.registry.getDevice(((DeviceIdentity)localDevice.getIdentity()).getUdn(), false) != null) {
            log.fine("Ignoring addition, device already registered: " + localDevice);
            return;
        }
        log.fine("Adding local device to registry: " + localDevice);
        for (Resource deviceResource : this.getResources(localDevice)) {
            if (this.registry.getResource(deviceResource.getPathQuery()) != null) {
                throw new RegistrationException("URI namespace conflict with already registered resource: " + deviceResource);
            }
            this.registry.addResource(deviceResource);
            log.fine("Registered resource: " + deviceResource);
        }
        log.fine("Adding item to registry with expiration in seconds: " + ((DeviceIdentity)localDevice.getIdentity()).getMaxAgeSeconds());
        RegistryItem<UDN, LocalDevice> localItem = new RegistryItem<UDN, LocalDevice>(((DeviceIdentity)localDevice.getIdentity()).getUdn(), localDevice, ((DeviceIdentity)localDevice.getIdentity()).getMaxAgeSeconds());
        this.getDeviceItems().add(localItem);
        log.fine("Registered local device: " + localItem);
        if (this.isByeByeBeforeFirstAlive(localItem.getKey())) {
            this.advertiseByebye(localDevice, true);
        }
        if (this.isAdvertised(localItem.getKey())) {
            this.advertiseAlive(localDevice);
        }
        for (final RegistryListener listener : this.registry.getListeners()) {
            this.registry.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.localDeviceAdded(LocalItems.this.registry, localDevice);
                }
            });
        }
    }

    @Override
    Collection<LocalDevice> get() {
        HashSet c = new HashSet();
        for (RegistryItem item : this.getDeviceItems()) {
            c.add(item.getItem());
        }
        return Collections.unmodifiableCollection(c);
    }

    @Override
    boolean remove(LocalDevice localDevice) throws RegistrationException {
        return this.remove(localDevice, false);
    }

    boolean remove(final LocalDevice localDevice, boolean shuttingDown) throws RegistrationException {
        LocalDevice registeredDevice = (LocalDevice)this.get(((DeviceIdentity)localDevice.getIdentity()).getUdn(), true);
        if (registeredDevice != null) {
            log.fine("Removing local device from registry: " + localDevice);
            this.setDiscoveryOptions(((DeviceIdentity)localDevice.getIdentity()).getUdn(), null);
            this.getDeviceItems().remove(new RegistryItem(((DeviceIdentity)localDevice.getIdentity()).getUdn()));
            for (Resource deviceResource : this.getResources(localDevice)) {
                if (!this.registry.removeResource(deviceResource)) continue;
                log.fine("Unregistered resource: " + deviceResource);
            }
            Iterator it = this.getSubscriptionItems().iterator();
            while (it.hasNext()) {
                final RegistryItem incomingSubscription = it.next();
                UDN subscriptionForUDN = ((DeviceIdentity)((Device)((LocalService)((LocalGENASubscription)incomingSubscription.getItem()).getService()).getDevice()).getIdentity()).getUdn();
                if (!subscriptionForUDN.equals(((DeviceIdentity)registeredDevice.getIdentity()).getUdn())) continue;
                log.fine("Removing incoming subscription: " + incomingSubscription.getKey());
                it.remove();
                if (shuttingDown) continue;
                this.registry.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        ((LocalGENASubscription)incomingSubscription.getItem()).end(CancelReason.DEVICE_WAS_REMOVED);
                    }
                });
            }
            if (this.isAdvertised(((DeviceIdentity)localDevice.getIdentity()).getUdn())) {
                this.advertiseByebye(localDevice, !shuttingDown);
            }
            if (!shuttingDown) {
                for (final RegistryListener listener : this.registry.getListeners()) {
                    this.registry.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.localDeviceRemoved(LocalItems.this.registry, localDevice);
                        }
                    });
                }
            }
            return true;
        }
        return false;
    }

    @Override
    void removeAll() {
        this.removeAll(false);
    }

    void removeAll(boolean shuttingDown) {
        LocalDevice[] allDevices;
        for (LocalDevice device : allDevices = this.get().toArray(new LocalDevice[this.get().size()])) {
            this.remove(device, shuttingDown);
        }
    }

    public void advertiseLocalDevices() {
        for (RegistryItem localItem : this.deviceItems) {
            if (!this.isAdvertised((UDN)localItem.getKey())) continue;
            this.advertiseAlive((LocalDevice)localItem.getItem());
        }
    }

    @Override
    void maintain() {
        if (this.getDeviceItems().isEmpty()) {
            return;
        }
        HashSet expiredLocalItems = new HashSet();
        int aliveIntervalMillis = this.registry.getConfiguration().getAliveIntervalMillis();
        if (aliveIntervalMillis > 0) {
            long now = System.currentTimeMillis();
            if (now - this.lastAliveIntervalTimestamp > (long)aliveIntervalMillis) {
                this.lastAliveIntervalTimestamp = now;
                for (RegistryItem localItem : this.getDeviceItems()) {
                    if (!this.isAdvertised(localItem.getKey())) continue;
                    log.finer("Flooding advertisement of local item: " + localItem);
                    expiredLocalItems.add(localItem);
                }
            }
        } else {
            this.lastAliveIntervalTimestamp = 0L;
            for (RegistryItem registryItem : this.getDeviceItems()) {
                if (!this.isAdvertised(registryItem.getKey()) || !registryItem.getExpirationDetails().hasExpired(true)) continue;
                log.finer("Local item has expired: " + registryItem);
                expiredLocalItems.add(registryItem);
            }
        }
        for (RegistryItem registryItem : expiredLocalItems) {
            log.fine("Refreshing local device advertisement: " + registryItem.getItem());
            this.advertiseAlive((LocalDevice)registryItem.getItem());
            registryItem.getExpirationDetails().stampLastRefresh();
        }
        HashSet expiredIncomingSubscriptions = new HashSet();
        for (RegistryItem registryItem : this.getSubscriptionItems()) {
            if (!registryItem.getExpirationDetails().hasExpired(false)) continue;
            expiredIncomingSubscriptions.add(registryItem);
        }
        for (RegistryItem registryItem : expiredIncomingSubscriptions) {
            log.fine("Removing expired: " + registryItem);
            this.removeSubscription((GENASubscription)registryItem.getItem());
            ((LocalGENASubscription)registryItem.getItem()).end(CancelReason.EXPIRED);
        }
    }

    @Override
    void shutdown() {
        log.fine("Clearing all registered subscriptions to local devices during shutdown");
        this.getSubscriptionItems().clear();
        log.fine("Removing all local devices from registry during shutdown");
        this.removeAll(true);
    }

    protected void advertiseAlive(final LocalDevice localDevice) {
        this.registry.executeAsyncProtocol(new Runnable(){

            @Override
            public void run() {
                try {
                    log.finer("Sleeping some milliseconds to avoid flooding the network with ALIVE msgs");
                    Thread.sleep(LocalItems.this.randomGenerator.nextInt(100));
                }
                catch (InterruptedException ex) {
                    log.severe("Background execution interrupted: " + ex.getMessage());
                }
                LocalItems.this.registry.getProtocolFactory().createSendingNotificationAlive(localDevice).run();
            }
        });
    }

    protected void advertiseByebye(LocalDevice localDevice, boolean asynchronous) {
        SendingNotificationByebye prot = this.registry.getProtocolFactory().createSendingNotificationByebye(localDevice);
        if (asynchronous) {
            this.registry.executeAsyncProtocol(prot);
        } else {
            prot.run();
        }
    }
}

