/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.profile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.fourthline.cling.model.meta.DeviceDetails;
import org.fourthline.cling.model.profile.DeviceDetailsProvider;
import org.fourthline.cling.model.profile.RemoteClientInfo;

public class HeaderDeviceDetailsProvider
implements DeviceDetailsProvider {
    private final DeviceDetails defaultDeviceDetails;
    private final Map<Key, DeviceDetails> headerDetails;

    public HeaderDeviceDetailsProvider(DeviceDetails defaultDeviceDetails) {
        this(defaultDeviceDetails, null);
    }

    public HeaderDeviceDetailsProvider(DeviceDetails defaultDeviceDetails, Map<Key, DeviceDetails> headerDetails) {
        this.defaultDeviceDetails = defaultDeviceDetails;
        this.headerDetails = headerDetails != null ? headerDetails : new HashMap();
    }

    public DeviceDetails getDefaultDeviceDetails() {
        return this.defaultDeviceDetails;
    }

    public Map<Key, DeviceDetails> getHeaderDetails() {
        return this.headerDetails;
    }

    @Override
    public DeviceDetails provide(RemoteClientInfo info) {
        if (info == null || info.getRequestHeaders().isEmpty()) {
            return this.getDefaultDeviceDetails();
        }
        for (Key key : this.getHeaderDetails().keySet()) {
            List headerValues = info.getRequestHeaders().get(key.getHeaderName());
            if (headerValues == null) continue;
            for (String headerValue : headerValues) {
                if (!key.isValuePatternMatch(headerValue)) continue;
                return this.getHeaderDetails().get(key);
            }
        }
        return this.getDefaultDeviceDetails();
    }

    public static class Key {
        final String headerName;
        final String valuePattern;
        final Pattern pattern;

        public Key(String headerName, String valuePattern) {
            this.headerName = headerName;
            this.valuePattern = valuePattern;
            this.pattern = Pattern.compile(valuePattern, 2);
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public String getValuePattern() {
            return this.valuePattern;
        }

        public boolean isValuePatternMatch(String value) {
            return this.pattern.matcher(value).matches();
        }
    }
}

