/*
 * Decompiled with CFR 0.152.
 */
package org.japura.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class WeakList<T>
implements List<T> {
    private final ReferenceQueue<T> queue = new ReferenceQueue();
    private final List<WeakReference<T>> list = new ArrayList<WeakReference<T>>();

    @Override
    public boolean add(T obj) {
        this.expunge();
        return this.list.add(new WeakReference<T>(obj, this.queue));
    }

    @Override
    public T get(int index) {
        this.expunge();
        return this.list.get(index).get();
    }

    @Override
    public int size() {
        this.expunge();
        return this.list.size();
    }

    @Override
    public T remove(int index) {
        this.expunge();
        return this.list.remove(index).get();
    }

    @Override
    public boolean isEmpty() {
        this.expunge();
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.expunge();
        for (WeakReference<T> wr : this.list) {
            if (!wr.get().equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        this.expunge();
        Object[] array = new Object[this.list.size()];
        int index = 0;
        for (WeakReference<T> wr : this.list) {
            array[index] = wr.get();
            ++index;
        }
        return array;
    }

    @Override
    public boolean remove(Object o) {
        this.expunge();
        WeakReference<T> removeMe = null;
        for (WeakReference<T> wr : this.list) {
            if (!wr.get().equals(o)) continue;
            removeMe = wr;
            break;
        }
        if (removeMe != null) {
            return this.list.remove(removeMe);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.expunge();
        int count = 0;
        block0: for (Object obj : c) {
            for (WeakReference<T> wr : this.list) {
                if (!wr.get().equals(obj)) continue;
                ++count;
                continue block0;
            }
        }
        return c.size() == count;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.expunge();
        for (T obj : c) {
            this.list.add(new WeakReference<T>(obj, this.queue));
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.expunge();
        for (T obj : c) {
            this.list.add(index, new WeakReference<T>(obj, this.queue));
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.expunge();
        ArrayList<WeakReference<T>> removeList = new ArrayList<WeakReference<T>>();
        block0: for (Object obj : c) {
            for (WeakReference<T> wr : this.list) {
                if (obj.equals(wr.get())) continue;
                removeList.add(wr);
                continue block0;
            }
        }
        return this.list.removeAll(removeList);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.expunge();
        ArrayList<WeakReference<T>> removeList = new ArrayList<WeakReference<T>>();
        for (WeakReference<T> wr : this.list) {
            if (c.contains(wr.get())) continue;
            removeList.add(wr);
        }
        this.list.removeAll(removeList);
        return removeList.size() > 0;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public T set(int index, T element) {
        this.expunge();
        WeakReference<T> p = this.list.set(index, new WeakReference<T>(element, this.queue));
        return p.get();
    }

    @Override
    public void add(int index, T element) {
        this.expunge();
        this.list.add(index, new WeakReference<T>(element, this.queue));
    }

    @Override
    public int indexOf(Object o) {
        this.expunge();
        for (int i = 0; i < this.list.size(); ++i) {
            WeakReference<T> wr = this.list.get(i);
            if (!wr.get().equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        WeakReference<T> wr;
        int i;
        this.expunge();
        for (i = this.list.size() - 1; i > -1 && !(wr = this.list.get(i)).get().equals(o); --i) {
        }
        return i;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        this.expunge();
        List<WeakReference<T>> sw = this.list.subList(fromIndex, toIndex);
        ArrayList sl = new ArrayList();
        for (WeakReference<T> wr : sw) {
            sl.add(wr.get());
        }
        return sl;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public Iterator<T> iterator() {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new RuntimeException("method not implemented");
    }

    private void expunge() {
        Reference<T> garbagedObj = this.queue.poll();
        while (garbagedObj != null) {
            int index = this.list.indexOf(garbagedObj);
            if (index != -1) {
                this.list.remove(index);
            }
            garbagedObj = this.queue.poll();
        }
    }
}

