/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetRemoveAction
extends AbstractAction {
    private static final long serialVersionUID = -9030996266835702009L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSetRemoveAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("movieset.remove.desc"));
        }
        this.putValue("SwingLargeIconKey", IconManager.LIST_REMOVE);
        this.putValue("SmallIcon", IconManager.LIST_REMOVE);
        this.putValue("ShortDescription", BUNDLE.getString("movieset.remove.desc"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<MovieSet> selectedMovieSets = MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovieSets();
        for (int i = 0; i < selectedMovieSets.size(); ++i) {
            MovieSet movieSet = selectedMovieSets.get(i);
            MovieList.getInstance().removeMovieSet(movieSet);
        }
    }
}

