/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowExporter
extends MediaEntityExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowExporter.class);

    public TvShowExporter(Path pathToTemplate) throws Exception {
        super(pathToTemplate, MediaEntityExporter.TemplateType.TV_SHOW);
    }

    @Override
    public <T extends MediaEntity> void export(List<T> tvShowsToExport, Path exportDir) throws Exception {
        LOGGER.info("preparing tv show export; using " + this.properties.getProperty("name"));
        this.engine.registerNamedRenderer((NamedRenderer)new MediaEntityExporter.NamedDateRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new TvShowFilenameRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new ArtworkCopyRenderer(exportDir));
        if (!Files.exists(exportDir, new LinkOption[0])) {
            try {
                Files.createDirectories(exportDir, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new Exception("error creating export directory");
            }
        }
        Path listExportFile = null;
        if (this.fileExtension.equalsIgnoreCase("html")) {
            listExportFile = exportDir.resolve("index.html");
        }
        if (this.fileExtension.equalsIgnoreCase("xml")) {
            listExportFile = exportDir.resolve("tvshows.xml");
        }
        if (this.fileExtension.equalsIgnoreCase("csv")) {
            listExportFile = exportDir.resolve("tvshows.csv");
        }
        if (listExportFile == null) {
            throw new Exception("error creating tv show list file");
        }
        String episodeTemplateFile = this.properties.getProperty("episode");
        String episodeTemplate = "";
        if (StringUtils.isNotBlank((CharSequence)episodeTemplateFile)) {
            episodeTemplate = Utils.readFileToString(this.templateDir.resolve(episodeTemplateFile));
        }
        LOGGER.info("generating tv show list");
        Utils.deleteFileSafely(listExportFile);
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("tvShows", new ArrayList<T>(tvShowsToExport));
        String output = this.engine.transform(this.listTemplate, root);
        Utils.writeStringToFile(listExportFile, output);
        LOGGER.info("movie list generated: " + listExportFile);
        if (StringUtils.isNotBlank((CharSequence)this.detailTemplate)) {
            for (MediaEntity me : tvShowsToExport) {
                TvShow show = (TvShow)me;
                Path showDir = exportDir.resolve(TvShowExporter.getFilename(show));
                Files.createDirectory(showDir, new FileAttribute[0]);
                Path detailsExportFile = showDir.resolve("tvshow." + this.fileExtension);
                root = new HashMap();
                root.put("tvShow", show);
                output = this.engine.transform(this.detailTemplate, root);
                Utils.writeStringToFile(detailsExportFile, output);
                if (!StringUtils.isNotBlank((CharSequence)episodeTemplate)) continue;
                for (TvShowEpisode episode : show.getEpisodes()) {
                    List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
                    if (mfs.isEmpty()) continue;
                    Path seasonDir = showDir.resolve(TvShowRenamer.generateSeasonDir("", episode));
                    if (!Files.isDirectory(seasonDir, new LinkOption[0])) {
                        Files.createDirectory(seasonDir, new FileAttribute[0]);
                    }
                    String episodeFileName = TvShowExporter.getFilename(episode) + "." + this.fileExtension;
                    Path episodeExportFile = seasonDir.resolve(episodeFileName);
                    root = new HashMap();
                    root.put("episode", episode);
                    output = this.engine.transform(episodeTemplate, root);
                    Utils.writeStringToFile(episodeExportFile, output);
                }
            }
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.templateDir);){
            for (Path path : directoryStream) {
                if (Utils.isRegularFile(path)) {
                    if (path.getFileName().toString().endsWith(".jmte") || path.getFileName().toString().endsWith("template.conf")) continue;
                    Files.copy(path, exportDir.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                Utils.copyDirectoryRecursive(path, exportDir.resolve(path.getFileName()));
            }
        }
        catch (IOException ex) {
            LOGGER.error("could not copy resources: ", (Throwable)ex);
        }
    }

    private static String getFilename(MediaEntity entity) {
        if (entity instanceof TvShow) {
            return TvShowRenamer.createDestination("$N ($Y)", (TvShow)entity, new ArrayList<TvShowEpisode>());
        }
        if (entity instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)entity;
            List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
            return FilenameUtils.getBaseName((String)TvShowRenamer.generateFilename(episode.getTvShow(), mfs.get(0)));
        }
        return "";
    }

    private class ArtworkCopyRenderer
    implements NamedRenderer {
        private Path pathToExport;

        public ArtworkCopyRenderer(Path pathToExport) {
            this.pathToExport = pathToExport;
        }

        public RenderFormatInfo getFormatInfo() {
            return null;
        }

        public String getName() {
            return "copyArtwork";
        }

        public Class<?>[] getSupportedClasses() {
            return new Class[]{TvShow.class, TvShowEpisode.class};
        }

        public String render(Object o, String pattern, Locale locale) {
            if (o instanceof TvShow || o instanceof TvShowEpisode) {
                MediaFile mf;
                MediaEntity entity = (MediaEntity)o;
                Map<Object, Object> parameters = new HashMap();
                if (pattern != null) {
                    parameters = this.parseParameters(pattern);
                }
                if ((mf = entity.getArtworkMap().get(parameters.get("type"))) == null || !mf.isGraphic()) {
                    return null;
                }
                String filename = TvShowExporter.getFilename(entity) + "-" + (Object)((Object)mf.getType());
                Path imageDir = StringUtils.isNotBlank((CharSequence)((String)parameters.get("destination"))) ? this.pathToExport.resolve((String)parameters.get("destination")) : this.pathToExport;
                try {
                    if (!Files.exists(imageDir, new LinkOption[0])) {
                        Files.createDirectory(imageDir, new FileAttribute[0]);
                    }
                    if (parameters.get("thumb") == Boolean.TRUE) {
                        filename = filename + ".thumb." + FilenameUtils.getExtension((String)mf.getFilename());
                        int width = 150;
                        if (parameters.get("width") != null) {
                            width = (Integer)parameters.get("width");
                        }
                        InputStream is = ImageCache.scaleImage(mf.getFileAsPath(), width);
                        Files.copy(is, imageDir.resolve(filename), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        filename = filename + "." + FilenameUtils.getExtension((String)mf.getFilename());
                        Files.copy(mf.getFileAsPath(), imageDir.resolve(filename), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("could not copy artwork file: ", (Throwable)e);
                    return "";
                }
                return filename;
            }
            return null;
        }

        private Map<String, Object> parseParameters(String parameters) {
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("thumb", Boolean.FALSE);
            parameterMap.put("destination", "images");
            String[] details = parameters.split(",");
            block16: for (int x = 0; x < details.length; ++x) {
                String key = "";
                String value = "";
                try {
                    String[] d = details[x].split("=");
                    key = d[0].trim();
                    value = d[1].trim();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{key, value})) continue;
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "type": {
                        MediaFileType type = MediaFileType.valueOf(value.toUpperCase(Locale.ROOT));
                        if (type == null) continue block16;
                        parameterMap.put(key, (Object)type);
                        continue block16;
                    }
                    case "destination": {
                        parameterMap.put("destination", value);
                        continue block16;
                    }
                    case "thumb": {
                        parameterMap.put(key, Boolean.parseBoolean(value));
                        continue block16;
                    }
                    case "width": {
                        try {
                            parameterMap.put(key, Integer.parseInt(value));
                        }
                        catch (Exception e) {}
                        continue block16;
                    }
                }
            }
            return parameterMap;
        }
    }

    public static class TvShowFilenameRenderer
    implements NamedRenderer {
        public RenderFormatInfo getFormatInfo() {
            return null;
        }

        public String getName() {
            return "filename";
        }

        public Class<?>[] getSupportedClasses() {
            return new Class[]{TvShow.class};
        }

        public String render(Object o, String pattern, Locale locale) {
            if (o instanceof TvShow) {
                TvShow show = (TvShow)o;
                return TvShowRenamer.generateTvShowDir(show);
            }
            return null;
        }
    }
}

