/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.threading;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;

public abstract class TmmThreadPool
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmThreadPool.class);
    private ThreadPoolExecutor pool = null;
    private CompletionService<Object> service = null;
    protected String poolname;

    protected TmmThreadPool(String taskName) {
        super(taskName, 0, TmmTaskHandle.TaskType.MAIN_TASK);
    }

    protected void initThreadPool(int threads, String name) {
        this.cancel = false;
        this.poolname = name;
        this.pool = new ThreadPoolExecutor(threads, threads, 2L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new TmmThreadFactory(name));
        this.pool.allowCoreThreadTimeOut(true);
        this.service = new ExecutorCompletionService<Object>(this.pool);
    }

    protected synchronized void submitTask(Callable<Object> task) {
        if (!this.cancel) {
            ++this.workUnits;
            this.service.submit(task);
        }
    }

    protected synchronized void submitTask(Runnable task) {
        if (!this.cancel) {
            ++this.workUnits;
            this.service.submit(task, "");
        }
    }

    protected void waitForCompletionOrCancel() {
        this.pool.shutdown();
        while (!this.cancel && !this.pool.isTerminated() && this.progressDone < this.workUnits) {
            try {
                Future<Object> future = this.service.take();
                ++this.progressDone;
                this.callback(future.get());
            }
            catch (InterruptedException e) {
                LOGGER.error("ThreadPool " + this.poolname + " interrupted!");
            }
            catch (ExecutionException e) {
                LOGGER.error("ThreadPool " + this.poolname + ": Error getting result!", (Throwable)e);
            }
        }
        if (this.cancel) {
            try {
                LOGGER.info("Abort queue (discarding " + (this.workUnits - this.progressDone) + " tasks)");
                this.pool.getQueue().clear();
                this.pool.awaitTermination(3L, TimeUnit.SECONDS);
                this.pool.shutdown();
            }
            catch (InterruptedException e) {
                LOGGER.error("ThreadPool " + this.poolname + " interrupted in shutdown!", (Throwable)e);
            }
        }
    }

    public abstract void callback(Object var1);

    static class TmmThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        TmmThreadFactory(String poolname) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "tmmpool-" + poolname + "-T";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

