/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LaunchUtil.class);
    private static final String USR_BIN_JAVA = "/usr/bin/java";

    public static String getJVMPath() {
        return LaunchUtil.getJVMPath(false);
    }

    public static String getJVMPath(boolean windebug) {
        String vmpath = LaunchUtil.checkJVMPath(System.getProperty("java.home"), windebug);
        if (vmpath == null) {
            LOGGER.warn("Unable to find java [java.home=" + System.getProperty("java.home") + "]!");
            vmpath = "java";
        }
        if (Platform.isMac()) {
            try {
                File localVM = new File(USR_BIN_JAVA).getCanonicalFile();
                if (localVM.equals(new File(vmpath).getCanonicalFile())) {
                    vmpath = USR_BIN_JAVA;
                }
            }
            catch (IOException ioe) {
                LOGGER.warn("Failed to check Mac OS canonical VM path.", (Throwable)ioe);
            }
        }
        return vmpath;
    }

    protected static String checkJVMPath(String vmhome, boolean windebug) {
        String vmbase = vmhome + File.separator + "bin" + File.separator;
        String vmpath = vmbase + "java";
        if (new File(vmpath).exists()) {
            return vmpath;
        }
        if (!windebug && new File(vmpath = vmbase + "javaw.exe").exists()) {
            return vmpath;
        }
        vmpath = vmbase + "java.exe";
        if (new File(vmpath).exists()) {
            return vmpath;
        }
        return null;
    }
}

