/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipInputStream;
import net.jcores.jre.CommonCore;
import net.jcores.jre.cores.CoreObject;
import net.jcores.jre.cores.CoreString;
import net.jcores.jre.cores.adapter.AbstractAdapter;
import net.jcores.jre.interfaces.functions.F1;
import net.jcores.jre.options.MessageType;
import net.jcores.jre.options.Option;
import net.jcores.jre.utils.internal.Streams;
import net.jcores.jre.utils.internal.wrapper.InputStreamWrapper;

public class CoreZipInputStream
extends CoreObject<ZipInputStream> {
    private static final long serialVersionUID = 5934382074823292082L;
    private boolean multipleGet = false;

    public CoreZipInputStream(CommonCore commonCore, ZipInputStream ... zipInputStreamArray) {
        super(commonCore, zipInputStreamArray);
    }

    public CoreZipInputStream(CommonCore commonCore, AbstractAdapter<ZipInputStream> abstractAdapter) {
        super(commonCore, abstractAdapter);
    }

    public CoreZipInputStream unzip(final String string) {
        this.map(new F1<ZipInputStream, Void>(){

            @Override
            public Void f(ZipInputStream zipInputStream) {
                try {
                    Streams.doUnzip(zipInputStream, string);
                    zipInputStream.close();
                }
                catch (IOException iOException) {
                    CoreZipInputStream.this.commonCore.report(MessageType.EXCEPTION, "IO error processing " + iOException + ".");
                }
                return null;
            }
        }, new Option[0]);
        return this;
    }

    public CoreString dir() {
        return this.map(new F1<ZipInputStream, List<String>>(){

            @Override
            public List<String> f(ZipInputStream zipInputStream) {
                try {
                    List<String> list = Streams.list(zipInputStream);
                    zipInputStream.close();
                    return list;
                }
                catch (IOException iOException) {
                    CoreZipInputStream.this.commonCore.report(MessageType.EXCEPTION, "IO error processing " + iOException + ".");
                    return null;
                }
            }
        }, new Option[0]).expand(String.class).as(CoreString.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream get(String string) {
        ZipInputStream zipInputStream;
        if (this.multipleGet) {
            this.commonCore.report(MessageType.MISUSE, "You must not call get() on a ZipStream multiple times! Latter calls might fail. Check the documentation.");
        }
        if ((zipInputStream = (ZipInputStream)this.get(false)) == null) {
            return null;
        }
        try {
            final InputStream inputStream = Streams.getInputStream(zipInputStream, string);
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(inputStream){

                @Override
                public void close() throws IOException {
                    super.close();
                    inputStream.close();
                }
            };
            return inputStreamWrapper;
        }
        catch (IOException iOException) {
        }
        finally {
            this.multipleGet = true;
        }
        return null;
    }
}

