/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.japura.gui.CheckComboBox;
import org.japura.gui.model.ListCheckModel;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieSubtitleDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.SubtitleSearchOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.mediaprovider.IMediaSubtitleProvider;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.movies.MovieSubtitleChooserModel;

public class MovieSubtitleChooserDialog
extends TmmDialog {
    private static final long serialVersionUID = -3104541519073924724L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final MovieList movieList = MovieList.getInstance();
    private final Movie movieToScrape;
    private final MediaFile fileToScrape;
    private SearchTask activeSearchTask = null;
    private EventList<MovieSubtitleChooserModel> subtitleEventList = null;
    private DefaultEventTableModel<MovieSubtitleChooserModel> subtitleTableModel = null;
    private final boolean inQueue;
    private boolean continueQueue = true;
    private JTable tableSubs;
    private JTextField tfSearchQuery;
    private JComboBox<MediaLanguages> cbLanguage;
    private CheckComboBox cbScraper;
    private JLabel lblProgressAction;
    private JProgressBar progressBar;

    public MovieSubtitleChooserDialog(Movie movie, MediaFile mediaFile, boolean inQueue) {
        super(BUNDLE.getString("moviesubtitlechooser.search"), "movieSubtitleChooser");
        this.setBounds(5, 5, 712, 429);
        this.movieToScrape = movie;
        this.fileToScrape = mediaFile;
        this.inQueue = inQueue;
        this.subtitleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(MovieSubtitleChooserModel.class)));
        this.subtitleTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.subtitleEventList), (TableFormat)new SubtitleTableFormat());
        this.initComponents();
        LinkListener linkListener = new LinkListener();
        this.tableSubs.addMouseListener(linkListener);
        this.tableSubs.addMouseMotionListener(linkListener);
        this.tableSubs.setAutoResizeMode(0);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableSubs, 7);
        this.cbScraper.setTextFor(CheckComboBox.NONE, BUNDLE.getString("scraper.selected.none"));
        this.cbScraper.setTextFor(CheckComboBox.MULTIPLE, BUNDLE.getString("scraper.selected.multiple"));
        this.cbScraper.setTextFor(CheckComboBox.ALL, BUNDLE.getString("scraper.selected.all"));
        ListCheckModel model = this.cbScraper.getModel();
        for (MediaScraper scraper : this.movieList.getAvailableSubtitleScrapers()) {
            model.addElement(new Object[]{scraper});
            if (!MovieModuleManager.MOVIE_SETTINGS.getMovieSubtitleScrapers().contains(scraper.getId())) continue;
            model.addCheck(new Object[]{scraper});
        }
        for (MediaLanguages language : MediaLanguages.values()) {
            this.cbLanguage.addItem(language);
            if (language != MovieModuleManager.MOVIE_SETTINGS.getSubtitleScraperLanguage()) continue;
            this.cbLanguage.setSelectedItem(language);
        }
        this.searchSubtitle(this.fileToScrape.getFileAsPath().toFile(), this.movieToScrape.getImdbId(), this.tfSearchQuery.getText());
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"120dlu:grow"), FormSpecs.RELATED_GAP_ROWSPEC}));
        JLabel lblMovieTitle = new JLabel(this.movieToScrape.getTitle());
        TmmFontHelper.changeFont(lblMovieTitle, 1.33, 1);
        panelContent.add((Component)lblMovieTitle, "2, 2, 9, 1");
        JLabel lblMediaFileNameT = new JLabel(BUNDLE.getString("metatag.filename"));
        panelContent.add((Component)lblMediaFileNameT, "2, 4, right, default");
        JLabel lblMediaFileName = new JLabel(this.fileToScrape.getFilename());
        panelContent.add((Component)lblMediaFileName, "4, 4, 7, 1");
        JLabel lblRuntimeT = new JLabel(BUNDLE.getString("metatag.runtime"));
        panelContent.add((Component)lblRuntimeT, "2, 6, right, default");
        JLabel lblRuntime = new JLabel(this.fileToScrape.getDurationHHMMSS());
        panelContent.add((Component)lblRuntime, "4, 6");
        JLabel lblImdbIdT = new JLabel(BUNDLE.getString("metatag.imdb"));
        panelContent.add((Component)lblImdbIdT, "6, 6, right, default");
        JLabel lblImdbId = new JLabel(this.movieToScrape.getImdbId());
        panelContent.add((Component)lblImdbId, "8, 6");
        JLabel lblScraperT = new JLabel(BUNDLE.getString("scraper"));
        panelContent.add((Component)lblScraperT, "2, 8, right, default");
        this.cbScraper = new MediaScraperCheckComboBox();
        panelContent.add((Component)this.cbScraper, "4, 8, fill, default");
        this.tfSearchQuery = new JTextField(this.movieToScrape.getTitle());
        panelContent.add((Component)this.tfSearchQuery, "6, 8, 3, 1, fill, default");
        this.tfSearchQuery.setColumns(10);
        JButton btnSearch = new JButton(BUNDLE.getString("Button.search"));
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieSubtitleChooserDialog.this.searchSubtitle(null, "", MovieSubtitleChooserDialog.this.tfSearchQuery.getText());
            }
        });
        panelContent.add((Component)btnSearch, "10, 8");
        JLabel lblLanguageT = new JLabel(BUNDLE.getString("metatag.language"));
        panelContent.add((Component)lblLanguageT, "2, 10, right, default");
        this.cbLanguage = new JComboBox();
        this.cbLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieSubtitleChooserDialog.this.searchSubtitle(null, "", MovieSubtitleChooserDialog.this.tfSearchQuery.getText());
            }
        });
        panelContent.add(this.cbLanguage, "4, 10, fill, default");
        JScrollPane scrollPaneSubs = new JScrollPane();
        panelContent.add((Component)scrollPaneSubs, "2, 12, 9, 1, fill, fill");
        this.tableSubs = new JTable((TableModel)this.subtitleTableModel);
        this.tableSubs.setDefaultRenderer(ImageIcon.class, new Renderer());
        scrollPaneSubs.setViewportView(this.tableSubs);
        JPanel panelBottom = new JPanel();
        this.getContentPane().add((Component)panelBottom, "South");
        panelBottom.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"max(82dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC}));
        this.progressBar = new JProgressBar();
        panelBottom.add((Component)this.progressBar, "2, 2");
        this.lblProgressAction = new JLabel("");
        panelBottom.add((Component)this.lblProgressAction, "4, 2");
        JPanel panelButtons = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        panelButtons.setLayout(layout);
        panelBottom.add((Component)panelButtons, "5, 2, fill, fill");
        JButton btnDone = new JButton(BUNDLE.getString("Button.close"));
        btnDone.setIcon(IconManager.APPLY);
        btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieSubtitleChooserDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnDone);
        if (this.inQueue) {
            JButton btnAbortQueue = new JButton(BUNDLE.getString("Button.abortqueue"));
            btnAbortQueue.setIcon(IconManager.PROCESS_STOP);
            btnAbortQueue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MovieSubtitleChooserDialog.this.continueQueue = false;
                    MovieSubtitleChooserDialog.this.setVisible(false);
                }
            });
            panelButtons.add(btnAbortQueue);
        }
    }

    private void searchSubtitle(File file, String imdbId, String searchTerm) {
        if (this.activeSearchTask != null && !this.activeSearchTask.isDone()) {
            this.activeSearchTask.cancel();
        }
        ArrayList<MediaScraper> scrapers = new ArrayList<MediaScraper>();
        ListCheckModel model = this.cbScraper.getModel();
        for (Object checked : model.getCheckeds()) {
            if (checked == null || !(checked instanceof MediaScraper)) continue;
            scrapers.add((MediaScraper)checked);
        }
        this.activeSearchTask = new SearchTask(file, imdbId, searchTerm, scrapers);
        this.activeSearchTask.execute();
    }

    private void startProgressBar(final String description) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MovieSubtitleChooserDialog.this.lblProgressAction.setText(description);
                MovieSubtitleChooserDialog.this.progressBar.setVisible(true);
                MovieSubtitleChooserDialog.this.progressBar.setIndeterminate(true);
            }
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MovieSubtitleChooserDialog.this.lblProgressAction.setText("");
                MovieSubtitleChooserDialog.this.progressBar.setVisible(false);
                MovieSubtitleChooserDialog.this.progressBar.setIndeterminate(false);
            }
        });
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    private class LinkListener
    implements MouseListener,
    MouseMotionListener {
        private LinkListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(new Point(e.getX(), e.getY()));
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                row = table.convertRowIndexToModel(row);
                MovieSubtitleChooserModel model = (MovieSubtitleChooserModel)MovieSubtitleChooserDialog.this.subtitleEventList.get(row);
                if (StringUtils.isNotBlank((CharSequence)model.getDownloadUrl())) {
                    String lang = LanguageStyle.getLanguageCodeForStyle(model.getLanguage().name(), MovieModuleManager.MOVIE_SETTINGS.getMovieRenamerLanguageStyle());
                    if (StringUtils.isBlank((CharSequence)lang)) {
                        lang = model.getLanguage().name();
                    }
                    MovieSubtitleDownloadTask task = new MovieSubtitleDownloadTask(model.getDownloadUrl(), MovieSubtitleChooserDialog.this.fileToScrape.getFileAsPath(), lang, MovieSubtitleChooserDialog.this.movieToScrape);
                    TmmTaskManager.getInstance().addDownloadTask(task);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0) {
                table.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && table.getCursor().getType() == 12) {
                table.setCursor(new Cursor(0));
            }
            if (col == 0 && table.getCursor().getType() == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }
    }

    private class Renderer
    extends DefaultTableCellRenderer {
        private final JLabel downloadLabel = new JLabel(MovieSubtitleChooserDialog.access$800().getString("Button.download"), IconManager.DOWNLOAD, 0);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == IconManager.DOWNLOAD) {
                return this.downloadLabel;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class SubtitleTableFormat
    implements AdvancedTableFormat<MovieSubtitleChooserModel> {
        private SubtitleTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return BUNDLE.getString("metatag.title");
                }
                case 2: {
                    return BUNDLE.getString("metatag.releasename");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(MovieSubtitleChooserModel model, int column) {
            switch (column) {
                case 0: {
                    return IconManager.DOWNLOAD;
                }
                case 1: {
                    return model.getName();
                }
                case 2: {
                    return model.getReleaseName();
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return ImageIcon.class;
                }
                case 1: 
                case 2: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int arg0) {
            return null;
        }
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private File file;
        private String searchTerm;
        private String imdbId;
        private List<SubtitleSearchResult> searchResults;
        private MediaLanguages language;
        private List<MediaScraper> scrapers;
        boolean cancel;

        public SearchTask(File file, String imdbId, String searchTerm, List<MediaScraper> scrapers) {
            this.file = file;
            this.searchTerm = searchTerm;
            this.imdbId = imdbId;
            this.language = (MediaLanguages)MovieSubtitleChooserDialog.this.cbLanguage.getSelectedItem();
            this.searchResults = new ArrayList<SubtitleSearchResult>();
            this.scrapers = scrapers;
            this.cancel = false;
        }

        @Override
        public Void doInBackground() {
            MovieSubtitleChooserDialog.this.startProgressBar(BUNDLE.getString("chooser.searchingfor") + " " + this.searchTerm);
            for (MediaScraper scraper : this.scrapers) {
                try {
                    IMediaSubtitleProvider subtitleProvider = (IMediaSubtitleProvider)scraper.getMediaProvider();
                    SubtitleSearchOptions options = new SubtitleSearchOptions(this.file, this.searchTerm);
                    options.setImdbId(this.imdbId);
                    options.setLanguage(LocaleUtils.toLocale((String)this.language.name()));
                    this.searchResults.addAll(subtitleProvider.search(options));
                }
                catch (Exception exception) {}
            }
            Collections.sort(this.searchResults);
            Collections.reverse(this.searchResults);
            return null;
        }

        public void cancel() {
            this.cancel = true;
        }

        @Override
        public void done() {
            if (!this.cancel) {
                MovieSubtitleChooserDialog.this.subtitleEventList.clear();
                if (this.searchResults == null || this.searchResults.size() == 0) {
                    MovieSubtitleChooserDialog.this.subtitleEventList.add((Object)MovieSubtitleChooserModel.EMPTY_RESULT);
                } else {
                    for (SubtitleSearchResult result : this.searchResults) {
                        MovieSubtitleChooserDialog.this.subtitleEventList.add((Object)new MovieSubtitleChooserModel(result, this.language));
                    }
                }
                if (!MovieSubtitleChooserDialog.this.subtitleEventList.isEmpty()) {
                    MovieSubtitleChooserDialog.this.tableSubs.setRowSelectionInterval(0, 0);
                }
                TableColumnResizer.adjustColumnPreferredWidths(MovieSubtitleChooserDialog.this.tableSubs, 15);
            }
            MovieSubtitleChooserDialog.this.stopProgressBar();
        }
    }
}

